/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.power.alternator;

import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.power.batteries.AbstractBatteryBlock;
import com.zombie_cute.mc.bakingdelight.screen.custom.PhotovoltaicGeneratorScreenHandler;
import com.zombie_cute.mc.bakingdelight.util.ModConfig;
import com.zombie_cute.mc.bakingdelight.util.block_util.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.Power;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.PowerStorageAble;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class PhotovoltaicGeneratorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
PowerStorageAble {
    public final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(30000L, 1000L, 1000L){

        protected void onFinalCommit() {
            PhotovoltaicGeneratorBlockEntity.this.method_5431();
        }
    };
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final Power power = new Power(3000L);
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PhotovoltaicGeneratorBlockEntity.this.isWorking;
                case 1 -> (int)PhotovoltaicGeneratorBlockEntity.this.getPowerValue();
                case 2 -> (int)PhotovoltaicGeneratorBlockEntity.this.getPower().getMaxPower();
                case 3 -> PhotovoltaicGeneratorBlockEntity.this.slowMode;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    PhotovoltaicGeneratorBlockEntity.this.isWorking = value;
                    break;
                }
                case 1: {
                    PhotovoltaicGeneratorBlockEntity.this.setPower(value);
                    break;
                }
                case 3: {
                    PhotovoltaicGeneratorBlockEntity.this.slowMode = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private int isWorking = 0;
    private int slowMode = 0;
    public static final String PHOTOVOLTAIC_GENERATOR_NAME = "display_name.bakingdelight.photovoltaic_generator_name";

    public PhotovoltaicGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.PHOTOVOLTAIC_GENERATOR_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, PhotovoltaicGeneratorBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (world.method_8510() % 20L == 0L) {
            class_1799 itemStack = blockEntity.method_5438(0);
            blockEntity.method_5447(0, AbstractBatteryBlock.changeBatteryPower(itemStack, this.energyStorage, 80L, true));
            int light = world.method_8314(class_1944.field_9282, this.field_11867) / 3 - 1;
            if (light > 0) {
                blockEntity.addEnergy((long)light * 10L);
                blockEntity.slowMode = 1;
            } else {
                blockEntity.slowMode = 0;
            }
            if (this.isInOpenAir(world)) {
                if (PhotovoltaicGeneratorBlockEntity.isEarlyMorningOrTwilight(world)) {
                    blockEntity.addPowerAndCheck(1, world);
                    blockEntity.isWorking = world.method_8546() || world.method_8419() ? 0 : 1;
                } else if (PhotovoltaicGeneratorBlockEntity.isMorningOrAfternoon(world)) {
                    blockEntity.addPowerAndCheck(2, world);
                    blockEntity.isWorking = world.method_8546() ? 0 : 1;
                } else if (PhotovoltaicGeneratorBlockEntity.isNoon(world)) {
                    blockEntity.addPowerAndCheck(3, world);
                    blockEntity.isWorking = 1;
                } else {
                    blockEntity.isWorking = 0;
                }
            } else {
                blockEntity.isWorking = 0;
            }
            this.method_5431();
        }
        this.setPower(this.getEnergyStorage().amount / 10L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPowerAndCheck(int multiplier, class_1937 world) {
        int y = this.field_11867.method_10264() / 2;
        double var = (float)multiplier * PhotovoltaicGeneratorBlockEntity.getMultiplier();
        if (var <= 0.0) {
            return;
        }
        if (world.method_8546()) {
            if (!(var - 3.0 >= 0.0)) return;
            var -= 3.0;
        } else if (world.method_8419()) {
            var -= 1.0;
        }
        if (y / 10 > 0) {
            this.addEnergy((long)(var * (double)y));
            return;
        } else {
            this.addEnergy((long)(var * 10.0));
        }
    }

    private boolean isInOpenAir(class_1937 world) {
        return world.method_8314(class_1944.field_9284, this.field_11867) >= 13 && !world.method_8597().method_29960() && !world.method_8320(this.field_11867.method_10084()).method_26206((class_1922)world, this.field_11867.method_10084(), class_2350.field_11033);
    }

    public static boolean isEarlyMorningOrTwilight(class_1937 world) {
        long timeOfDay = world.method_8532() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 167L || timeOfDay >= 11617L && timeOfDay < 13702L || timeOfDay >= 23000L;
    }

    public static boolean isMorningOrAfternoon(class_1937 world) {
        long timeOfDay = world.method_8532() % 24000L;
        return timeOfDay >= 167L && timeOfDay < 4283L || timeOfDay >= 7700L && timeOfDay < 11617L;
    }

    public static boolean isNoon(class_1937 world) {
        long timeOfDay = world.method_8532() % 24000L;
        return timeOfDay >= 4283L && timeOfDay < 7700L;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10544("photovoltaic_generator.power", this.getPower().getPowerValue());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.setPower(nbt.method_10537("photovoltaic_generator.power"));
        this.energyStorage.amount = nbt.method_10537("photovoltaic_generator.power") * 10L;
        this.method_5431();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)PHOTOVOLTAIC_GENERATOR_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new PhotovoltaicGeneratorScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public Power getPower() {
        return this.power;
    }

    @Override
    public SimpleEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public static float getMultiplier() {
        try {
            float value = ModConfig.photovoltaicGeneratorMultiplier;
            if (value > 0.0f) {
                return value;
            }
            return 2.0f;
        }
        catch (Throwable e) {
            return 2.0f;
        }
    }
}

