/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.power.batteries;

import com.zombie_cute.mc.bakingdelight.ModernDelightMain;
import com.zombie_cute.mc.bakingdelight.block.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.block.power.batteries.BatteryBlockEntity;
import com.zombie_cute.mc.bakingdelight.util.MiscUtil;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.Power;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public abstract class AbstractBatteryBlock
extends class_2237 {
    public AbstractBatteryBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public abstract long getMaxPower();

    public static long getBatteryPower(class_1799 batteryItem) {
        class_2487 nbt;
        class_1747 blockItem;
        class_1792 class_17922 = batteryItem.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof AbstractBatteryBlock && (nbt = class_1747.method_38072((class_1799)batteryItem)) != null && nbt.method_10545("battery.power")) {
            return nbt.method_10537("battery.power");
        }
        return 0L;
    }

    public static void changeBatteryPower(class_1799 batteryItem, long value, boolean isAdd) {
        class_1747 blockItem;
        class_1792 class_17922 = batteryItem.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof AbstractBatteryBlock) {
            class_2487 nbtCompound = class_1747.method_38072((class_1799)batteryItem);
            if (nbtCompound != null) {
                if (nbtCompound.method_10545("battery.power")) {
                    long batteryPower = nbtCompound.method_10537("battery.power");
                    long maxBatteryPower = nbtCompound.method_10537("battery.maxPower");
                    if (isAdd) {
                        if (batteryPower + value < maxBatteryPower) {
                            AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower += value, batteryItem);
                        } else if (batteryPower < maxBatteryPower) {
                            AbstractBatteryBlock.changeBatteryNBT(nbtCompound, ++batteryPower, batteryItem);
                        }
                    } else if (batteryPower - value > 0L) {
                        AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower -= value, batteryItem);
                    } else if (batteryPower > 0L) {
                        AbstractBatteryBlock.changeBatteryNBT(nbtCompound, --batteryPower, batteryItem);
                    }
                }
            } else {
                class_2487 newNBT = AbstractBatteryBlock.initNbtCompound(blockItem);
                class_1747.method_38073((class_1799)batteryItem, ModBlockEntities.BATTERY_BLOCK_ENTITY, (class_2487)newNBT);
                AbstractBatteryBlock.changeBatteryPower(batteryItem, value, isAdd);
            }
        }
    }

    public static class_1799 changeBatteryPower(class_1799 oldBatteryItemStack, Power thisPower, long valueEP, boolean isAddBatteryPower) {
        class_1747 blockItem;
        if (valueEP < 0L) {
            ModernDelightMain.LOGGER.error("Exception battery power value: \"{}\" is not a positive number!", (Object)valueEP);
        }
        class_1799 newStack = oldBatteryItemStack.method_7972();
        class_1792 class_17922 = oldBatteryItemStack.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof AbstractBatteryBlock) {
            class_2487 nbtCompound = class_1747.method_38072((class_1799)oldBatteryItemStack);
            if (nbtCompound != null) {
                if (nbtCompound.method_10545("battery.power")) {
                    long batteryPower = nbtCompound.method_10537("battery.power");
                    long maxBatteryPower = nbtCompound.method_10537("battery.maxPower");
                    if (isAddBatteryPower) {
                        if (batteryPower + valueEP < maxBatteryPower && thisPower.getPowerValue() >= valueEP) {
                            thisPower.reducePower(valueEP);
                            AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower += valueEP, newStack);
                        } else if (batteryPower < maxBatteryPower && thisPower.getPowerValue() >= 1L) {
                            thisPower.reducePower(1L);
                            AbstractBatteryBlock.changeBatteryNBT(nbtCompound, ++batteryPower, newStack);
                        }
                    } else if (batteryPower - valueEP > 0L && thisPower.getPowerValue() + valueEP <= thisPower.getMaxPower()) {
                        thisPower.addPower(valueEP);
                        AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower -= valueEP, newStack);
                    } else if (batteryPower > 0L && thisPower.getPowerValue() != thisPower.getMaxPower()) {
                        thisPower.addPower(1L);
                        AbstractBatteryBlock.changeBatteryNBT(nbtCompound, --batteryPower, newStack);
                    }
                }
            } else {
                class_2487 newNBT = AbstractBatteryBlock.initNbtCompound(blockItem);
                class_1747.method_38073((class_1799)newStack, ModBlockEntities.BATTERY_BLOCK_ENTITY, (class_2487)newNBT);
                return AbstractBatteryBlock.changeBatteryPower(newStack, thisPower, valueEP, isAddBatteryPower);
            }
        }
        return newStack;
    }

    public static void addEnergy(long value, SimpleEnergyStorage energyStorage) {
        energyStorage.amount = energyStorage.amount + value < energyStorage.capacity ? (energyStorage.amount += value) : energyStorage.capacity;
    }

    public static void reduceEnergy(long value, SimpleEnergyStorage energyStorage) {
        energyStorage.amount = energyStorage.amount - value > 0L ? (energyStorage.amount -= value) : 0L;
    }

    public static class_1799 changeBatteryPower(class_1799 oldBatteryItemStack, SimpleEnergyStorage thisPower, long valueEP, boolean isAddBatteryPower) {
        class_1747 blockItem;
        if (valueEP < 0L) {
            ModernDelightMain.LOGGER.error("Exception battery energy value: \"{}\" is not a positive number!", (Object)valueEP);
        }
        class_1799 newStack = oldBatteryItemStack.method_7972();
        class_1792 class_17922 = oldBatteryItemStack.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof AbstractBatteryBlock) {
            class_2487 nbtCompound = class_1747.method_38072((class_1799)oldBatteryItemStack);
            if (nbtCompound != null) {
                if (nbtCompound.method_10545("battery.power")) {
                    long batteryPower = nbtCompound.method_10537("battery.power");
                    long maxBatteryPower = nbtCompound.method_10537("battery.maxPower");
                    if (isAddBatteryPower) {
                        if (batteryPower + valueEP <= maxBatteryPower) {
                            if (thisPower.amount >= valueEP * 10L) {
                                AbstractBatteryBlock.reduceEnergy(valueEP * 10L, thisPower);
                                AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower += valueEP, newStack);
                            } else if (thisPower.amount >= 10L) {
                                AbstractBatteryBlock.reduceEnergy(10L, thisPower);
                                AbstractBatteryBlock.changeBatteryNBT(nbtCompound, ++batteryPower, newStack);
                            }
                        } else {
                            long consumedPower = maxBatteryPower - batteryPower;
                            if (consumedPower > 0L) {
                                if (thisPower.amount >= consumedPower * 10L) {
                                    AbstractBatteryBlock.reduceEnergy(consumedPower * 10L, thisPower);
                                    AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower += consumedPower, newStack);
                                } else if (thisPower.amount >= 10L) {
                                    AbstractBatteryBlock.reduceEnergy(10L, thisPower);
                                    AbstractBatteryBlock.changeBatteryNBT(nbtCompound, ++batteryPower, newStack);
                                }
                            }
                        }
                    } else if (thisPower.amount + valueEP * 10L <= thisPower.capacity) {
                        if (batteryPower - valueEP > 0L) {
                            AbstractBatteryBlock.addEnergy(valueEP * 10L, thisPower);
                            AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower -= valueEP, newStack);
                        } else if (batteryPower > 0L) {
                            AbstractBatteryBlock.addEnergy(10L, thisPower);
                            AbstractBatteryBlock.changeBatteryNBT(nbtCompound, --batteryPower, newStack);
                        }
                    } else {
                        long consumedPower = (thisPower.capacity - thisPower.amount) / 10L;
                        if (consumedPower > 0L) {
                            if (batteryPower >= consumedPower) {
                                AbstractBatteryBlock.addEnergy(consumedPower * 10L, thisPower);
                                AbstractBatteryBlock.changeBatteryNBT(nbtCompound, batteryPower -= consumedPower, newStack);
                            } else if (batteryPower > 0L) {
                                AbstractBatteryBlock.addEnergy(10L, thisPower);
                                AbstractBatteryBlock.changeBatteryNBT(nbtCompound, --batteryPower, newStack);
                            }
                        }
                    }
                }
            } else {
                class_2487 newNBT = AbstractBatteryBlock.initNbtCompound(blockItem);
                class_1747.method_38073((class_1799)newStack, ModBlockEntities.BATTERY_BLOCK_ENTITY, (class_2487)newNBT);
                return AbstractBatteryBlock.changeBatteryPower(newStack, thisPower, valueEP, isAddBatteryPower);
            }
        }
        return newStack;
    }

    private static void changeBatteryNBT(class_2487 nbtCompound, long batteryPower, class_1799 newStack) {
        nbtCompound.method_10544("battery.power", batteryPower);
        class_1747.method_38073((class_1799)newStack, ModBlockEntities.BATTERY_BLOCK_ENTITY, (class_2487)nbtCompound);
    }

    @NotNull
    private static class_2487 initNbtCompound(class_1747 blockItem) {
        class_2487 newNBT = new class_2487();
        newNBT.method_10544("battery.power", 0L);
        AbstractBatteryBlock block = (AbstractBatteryBlock)blockItem.method_7711();
        newNBT.method_10544("battery.maxPower", block.getMaxPower());
        return newNBT;
    }

    public boolean method_9533(class_1927 explosion) {
        return false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
        super.method_9586(world, pos, explosion);
        if (!world.field_9236) {
            world.method_8537(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 2.0f, true, class_1937.class_7867.field_40889);
        }
    }

    protected abstract class_2248 getBlock();

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BatteryBlockEntity) {
            BatteryBlockEntity blockEntity = (BatteryBlockEntity)class_25862;
            if (!world.field_9236) {
                class_1799 itemStack = new class_1799((class_1935)this.getBlock());
                blockEntity.method_38240(itemStack);
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (MiscUtil.isPlayerHoldingCrowbar(player) && player.method_5715()) {
            world.method_22352(pos, true);
        }
        return class_1269.field_21466;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BatteryBlockEntity) {
            BatteryBlockEntity blockEntity = (BatteryBlockEntity)class_25862;
            return (int)(blockEntity.getPower().getPowerValue() * 15L / blockEntity.getPower().getMaxPower());
        }
        return 0;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return AbstractBatteryBlock.method_31618(type, ModBlockEntities.BATTERY_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos));
    }
}

