/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.item.tools;

import com.zombie_cute.mc.bakingdelight.item.ModItems;
import com.zombie_cute.mc.bakingdelight.item.food.PackagedItem;
import com.zombie_cute.mc.bakingdelight.item.tools.ElectricWhiskItemRenderer;
import com.zombie_cute.mc.bakingdelight.recipe.custom.WhiskingRecipe;
import com.zombie_cute.mc.bakingdelight.sound.ModSounds;
import com.zombie_cute.mc.bakingdelight.util.TextUtil;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.DCConsumer;
import com.zombie_cute.mc.bakingdelight.util.block_util.power_util.Power;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_756;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class ElectricWhiskItem
extends class_1792
implements GeoItem,
DCConsumer {
    public static final int MAX_POWER = 500;
    public boolean isWorking = false;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation WORKING = RawAnimation.begin().thenLoop("working");

    public ElectricWhiskItem() {
        super((class_1792.class_1793)new FabricItemSettings().maxCount(1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        ElectricWhiskItem.getNBTPower(stack);
        super.method_7843(stack, world, player);
    }

    public static void addNBTPower(class_1799 itemStack, long value) {
        if (itemStack.method_31574(ModItems.ELECTRIC_WHISK)) {
            class_2487 nbt = itemStack.method_7969();
            if (nbt == null) {
                nbt = new class_2487();
            }
            if (nbt.method_10545("power")) {
                long i = nbt.method_10537("power");
                if (value >= 0L) {
                    i = Math.min(value + i, 500L);
                }
                nbt.method_10544("power", i);
            } else if (value >= 0L) {
                nbt.method_10544("power", Math.min(value, 500L));
            }
            itemStack.method_7980(nbt);
        }
    }

    public static void reduceNBTPower(class_1799 itemStack, long value) {
        if (itemStack.method_31574(ModItems.ELECTRIC_WHISK)) {
            class_2487 nbt = itemStack.method_7969();
            if (nbt == null) {
                nbt = new class_2487();
            }
            if (nbt.method_10545("power")) {
                long i = nbt.method_10537("power");
                if (value >= 0L) {
                    i = Math.max(i - value, 0L);
                }
                nbt.method_10544("power", i);
            } else {
                nbt.method_10544("power", 0L);
            }
            itemStack.method_7980(nbt);
        }
    }

    public static long getNBTPower(class_1799 itemStack) {
        if (itemStack.method_31574(ModItems.ELECTRIC_WHISK)) {
            class_2487 nbt = itemStack.method_7969();
            if (nbt == null) {
                nbt = new class_2487();
            }
            if (nbt.method_10545("power")) {
                return nbt.method_10537("power");
            }
            nbt.method_10544("power", 0L);
            itemStack.method_7980(nbt);
            return 0L;
        }
        return 0L;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"toolTipText.bakingdelight.battery_name").method_27692(class_124.field_1063));
        tooltip.add((class_2561)class_2561.method_43470((String)(ElectricWhiskItem.getNBTPower(stack) + "/500 EP")).method_27692(class_124.field_1080));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)TextUtil.getShiftText(true));
            tooltip.add((class_2561)TextUtil.getAltText(false));
            tooltip.add((class_2561)class_2561.method_43470((String)" "));
            tooltip.addAll(TextUtil.generateToolTip((class_2561)class_2561.method_43471((String)"bakingdelight.tooltips.electric_whisk")));
        } else if (class_437.method_25443()) {
            tooltip.add((class_2561)TextUtil.getShiftText(false));
            tooltip.add((class_2561)TextUtil.getAltText(true));
            tooltip.add((class_2561)class_2561.method_43470((String)" "));
            tooltip.add((class_2561)TextUtil.getDCCom("2"));
            tooltip.add((class_2561)TextUtil.getDCSto(String.valueOf(500)));
        } else {
            tooltip.add((class_2561)TextUtil.getShiftText(false));
            tooltip.add((class_2561)TextUtil.getAltText(false));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final ElectricWhiskItemRenderer renderer = new ElectricWhiskItemRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (((ElectricWhiskItem)state.getAnimatable()).isWorking()) {
                return state.setAndContinue(WORKING);
            }
            return state.setAndContinue(IDLE);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public void modifyNearbyItemEntities(class_1657 player, class_1799 stack, class_1937 world) {
        double reachDistance;
        class_243 lookDirection;
        class_243 endVec;
        class_243 eyePosition = player.method_5836(1.0f);
        class_3959 context = new class_3959(eyePosition, endVec = eyePosition.method_1019((lookDirection = player.method_5828(1.0f).method_1029()).method_1021(reachDistance = 5.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player);
        class_3965 hitResult = world.method_17742(context);
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        double radius = 5.0;
        List itemEntities = world.method_8390(class_1542.class, player.method_5829().method_1014(radius), entity -> entity != null && entity.method_5805());
        for (class_1542 itemEntity : itemEntities) {
            class_243 itemPosition = itemEntity.method_19538();
            class_243 toItem = itemPosition.method_1020(eyePosition).method_1029();
            if (!(lookDirection.method_1026(toItem) > 0.99)) continue;
            this.tryModifyItemEntity(itemEntity, stack, world, player);
        }
    }

    private void tryModifyItemEntity(class_1542 itemEntity, class_1799 stack, class_1937 world, class_1657 player) {
        if (stack.method_31574(ModItems.ELECTRIC_WHISK)) {
            class_1799 oldStack = itemEntity.method_6983();
            long power = ElectricWhiskItem.getNBTPower(stack);
            int count = oldStack.method_7947();
            if ((long)count * 2L > power) {
                player.method_7353((class_2561)class_2561.method_43471((String)"bakingdelight.msg.electric_whisk"), true);
                return;
            }
            class_2338 blockPos = itemEntity.method_24515();
            class_1277 inventory = new class_1277(1);
            inventory.method_5447(0, oldStack);
            Optional match = world.method_8433().method_8132((class_3956)WhiskingRecipe.Type.INSTANCE, (class_1263)inventory, world);
            if (match.isPresent()) {
                class_1799 newStack = new class_1799((class_1935)((WhiskingRecipe)match.get()).method_8110(null).method_7909(), count);
                if (newStack.method_7909() instanceof PackagedItem) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"bakingdelight.msg.electric_whisk.need_bowl"), true);
                    return;
                }
                ElectricWhiskItem.playAnimation(stack);
                world.method_43128(null, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), ModSounds.ITEM_ELECTRIC_WHISK_WORKING, class_3419.field_15248, 1.0f, 1.0f);
                itemEntity.method_6979(newStack);
                itemEntity.method_6976();
                class_243 currentVelocity = itemEntity.method_18798();
                class_243 newVelocity = new class_243(currentVelocity.field_1352 - 0.125 + world.field_9229.method_43058() / 4.0, 0.2, currentVelocity.field_1350 - 0.125 + world.field_9229.method_43058() / 4.0);
                class_1792 class_17922 = oldStack.method_7909();
                if (class_17922 instanceof PackagedItem) {
                    PackagedItem packagedItem = (PackagedItem)class_17922;
                    class_1264.method_5449((class_1937)world, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)new class_1799((class_1935)packagedItem.getPackageItem(), count));
                }
                itemEntity.method_18799(newVelocity);
                ElectricWhiskItem.reduceNBTPower(stack, (long)count * 2L);
            }
        }
    }

    public static void playAnimation(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ElectricWhiskItem) {
            ElectricWhiskItem item = (ElectricWhiskItem)class_17922;
            if (!item.isWorking()) {
                item.setWorking(true);
            }
            scheduler.schedule(() -> class_310.method_1551().execute(() -> item.setWorking(false)), 1L, TimeUnit.SECONDS);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        this.modifyNearbyItemEntities(user, user.method_5998(hand), world);
        return super.method_7836(world, user, hand);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void setWorking(boolean working) {
        this.isWorking = working;
    }

    @Override
    public Power getPower(class_1799 stack) {
        Power power = new Power(500L);
        power.setPowerValue(ElectricWhiskItem.getNBTPower(stack));
        return power;
    }

    @Override
    public void addPower(class_1799 stack, long value) {
        ElectricWhiskItem.addNBTPower(stack, value);
    }

    @Override
    public void reducePower(class_1799 stack, long value) {
        ElectricWhiskItem.reduceNBTPower(stack, value);
    }

    public int method_31569(class_1799 stack) {
        if (ElectricWhiskItem.getNBTPower(stack) == 0L) {
            return 0;
        }
        return (int)Math.min(1.0 + 12.0 * (double)ElectricWhiskItem.getNBTPower(stack) / 500.0, 13.0);
    }

    public int method_31571(class_1799 stack) {
        float f = (float)ElectricWhiskItem.getNBTPower(stack) / 500.0f;
        return class_3532.method_15353((float)(1.0f - f), (float)f, (float)0.0f);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }
}

