/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.item.tools;

import com.zombie_cute.mc.bakingdelight.enchantment.ModEnchantments;
import com.zombie_cute.mc.bakingdelight.recipe.custom.GrindingRecipe;
import com.zombie_cute.mc.bakingdelight.sound.ModSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class StoneMortarItem
extends class_1831 {
    public static final Set<class_1887> ALLOWED_ENCHANTMENTS = Set.of(ModEnchantments.FINE_GRINDING, class_1893.field_9119);

    public StoneMortarItem(class_1832 material, class_1792.class_1793 settings) {
        super(material, settings);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8950;
    }

    public class_3414 method_21830() {
        return ModSounds.ITEM_STONE_MORTAR_WORKING;
    }

    public int method_7881(class_1799 stack) {
        return 40;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (!world.method_8608()) {
                class_2487 nbt = stack.method_7941("crafting_stack");
                if (nbt != null) {
                    class_1799 input = class_1799.method_7915((class_2487)nbt);
                    class_2499 enchants = stack.method_7921();
                    short grinding_level = 0;
                    for (int i = 0; i < enchants.size(); ++i) {
                        class_2487 nbtCompound = enchants.method_10602(i);
                        String name = nbtCompound.method_10558("id");
                        try {
                            class_1887 enchant = (class_1887)class_7923.field_41176.method_10223(new class_2960(name));
                            if (enchant != ModEnchantments.FINE_GRINDING) continue;
                            grinding_level = nbtCompound.method_10568("lvl");
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    List<class_1799> outputs = StoneMortarItem.craft(input, world, grinding_level);
                    for (class_1799 itemStack : outputs) {
                        player.method_7270(itemStack);
                    }
                }
                stack.method_7983("crafting_stack");
                stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
            }
        }
        return stack;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!world.method_8608() && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            class_2487 nbt = stack.method_7941("crafting_stack");
            if (nbt != null) {
                class_1799 input = class_1799.method_7915((class_2487)nbt);
                player.method_7270(input);
                world.method_8396(null, user.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, world.field_9229.method_43057() + 0.8f);
            }
            stack.method_7983("crafting_stack");
        }
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    private static List<class_1799> craft(class_1799 stack, class_1937 world, short fine_grinding_level) {
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, stack);
        Optional match = world.method_8433().method_8132((class_3956)GrindingRecipe.Type.INSTANCE, (class_1263)inventory, world);
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        if (match.isPresent()) {
            float luck = (float)fine_grinding_level * 0.2f;
            class_1799 out1 = ((GrindingRecipe)match.get()).method_8110(null).method_7972();
            class_1799 out2 = ((GrindingRecipe)match.get()).getChancedOutput().method_7972();
            if (Math.random() < (double)luck) {
                int count1 = out1.method_7947() + world.field_9229.method_39332(1, fine_grinding_level + 1);
                int count2 = out2.method_7947() + world.field_9229.method_39332(1, fine_grinding_level + 1);
                out1.method_7939(Math.min(count1, out1.method_7914()));
                out2.method_7939(Math.min(count2, out2.method_7914()));
            }
            outputs.add(out1);
            float chance = ((GrindingRecipe)match.get()).getChance();
            if (Math.random() < (double)chance) {
                outputs.add(out2);
            }
        }
        return outputs;
    }

    private static boolean hasRecipe(class_1799 stack, class_1937 world) {
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, stack);
        Optional match = world.method_8433().method_8132((class_3956)GrindingRecipe.Type.INSTANCE, (class_1263)inventory, world);
        return match.isPresent();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 thisStack = user.method_5998(hand);
        class_1799 cachedStack = StoneMortarItem.getInsideStack(thisStack);
        if (cachedStack.method_7960()) {
            class_1799 input = hand == class_1268.field_5808 ? user.method_6079() : user.method_6047();
            if (StoneMortarItem.hasRecipe(input, world)) {
                if (!world.method_8608()) {
                    class_2487 nbt = thisStack.method_7911("crafting_stack");
                    class_1799 newInput = input.method_7972();
                    newInput.method_7939(1);
                    newInput.method_7953(nbt);
                    input.method_7934(1);
                    user.method_6019(hand);
                }
                return class_1271.method_22428((Object)user.method_5998(hand));
            }
        } else {
            if (!world.method_8608()) {
                user.method_7270(cachedStack);
                thisStack.method_7983("crafting_stack");
                world.method_8396(null, user.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, world.field_9229.method_43057() + 0.8f);
            }
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        return class_1271.method_22431((Object)user.method_5998(hand));
    }

    public static class_1799 getInsideStack(class_1799 stack) {
        class_2487 nbt = stack.method_7941("crafting_stack");
        if (nbt != null) {
            try {
                return class_1799.method_7915((class_2487)nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return class_1799.field_8037;
    }
}

