/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zombie_cute.mc.bakingdelight.block.power.ElectriciansDeskBlockEntity;
import com.zombie_cute.mc.bakingdelight.networking.packet.ChangeBlockEntityDataC2SPacket;
import com.zombie_cute.mc.bakingdelight.util.Pos2;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class MiniGame1Screen
extends class_437 {
    private final class_437 parent;
    private final ElectriciansDeskBlockEntity blockEntity;
    private final int backgroundWidth = 176;
    private final int backgroundHeight = 166;
    private int x;
    private int y;
    private final int[][] game = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
    private boolean advanceMode = false;
    private final int[] spawnNumberPool = new int[]{2, 4};
    private final int[] advanceSpawnNumberPool = new int[]{2, 4, 8};
    private final int goal;
    private boolean isGameEnd = false;
    private static final class_2960 TEXTURE = new class_2960("bakingdelight", "textures/gui/mini_game_1_gui.png");

    public MiniGame1Screen(class_2561 title, class_437 parent, ElectriciansDeskBlockEntity blockEntity, int goal) {
        super(title);
        this.parent = parent;
        this.blockEntity = blockEntity;
        this.goal = goal;
        this.spawnARandomNumber();
        this.spawnARandomNumber();
    }

    private Pos2 getARandomPos() {
        ArrayList<Pos2> availablePos = new ArrayList<Pos2>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.game[i][j] != 0) continue;
                Pos2 temp = new Pos2(j, i);
                availablePos.add(temp);
            }
        }
        if (availablePos.isEmpty()) {
            return null;
        }
        int k = (int)(Math.random() * (double)availablePos.size());
        return (Pos2)availablePos.get(k);
    }

    private void spawnARandomNumber() {
        int num = this.advanceMode ? this.advanceSpawnNumberPool[(int)(Math.random() * (double)this.advanceSpawnNumberPool.length)] : this.spawnNumberPool[(int)(Math.random() * (double)this.spawnNumberPool.length)];
        Pos2 tem = this.getARandomPos();
        if (tem != null) {
            this.game[tem.getY()][tem.getX()] = num;
        }
    }

    private void spawnRandomNumbers() {
        if (this.advanceMode) {
            if (Math.random() < 0.7) {
                this.spawnARandomNumber();
            }
        } else if (Math.random() < 0.3) {
            this.spawnARandomNumber();
            this.spawnARandomNumber();
        } else {
            this.spawnARandomNumber();
        }
    }

    protected void method_25426() {
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        context.method_25302(TEXTURE, this.x, this.y, 0, 0, 176, 166);
        this.renderNumbers(context);
        this.renderGoal(context);
        this.renderDoneButton(context, mouseX, mouseY);
        this.renderControlButton(context, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
    }

    private void renderNumbers(class_332 context) {
        for (int i = 0; i < 4; ++i) {
            block15: for (int j = 0; j < 4; ++j) {
                if (this.game[i][j] >= this.goal) {
                    this.isGameEnd = true;
                }
                switch (this.game[i][j]) {
                    case 0: {
                        continue block15;
                    }
                    case 2: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 0, 188, 32, 32);
                        continue block15;
                    }
                    case 4: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 32, 188, 32, 32);
                        continue block15;
                    }
                    case 8: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 64, 188, 32, 32);
                        continue block15;
                    }
                    case 16: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 96, 188, 32, 32);
                        continue block15;
                    }
                    case 32: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 128, 188, 32, 32);
                        continue block15;
                    }
                    case 64: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 160, 188, 32, 32);
                        continue block15;
                    }
                    case 128: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 192, 188, 32, 32);
                        this.advanceMode = true;
                        continue block15;
                    }
                    case 256: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 224, 188, 32, 32);
                        continue block15;
                    }
                    case 512: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 0, 220, 32, 32);
                        continue block15;
                    }
                    case 1024: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 32, 220, 32, 32);
                        continue block15;
                    }
                    case 2048: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 64, 220, 32, 32);
                        continue block15;
                    }
                    default: {
                        context.method_25302(TEXTURE, this.x + 24 + j * 32, this.y + 11 + i * 32, 96, 220, 32, 32);
                        context.method_51433(this.field_22793, String.valueOf(this.game[i][j]), this.x + 28 + j * 32, this.y + 23 + i * 32, 0xFFFFFF, true);
                    }
                }
            }
        }
    }

    private void renderDoneButton(class_332 context, int mouseX, int mouseY) {
        if (this.isGameEnd) {
            boolean b = mouseX >= this.x + 149 && mouseY >= this.y + 145 && mouseX <= this.x + 159 && mouseY <= this.y + 155;
            context.method_25302(TEXTURE, this.x + 149, this.y + 145, 0, 166, 11, 11);
            if (b) {
                context.method_25302(TEXTURE, this.x + 149, this.y + 145, 11, 166, 11, 11);
            }
        }
    }

    private void renderControlButton(class_332 context, int mouseX, int mouseY) {
        boolean bR;
        boolean bU = mouseX >= this.x + 40 && mouseY >= this.y + 145 && mouseX <= this.x + 50 && mouseY <= this.y + 155;
        boolean bD = mouseX >= this.x + 52 && mouseY >= this.y + 145 && mouseX <= this.x + 62 && mouseY <= this.y + 155;
        boolean bL = mouseX >= this.x + 16 && mouseY >= this.y + 145 && mouseX <= this.x + 26 && mouseY <= this.y + 155;
        boolean bl = bR = mouseX >= this.x + 28 && mouseY >= this.y + 145 && mouseX <= this.x + 38 && mouseY <= this.y + 155;
        if (bU) {
            context.method_25302(TEXTURE, this.x + 40, this.y + 145, 22, 177, 11, 11);
        } else if (bD) {
            context.method_25302(TEXTURE, this.x + 52, this.y + 145, 33, 177, 11, 11);
        } else if (bL) {
            context.method_25302(TEXTURE, this.x + 16, this.y + 145, 0, 177, 11, 11);
        } else if (bR) {
            context.method_25302(TEXTURE, this.x + 28, this.y + 145, 11, 177, 11, 11);
        }
    }

    private void renderGoal(class_332 context) {
        if (this.isGameEnd) {
            context.method_51433(this.field_22793, String.valueOf(this.goal), this.x + 68, this.y + 146, 65280, true);
        } else {
            context.method_51433(this.field_22793, String.valueOf(this.goal), this.x + 68, this.y + 146, 0xFF0000, true);
        }
    }

    private void handleUpButton() {
        int j;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        block0: for (int i = 0; i < 4; ++i) {
            boolean count = true;
            for (j = 3; j > 0; --j) {
                int temp;
                if (j == 3 && this.game[3][i] == this.game[2][i] && this.game[1][i] == this.game[0][i] && this.game[3][i] != 0 && this.game[1][i] != 0) {
                    int tem1 = this.game[1][i] + this.game[0][i];
                    int tem2 = this.game[3][i] + this.game[2][i];
                    this.game[0][i] = tem1;
                    this.game[1][i] = tem2;
                    this.game[2][i] = 0;
                    this.game[3][i] = 0;
                    continue block0;
                }
                if (this.game[j][i] != 0 && this.game[j - 1][i] == 0) {
                    this.game[j - 1][i] = this.game[j][i];
                    this.game[j][i] = 0;
                    continue;
                }
                if (this.game[j][i] == 0 || this.game[j - 1][i] == 0 || this.game[j][i] != this.game[j - 1][i] || !count) continue;
                this.game[j - 1][i] = temp = this.game[j][i] + this.game[j - 1][i];
                this.game[j][i] = 0;
                count = false;
            }
        }
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < 4; ++i) {
                for (j = 3; j > 0; --j) {
                    if (this.game[j][i] == 0 || this.game[j - 1][i] != 0) continue;
                    this.game[j - 1][i] = this.game[j][i];
                    this.game[j][i] = 0;
                }
            }
        }
        this.spawnRandomNumbers();
    }

    private void handleDownButton() {
        int j;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        block0: for (int i = 0; i < 4; ++i) {
            boolean count = true;
            for (j = 0; j < 3; ++j) {
                int temp;
                if (j == 0 && this.game[3][i] == this.game[2][i] && this.game[1][i] == this.game[0][i] && this.game[3][i] != 0 && this.game[1][i] != 0) {
                    int tem1 = this.game[1][i] + this.game[0][i];
                    int tem2 = this.game[3][i] + this.game[2][i];
                    this.game[0][i] = 0;
                    this.game[1][i] = 0;
                    this.game[2][i] = tem1;
                    this.game[3][i] = tem2;
                    continue block0;
                }
                if (this.game[j][i] != 0 && this.game[j + 1][i] == 0) {
                    this.game[j + 1][i] = this.game[j][i];
                    this.game[j][i] = 0;
                    continue;
                }
                if (this.game[j][i] == 0 || this.game[j + 1][i] == 0 || this.game[j][i] != this.game[j + 1][i] || !count) continue;
                this.game[j + 1][i] = temp = this.game[j][i] + this.game[j + 1][i];
                this.game[j][i] = 0;
                count = false;
            }
        }
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < 4; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (this.game[j][i] == 0 || this.game[j + 1][i] != 0) continue;
                    this.game[j + 1][i] = this.game[j][i];
                    this.game[j][i] = 0;
                }
            }
        }
        this.spawnRandomNumbers();
    }

    private void handleLeftButton() {
        int j;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        block0: for (int i = 0; i < 4; ++i) {
            boolean count = true;
            for (j = 3; j > 0; --j) {
                int temp;
                if (j == 3 && this.game[i][3] == this.game[i][2] && this.game[i][1] == this.game[i][0] && this.game[i][3] != 0 && this.game[i][1] != 0) {
                    int tem1 = this.game[i][1] + this.game[i][0];
                    int tem2 = this.game[i][3] + this.game[i][2];
                    this.game[i][0] = tem1;
                    this.game[i][1] = tem2;
                    this.game[i][2] = 0;
                    this.game[i][3] = 0;
                    continue block0;
                }
                if (this.game[i][j] != 0 && this.game[i][j - 1] == 0) {
                    this.game[i][j - 1] = this.game[i][j];
                    this.game[i][j] = 0;
                    continue;
                }
                if (this.game[i][j] == 0 || this.game[i][j - 1] == 0 || this.game[i][j] != this.game[i][j - 1] || !count) continue;
                this.game[i][j - 1] = temp = this.game[i][j] + this.game[i][j - 1];
                this.game[i][j] = 0;
                count = false;
            }
        }
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < 4; ++i) {
                for (j = 3; j > 0; --j) {
                    if (this.game[i][j] == 0 || this.game[i][j - 1] != 0) continue;
                    this.game[i][j - 1] = this.game[i][j];
                    this.game[i][j] = 0;
                }
            }
        }
        this.spawnRandomNumbers();
    }

    private void handleRightButton() {
        int j;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        block0: for (int i = 0; i < 4; ++i) {
            boolean count = true;
            for (j = 0; j < 3; ++j) {
                int temp;
                if (j == 0 && this.game[i][3] == this.game[i][2] && this.game[i][1] == this.game[i][0] && this.game[i][3] != 0 && this.game[i][1] != 0) {
                    int tem1 = this.game[i][1] + this.game[i][0];
                    int tem2 = this.game[i][3] + this.game[i][2];
                    this.game[i][0] = 0;
                    this.game[i][1] = 0;
                    this.game[i][2] = tem1;
                    this.game[i][3] = tem2;
                    continue block0;
                }
                if (this.game[i][j] != 0 && this.game[i][j + 1] == 0) {
                    this.game[i][j + 1] = this.game[i][j];
                    this.game[i][j] = 0;
                    continue;
                }
                if (this.game[i][j] == 0 || this.game[i][j + 1] == 0 || this.game[i][j] != this.game[i][j + 1] || !count) continue;
                this.game[i][j + 1] = temp = this.game[i][j] + this.game[i][j + 1];
                this.game[i][j] = 0;
                count = false;
            }
        }
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < 4; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (this.game[i][j] == 0 || this.game[i][j + 1] != 0) continue;
                    this.game[i][j + 1] = this.game[i][j];
                    this.game[i][j] = 0;
                }
            }
        }
        this.spawnRandomNumbers();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean b;
        boolean bU = mouseX >= (double)(this.x + 40) && mouseY >= (double)(this.y + 145) && mouseX <= (double)(this.x + 50) && mouseY <= (double)(this.y + 155);
        boolean bD = mouseX >= (double)(this.x + 52) && mouseY >= (double)(this.y + 145) && mouseX <= (double)(this.x + 62) && mouseY <= (double)(this.y + 155);
        boolean bL = mouseX >= (double)(this.x + 16) && mouseY >= (double)(this.y + 145) && mouseX <= (double)(this.x + 26) && mouseY <= (double)(this.y + 155);
        boolean bR = mouseX >= (double)(this.x + 28) && mouseY >= (double)(this.y + 145) && mouseX <= (double)(this.x + 38) && mouseY <= (double)(this.y + 155);
        boolean bl = b = mouseX >= (double)(this.x + 149) && mouseY >= (double)(this.y + 145) && mouseX <= (double)(this.x + 159) && mouseY <= (double)(this.y + 155);
        if (bU) {
            this.handleUpButton();
            return true;
        }
        if (bD) {
            this.handleDownButton();
            return true;
        }
        if (bL) {
            this.handleLeftButton();
            return true;
        }
        if (bR) {
            this.handleRightButton();
            return true;
        }
        if (this.isGameEnd && b) {
            int[] array = new int[]{1};
            ChangeBlockEntityDataC2SPacket.send(this.blockEntity.method_11016(), array);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.method_25419();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public final void method_25393() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null && !this.field_22787.field_1724.method_5805() && this.field_22787.field_1724.method_31481() && this.canUse()) {
            this.field_22787.method_1507(null);
        }
    }

    private boolean canUse() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_2338 pos1 = this.field_22787.field_1724.method_24515();
            class_2338 pos2 = this.blockEntity.method_11016();
            double distance = Math.sqrt(Math.pow(pos2.method_10263() - pos1.method_10263(), 2.0) + Math.pow(pos2.method_10264() - pos1.method_10264(), 2.0) + Math.pow(pos2.method_10260() - pos1.method_10260(), 2.0));
            return distance < 7.0 && !this.blockEntity.method_11015();
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null) {
            if (this.isGameEnd && (keyCode == 257 || keyCode == 335)) {
                int[] array = new int[]{1};
                ChangeBlockEntityDataC2SPacket.send(this.blockEntity.method_11016(), array);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.method_25419();
                return true;
            }
            if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.method_25419();
                return true;
            }
            if (this.field_22787.field_1690.field_1894.method_1417(keyCode, scanCode) || keyCode == 265) {
                this.handleUpButton();
                return true;
            }
            if (this.field_22787.field_1690.field_1881.method_1417(keyCode, scanCode) || keyCode == 264) {
                this.handleDownButton();
                return true;
            }
            if (this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode) || keyCode == 263) {
                this.handleLeftButton();
                return true;
            }
            if (this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode) || keyCode == 262) {
                this.handleRightButton();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        int[] array = new int[]{4};
        ChangeBlockEntityDataC2SPacket.send(this.blockEntity.method_11016(), array);
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }
}

