/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.screen.util;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zombie_cute.mc.bakingdelight.util.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1920;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public class FluidStackRenderer {
    public final long capacityDrop;
    private final int width;
    private final int height;

    public FluidStackRenderer() {
        this(FluidStack.convertDropletsToMb(81000L), 16, 16);
    }

    public FluidStackRenderer(long capacityDrop, int width, int height) {
        Preconditions.checkArgument((capacityDrop > 0L ? 1 : 0) != 0, (Object)"capacity must be > 0");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        this.capacityDrop = capacityDrop;
        this.width = width;
        this.height = height;
    }

    public void drawFluid(class_332 context, FluidStack fluidStack, int x, int y, int width, int height) {
        if (fluidStack.getFluidVariant().getFluid() == class_3612.field_15906) {
            return;
        }
        y += height;
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidStack.getFluidVariant());
        int color = FluidVariantRendering.getColor((FluidVariant)fluidStack.getFluidVariant());
        int drawHeight = (int)((float)fluidStack.getAmount() / ((float)this.capacityDrop * 1.0f) * (float)height);
        if (sprite != null) {
            int curHeight;
            int iconHeight = sprite.method_45851().method_45815();
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            int iteration = 0;
            for (int offsetHeight = drawHeight; offsetHeight != 0; offsetHeight -= curHeight) {
                curHeight = Math.min(offsetHeight, iconHeight);
                context.method_25298(x, y - offsetHeight, 0, width, curHeight, sprite);
                if (++iteration <= 50) continue;
                break;
            }
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)FluidRenderHandlerRegistry.INSTANCE.get(fluidStack.getFluidVariant().getFluid()).getFluidSprites((class_1920)class_310.method_1551().field_1687, null, fluidStack.getFluidVariant().getFluid().method_15785())[0].method_45852());
        }
    }

    public List<class_2561> getTooltip(FluidStack fluidStack) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        FluidVariant fluidVariant = fluidStack.getFluidVariant();
        if (fluidVariant == null) {
            return tooltip;
        }
        class_5250 displayName = class_2561.method_43471((String)fluidVariant.getFluid().method_15785().method_15759().method_26204().method_9539());
        tooltip.add((class_2561)displayName);
        long amount = fluidStack.getAmount();
        class_5250 amountString = class_2561.method_43470((String)(FluidStack.convertDropletsToMb(amount) + " mB"));
        tooltip.add((class_2561)amountString.method_27696(class_2583.field_24360.method_10977(class_124.field_1080)));
        return tooltip;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

