/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.util.enums;

import com.zombie_cute.mc.bakingdelight.item.ModItems;
import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;

public enum CreamFlavor {
    NULL(-1, 0xFFFFFF, "null", 0),
    PLAIN(0, 15723745, "plain", 2),
    APPLE(1, 16242824, "apple", 3),
    CHERRY(2, 16349864, "cherry", 3),
    CHOCOLATE(3, 9135946, "chocolate", 5),
    GOLDEN_APPLE(4, 16248374, "golden_apple", 6),
    MATCHA(5, 7185454, "matcha", 3),
    PUMPKIN(6, 13671225, "pumpkin", 4);

    final int id;
    final int color;
    final String name;
    final int hunger;
    public static final String TRANSLATION_KEY = "bakingdelight.flavor";

    private CreamFlavor(int id, int color, String name, int hunger) {
        this.id = id;
        this.color = color;
        this.name = name;
        this.hunger = hunger;
    }

    public static void addFlavorToFood(class_1799 stack, CreamFlavor creamFlavor) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            nbt = new class_2487();
        }
        ArrayList<Integer> integers = new ArrayList<Integer>();
        if (nbt.method_10545("flavor")) {
            int[] array;
            for (int i : array = nbt.method_10561("flavor")) {
                integers.add(i);
            }
        }
        integers.add(creamFlavor.getId());
        nbt.method_10572("flavor", integers);
        stack.method_7980(nbt);
    }

    public static int getHungerFromFlavorNBT(class_2487 nbt) {
        if (nbt != null && nbt.method_10545("flavor")) {
            int[] array;
            int count = 0;
            for (int i : array = nbt.method_10561("flavor")) {
                CreamFlavor creamFlavor = CreamFlavor.getFlavorByID(i);
                count += creamFlavor.getHunger();
            }
            return count;
        }
        return 0;
    }

    public int getHunger() {
        return this.hunger;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public static CreamFlavor getFlavorByID(int id) {
        for (CreamFlavor creamFlavor : CreamFlavor.values()) {
            if (creamFlavor.getId() != id) continue;
            return creamFlavor;
        }
        return NULL;
    }

    public static class_1792 getCream(CreamFlavor creamFlavor) {
        return switch (creamFlavor) {
            default -> throw new IncompatibleClassChangeError();
            case PLAIN -> ModItems.CREAM;
            case APPLE -> ModItems.APPLE_CREAM;
            case CHERRY -> ModItems.CHERRY_CREAM;
            case CHOCOLATE -> ModItems.CHOCOLATE_CREAM;
            case GOLDEN_APPLE -> ModItems.GOLDEN_APPLE_CREAM;
            case MATCHA -> ModItems.MATCHA_CREAM;
            case PUMPKIN -> ModItems.PUMPKIN_CREAM;
            case NULL -> class_1802.field_8162;
        };
    }

    public String getTranslationKey() {
        return "bakingdelight.flavor." + this.name;
    }

    public int getId() {
        return this.id;
    }
}

