/*
 * Decompiled with CFR 0.152.
 */
package dev.millzy.partialkeepinventory;

import dev.millzy.partialkeepinventory.PreservationSettings;
import dev.millzy.partialkeepinventory.PreservationSettingsState;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.class_1661;
import net.minecraft.class_1814;
import net.minecraft.class_9334;

public class InventorySlotChecker {
    private final HashMap<PreservationSettings, Predicate<Integer>> slotCheckers = new HashMap();
    private final class_1661 inventory;
    private final PreservationSettingsState preservationSettings;

    public InventorySlotChecker(class_1661 inventory, PreservationSettingsState preservationSettings) {
        this.inventory = inventory;
        this.preservationSettings = preservationSettings;
        this.slotCheckers.put(PreservationSettings.EQUIPMENT, this::isEquipment);
        this.slotCheckers.put(PreservationSettings.EQUIPPABLES, this::isEquippable);
        this.slotCheckers.put(PreservationSettings.TOOLS, this::isTool);
        this.slotCheckers.put(PreservationSettings.HOTBAR, this::isHotbar);
        this.slotCheckers.put(PreservationSettings.OFFHAND, this::isOffhand);
        this.slotCheckers.put(PreservationSettings.EPIC_ITEMS, this::isEpicRarity);
        this.slotCheckers.put(PreservationSettings.RARE_ITEMS, this::isRareRarity);
        this.slotCheckers.put(PreservationSettings.UNCOMMON_ITEMS, this::isUncommonRarity);
        this.slotCheckers.put(PreservationSettings.COMMON_ITEMS, this::isCommonRarity);
        this.slotCheckers.put(PreservationSettings.CUSTOM_LIST, this::isInItemList);
    }

    public boolean shouldDrop(int slot) {
        boolean shouldNotDrop = false;
        for (PreservationSettings setting : this.preservationSettings.getSettings().get()) {
            shouldNotDrop |= this.slotCheckers.getOrDefault((Object)setting, u -> false).test(slot);
        }
        return !shouldNotDrop;
    }

    private boolean isEquipment(int slot) {
        return class_1661.field_56551.containsKey(slot);
    }

    private boolean isEquippable(int slot) {
        return this.inventory.method_5438(slot).method_57826(class_9334.field_54196);
    }

    private boolean isTool(int slot) {
        return this.inventory.method_5438(slot).method_57826(class_9334.field_50077);
    }

    private boolean isHotbar(int slot) {
        return slot < 9;
    }

    private boolean isOffhand(int slot) {
        return slot == 40;
    }

    private boolean isEpicRarity(int slot) {
        return this.inventory.method_5438(slot).method_7932() == class_1814.field_8904;
    }

    private boolean isRareRarity(int slot) {
        return this.inventory.method_5438(slot).method_7932() == class_1814.field_8903;
    }

    private boolean isUncommonRarity(int slot) {
        return this.inventory.method_5438(slot).method_7932() == class_1814.field_8907;
    }

    private boolean isCommonRarity(int slot) {
        return this.inventory.method_5438(slot).method_7932() == class_1814.field_8906;
    }

    private boolean isInItemList(int slot) {
        return this.preservationSettings.isInItemList(this.inventory.method_5438(slot));
    }
}

