/*
 * Decompiled with CFR 0.152.
 */
package dev.millzy.partialkeepinventory.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.millzy.partialkeepinventory.PreservationSettings;
import dev.millzy.partialkeepinventory.PreservationSettingsState;
import dev.millzy.partialkeepinventory.command.PreservationSettingsSuggestionProvider;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_18;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_7157;

public class PartialKeepInventoryCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"partialKeepInventory").requires((Predicate)class_2170.method_71774((int)2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"features").executes(PartialKeepInventoryCommand::listFeatures)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PreservationSettingsSuggestionProvider()).executes(PartialKeepInventoryCommand::addFeature)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PreservationSettingsSuggestionProvider()).executes(PartialKeepInventoryCommand::removeFeature))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"itemList").executes(PartialKeepInventoryCommand::listItems)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(PartialKeepInventoryCommand::addItem)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(PartialKeepInventoryCommand::removeItem))));
        dispatcher.register(builder);
    }

    private static int listFeatures(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9211().method_30002();
        PreservationSettingsState settingsState = (PreservationSettingsState)world.method_17983().method_17924(PreservationSettingsState.ID);
        String[] enabledSettings = settingsState.getEnabledSettingNames();
        Optional<String> combinedList = Arrays.stream(enabledSettings).reduce((st, v) -> st.concat("\n").concat((String)v));
        class_2561 message = combinedList.map(s -> class_2561.method_30163((String)("Enabled features:\n" + s))).orElseGet(() -> class_2561.method_30163((String)"No features are enabled."));
        ((class_2168)context.getSource()).method_45068(message);
        return 0;
    }

    private static int addFeature(CommandContext<class_2168> context) {
        String feature = StringArgumentType.getString(context, (String)"feature");
        PreservationSettings setting = PreservationSettings.fromString(feature);
        if (setting == PreservationSettings.NONE) {
            // empty if block
        }
        class_3218 world = ((class_2168)context.getSource()).method_9211().method_30002();
        PreservationSettingsState settingsState = (PreservationSettingsState)world.method_17983().method_17924(PreservationSettingsState.ID);
        settingsState.enableSetting(setting);
        world.method_17983().method_123(PreservationSettingsState.ID, (class_18)settingsState);
        ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)("Enabled feature: " + feature)));
        return 0;
    }

    private static int removeFeature(CommandContext<class_2168> context) {
        String feature = StringArgumentType.getString(context, (String)"feature");
        PreservationSettings setting = PreservationSettings.fromString(feature);
        if (setting == PreservationSettings.NONE) {
            // empty if block
        }
        class_3218 world = ((class_2168)context.getSource()).method_9211().method_30002();
        PreservationSettingsState settingsState = (PreservationSettingsState)world.method_17983().method_17924(PreservationSettingsState.ID);
        settingsState.disableSetting(setting);
        world.method_17983().method_123(PreservationSettingsState.ID, (class_18)settingsState);
        ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)("Disabled feature: " + feature)));
        return 0;
    }

    private static int listItems(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9211().method_30002();
        PreservationSettingsState settingsState = (PreservationSettingsState)world.method_17983().method_17924(PreservationSettingsState.ID);
        String[] items = settingsState.getItemsFromList();
        Optional<String> combinedList = Arrays.stream(items).reduce((st, v) -> st.concat("\n").concat((String)v));
        class_2561 message = combinedList.map(s -> class_2561.method_30163((String)("Item list contents:\n" + s))).orElseGet(() -> class_2561.method_30163((String)"Item list is empty."));
        ((class_2168)context.getSource()).method_45068(message);
        return 0;
    }

    private static int addItem(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9211().method_30002();
        class_2290 item = class_2287.method_9777(context, (String)"item");
        PreservationSettingsState settingsState = (PreservationSettingsState)world.method_17983().method_17924(PreservationSettingsState.ID);
        settingsState.addToItemList(item.method_9785().method_7854());
        world.method_17983().method_123(PreservationSettingsState.ID, (class_18)settingsState);
        ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)("Added item: " + item.method_9785().toString())));
        return 0;
    }

    private static int removeItem(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9211().method_30002();
        class_2290 item = class_2287.method_9777(context, (String)"item");
        PreservationSettingsState settingsState = (PreservationSettingsState)world.method_17983().method_17924(PreservationSettingsState.ID);
        settingsState.removeFromItemList(item.method_9785().method_7854());
        world.method_17983().method_123(PreservationSettingsState.ID, (class_18)settingsState);
        ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)("Removed item: " + item.method_9785().toString())));
        return 0;
    }
}

