/*
 * Decompiled with CFR 0.152.
 */
package dev.millzy.partialkeepinventory;

import dev.millzy.partialkeepinventory.PreservationSettings;
import dev.millzy.partialkeepinventory.PreservationSettingsHandler;
import dev.millzy.partialkeepinventory.PreservationSettingsState;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.class_1661;
import net.minecraft.class_1814;
import net.minecraft.class_3218;
import net.minecraft.class_9334;

public class InventorySlotChecker {
    private static final HashMap<PreservationSettings, BiPredicate<class_1661, Integer>> SLOT_CHECKERS = new HashMap();

    public static boolean shouldDrop(class_1661 inventory, int slot, PreservationSettingsHandler preservationSettings) {
        boolean shouldNotDrop = false;
        for (PreservationSettings setting : preservationSettings.get()) {
            shouldNotDrop |= SLOT_CHECKERS.getOrDefault((Object)setting, (t, u) -> false).test(inventory, slot);
        }
        return !shouldNotDrop;
    }

    private static boolean isEquipment(class_1661 inventory, int slot) {
        return class_1661.field_56551.containsKey(slot);
    }

    private static boolean isEquippable(class_1661 inventory, int slot) {
        return inventory.method_5438(slot).method_57826(class_9334.field_54196);
    }

    private static boolean isTool(class_1661 inventory, int slot) {
        return inventory.method_5438(slot).method_57826(class_9334.field_50077);
    }

    private static boolean isHotbar(class_1661 inventory, int slot) {
        return slot < 9;
    }

    private static boolean isOffhand(class_1661 inventory, int slot) {
        return slot == 40;
    }

    private static boolean isEpicRarity(class_1661 inventory, int slot) {
        return inventory.method_5438(slot).method_7932() == class_1814.field_8904;
    }

    private static boolean isRareRarity(class_1661 inventory, int slot) {
        return inventory.method_5438(slot).method_7932() == class_1814.field_8903;
    }

    private static boolean isUncommonRarity(class_1661 inventory, int slot) {
        return inventory.method_5438(slot).method_7932() == class_1814.field_8907;
    }

    private static boolean isCommonRarity(class_1661 inventory, int slot) {
        return inventory.method_5438(slot).method_7932() == class_1814.field_8906;
    }

    private static boolean isInItemList(class_1661 inventory, int slot) {
        class_3218 overworld = Objects.requireNonNull(inventory.field_7546.method_5682()).method_30002();
        PreservationSettingsState settingsState = (PreservationSettingsState)overworld.method_17983().method_17924(PreservationSettingsState.ID);
        return settingsState.isInItemList(inventory.method_5438(slot));
    }

    static {
        SLOT_CHECKERS.put(PreservationSettings.EQUIPMENT, InventorySlotChecker::isEquipment);
        SLOT_CHECKERS.put(PreservationSettings.EQUIPPABLES, InventorySlotChecker::isEquippable);
        SLOT_CHECKERS.put(PreservationSettings.TOOLS, InventorySlotChecker::isTool);
        SLOT_CHECKERS.put(PreservationSettings.HOTBAR, InventorySlotChecker::isHotbar);
        SLOT_CHECKERS.put(PreservationSettings.OFFHAND, InventorySlotChecker::isOffhand);
        SLOT_CHECKERS.put(PreservationSettings.EPIC_ITEMS, InventorySlotChecker::isEpicRarity);
        SLOT_CHECKERS.put(PreservationSettings.RARE_ITEMS, InventorySlotChecker::isRareRarity);
        SLOT_CHECKERS.put(PreservationSettings.UNCOMMON_ITEMS, InventorySlotChecker::isUncommonRarity);
        SLOT_CHECKERS.put(PreservationSettings.COMMON_ITEMS, InventorySlotChecker::isCommonRarity);
        SLOT_CHECKERS.put(PreservationSettings.CUSTOM_LIST, InventorySlotChecker::isInItemList);
    }
}

