/*
 * Decompiled with CFR 0.152.
 */
package dev.millzy.partialkeepinventory;

import dev.millzy.partialkeepinventory.PreservationSettings;
import java.util.EnumSet;

public class PreservationSettingsHandler {
    private final EnumSet<PreservationSettings> preservationSettings = EnumSet.noneOf(PreservationSettings.class);
    private static final int SETTINGS_MAX_ORDINAL = EnumSet.allOf(PreservationSettings.class).stream().max(Enum::compareTo).orElse(PreservationSettings.NONE).ordinal();
    public static final EnumSet<PreservationSettings> ALL_SETTINGS = EnumSet.allOf(PreservationSettings.class);

    public PreservationSettingsHandler() {
        this(0);
    }

    public PreservationSettingsHandler(int value) {
        int i = 0;
        while (1 << i <= 1 << SETTINGS_MAX_ORDINAL) {
            int testFlag = 1 << i;
            if ((value & testFlag) == testFlag) {
                this.preservationSettings.add(PreservationSettings.values()[i]);
            }
            ++i;
        }
    }

    public int getFlagsValue() {
        return this.preservationSettings.stream().mapToInt(m -> 1 << m.ordinal()).reduce(0, (st, v) -> st | v);
    }

    public EnumSet<PreservationSettings> get() {
        return this.preservationSettings;
    }

    public boolean getSetting(PreservationSettings setting) {
        return this.preservationSettings.contains((Object)setting);
    }

    public void enableSetting(PreservationSettings setting) {
        this.preservationSettings.add(setting);
    }

    public void disableSetting(PreservationSettings setting) {
        this.preservationSettings.remove((Object)setting);
    }

    public String[] getValueDisplays() {
        return (String[])this.preservationSettings.stream().map(PreservationSettings::getDisplay).toArray(String[]::new);
    }

    static {
        ALL_SETTINGS.remove((Object)PreservationSettings.NONE);
    }
}

