/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag;

import com.saicone.rtag.Rtag;
import com.saicone.rtag.RtagEditor;
import com.saicone.rtag.entity.EntityObject;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.tag.TagList;
import com.saicone.rtag.util.OptionalType;
import com.saicone.rtag.util.ServerInstance;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.Entity;

public class RtagEntity
extends RtagEditor<Entity, RtagEntity> {
    private static final String PREFIX = "minecraft:";
    private static final String ATTRIBUTES = ServerInstance.MAJOR_VERSION >= 21 ? "attributes" : "Attributes";
    private static final String ATTRIBUTE_ID = ServerInstance.MAJOR_VERSION >= 21 ? "id" : "Name";
    private static final String ATTRIBUTE_BASE = ServerInstance.MAJOR_VERSION >= 21 ? "base" : "Base";

    public static RtagEntity of(Entity entity) {
        return new RtagEntity(entity);
    }

    public static RtagEntity of(Rtag rtag, Entity entity) {
        return new RtagEntity(rtag, entity);
    }

    public RtagEntity(Entity entity) {
        super(Rtag.INSTANCE, entity);
    }

    public RtagEntity(Rtag rtag, Entity entity) {
        super(rtag, entity);
    }

    public RtagEntity(Rtag rtag, Entity entity, Object mcEntity) {
        super(rtag, entity, mcEntity);
    }

    public RtagEntity(Rtag rtag, Entity entity, Object mcEntity, Object tag) {
        super(rtag, entity, mcEntity, tag);
    }

    public Entity getEntity() {
        return (Entity)this.getTypeObject();
    }

    @Override
    protected RtagEntity getEditor() {
        return this;
    }

    @Override
    public Object getLiteralObject(Entity entity) {
        return EntityObject.getHandle(entity);
    }

    @Override
    public Object getTag(Object entity) {
        return EntityObject.save(entity);
    }

    @Override
    public Entity load() {
        try {
            EntityObject.load(this.getLiteralObject(), this.getTag());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return (Entity)this.getTypeObject();
    }

    public boolean setAttributeBase(String name, double value) {
        return this.setAttributeValue(name, ATTRIBUTE_BASE, value);
    }

    public boolean setAttributeValue(String name, String key, Object value) {
        Object attribute = this.getAttribute(name);
        if (attribute != null) {
            TagCompound.set(attribute, key, this.getRtag().newTag(value));
            return true;
        }
        return false;
    }

    public boolean setHealth(float health) {
        return this.set(Float.valueOf(health), "Health");
    }

    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        Object attributes = TagCompound.get(this.getTag(), ATTRIBUTES);
        if (attributes != null) {
            Object type = name.startsWith(PREFIX) ? name : PREFIX + name;
            for (Object attribute : TagList.getValue(attributes)) {
                Object id = (String)TagBase.getValue(TagCompound.get(attribute, ATTRIBUTE_ID));
                if (!((String)id).startsWith(PREFIX)) {
                    id = PREFIX + (String)id;
                }
                if (!((String)type).equals(id)) continue;
                return attribute;
            }
        }
        return null;
    }

    public double getAttributeBase(String name) {
        return OptionalType.of(this.getAttributeValue(name, ATTRIBUTE_BASE)).or(0).intValue();
    }

    public Object getAttributeValue(String name, String key) {
        Object attribute = this.getAttribute(name);
        if (attribute != null) {
            return TagBase.getValue(this.getRtag(), TagCompound.get(attribute, key));
        }
        return null;
    }

    public float getHealth() {
        return this.getOptional("Health").asFloat(Float.valueOf(0.0f)).floatValue();
    }

    public static <T extends Entity> T edit(T entity, Consumer<RtagEntity> consumer) {
        return RtagEntity.edit(Rtag.INSTANCE, entity, consumer);
    }

    public static <T extends Entity, R> R edit(T entity, Function<RtagEntity, R> function) {
        return RtagEntity.edit(Rtag.INSTANCE, entity, function);
    }

    public static <T extends Entity> T edit(Rtag rtag, T entity, Consumer<RtagEntity> consumer) {
        new RtagEntity(rtag, entity).edit(consumer).load();
        return entity;
    }

    public static <T extends Entity, R> R edit(Rtag rtag, T entity, Function<RtagEntity, R> function) {
        return function.apply(new RtagEntity(rtag, entity));
    }
}

