/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag;

import com.saicone.rtag.Rtag;
import com.saicone.rtag.RtagEditor;
import com.saicone.rtag.RtagMirror;
import com.saicone.rtag.data.ComponentType;
import com.saicone.rtag.data.DataComponent;
import com.saicone.rtag.item.ItemObject;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.tag.TagList;
import com.saicone.rtag.util.ChatComponent;
import com.saicone.rtag.util.EnchantmentTag;
import com.saicone.rtag.util.OptionalType;
import com.saicone.rtag.util.ServerInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class RtagItem
extends RtagEditor<ItemStack, RtagItem> {
    private static final List<String> HIDE_FLAGS = List.of("minecraft:enchantments", "minecraft:attribute_modifiers", "minecraft:unbreakable", "minecraft:can_break", "minecraft:can_place_on", "minecraft:stored_enchantments", "minecraft:dyed_color", "minecraft:trim");
    private final Object components;
    private transient DataComponent.Builder<Optional<?>> patch;
    private transient boolean edited = false;
    private transient boolean copied = true;

    public static RtagItem of(ItemStack item) {
        return new RtagItem(item);
    }

    public static RtagItem of(Rtag rtag, ItemStack item) {
        return new RtagItem(rtag, item);
    }

    public RtagItem(ItemStack item) {
        this(Rtag.INSTANCE, item);
    }

    public RtagItem(Rtag rtag, ItemStack item) {
        super(rtag, item);
        this.components = ServerInstance.Release.COMPONENT ? DataComponent.Holder.getComponents(this.getLiteralObject()) : null;
    }

    public RtagItem(Rtag rtag, ItemStack item, Object mcItem) {
        super(rtag, item, mcItem);
        this.components = ServerInstance.Release.COMPONENT ? DataComponent.Holder.getComponents(mcItem) : null;
    }

    public RtagItem(Rtag rtag, ItemStack item, Object mcItem, Object tag) {
        super(rtag, item, mcItem, tag);
        this.components = ServerInstance.Release.COMPONENT ? DataComponent.Holder.getComponents(mcItem) : null;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getTypeObject();
    }

    @Override
    protected RtagItem getEditor() {
        return this;
    }

    @Override
    public Object getLiteralObject(ItemStack item) {
        ItemStack craftItem = ItemObject.getCraftStack(item);
        if (craftItem == null) {
            this.copied = true;
            return ItemObject.asNMSCopy(item);
        }
        this.copied = false;
        return ItemObject.getUncheckedHandle(craftItem);
    }

    public Object getLiteralTag() {
        return this.tag;
    }

    @Override
    public Object getTag() {
        if (!this.edited) {
            this.tag = this.tag == null ? TagCompound.newTag() : TagCompound.clone(this.tag);
            this.edited = true;
        }
        return this.tag;
    }

    @Override
    public Object getTag(Object item) {
        return ItemObject.getCustomDataTag(item);
    }

    @ApiStatus.Experimental
    public Object getComponents() {
        return this.components;
    }

    private DataComponent.Builder<Optional<?>> getPatch() {
        if (this.patch == null) {
            this.patch = DataComponent.Patch.builder();
        }
        return this.patch;
    }

    @Override
    public ItemStack load() {
        Object literal = this.loadInto(this.getLiteralObject());
        if (this.copied) {
            ItemObject.loadHandle((ItemStack)this.getTypeObject(), literal);
        }
        return (ItemStack)this.getTypeObject();
    }

    public ItemStack loadCopy() {
        Object copy = this.loadInto(ItemObject.copy(this.getLiteralObject()));
        if (this.copied) {
            return ItemObject.asBukkitCopy(copy);
        }
        return ItemObject.asCraftMirror(copy);
    }

    public <T> T loadInto(T item) {
        if (this.edited) {
            ItemObject.setCustomDataTag(item, this.tag);
        }
        if (this.patch != null) {
            ItemObject.apply(item, this.patch.build());
        }
        return item;
    }

    @Override
    public void update(Object object) {
        this.edited = false;
        super.update(object);
    }

    @ApiStatus.Experimental
    public boolean hasComponent(Object type) {
        Object componentType = ComponentType.of(type);
        if (this.patch != null && this.patch.has(componentType)) {
            return this.patch.get(componentType).isPresent();
        }
        return DataComponent.Map.has(this.components, componentType);
    }

    @Override
    public boolean set(Object value) {
        if (value == null) {
            this.edited = true;
            this.tag = null;
            return true;
        }
        if (super.set(value)) {
            this.edited = true;
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    public void setComponent(Object type) {
        this.getPatch().set(ComponentType.of(type), Optional.of(Rtag.UNIT));
    }

    @ApiStatus.Experimental
    public void setComponent(Object type, Object value) {
        Object parsed = ComponentType.parse(type, value).orElseThrow(() -> new RuntimeException("Cannot parse provided value into defined component type"));
        this.getPatch().set(ComponentType.of(type), Optional.of(parsed));
    }

    @ApiStatus.Experimental
    public void removeComponent(Object type) {
        this.getPatch().remove(ComponentType.of(type));
    }

    @Override
    public Map<String, Object> get() {
        return this.tag == null ? Map.of() : super.get();
    }

    @Override
    public <V> V get(Object ... path) {
        return this.tag == null ? null : (V)super.get(path);
    }

    @Override
    public OptionalType getOptional(Object ... path) {
        return this.tag == null ? OptionalType.EMPTY : super.getOptional(path);
    }

    @Override
    public Object getExact(Object ... path) {
        return this.tag == null ? null : super.getExact(path);
    }

    @ApiStatus.Experimental
    public Object getComponent(Object type) {
        Object componentType = ComponentType.of(type);
        if (this.patch != null && this.patch.has(componentType)) {
            return this.patch.get(componentType).orElse(null);
        }
        return DataComponent.Map.get(this.components, componentType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public boolean hasHideFlags(int ... hideFlags) {
        if ((double)ServerInstance.VERSION >= 21.04) {
            Map tooltipDisplay = ComponentType.encodeJava("minecraft:tooltip_display", this.getComponent("minecraft:tooltip_display")).orElse(null);
            if (tooltipDisplay == null) {
                return hideFlags.length < 1;
            }
            Collection hiddenComponents = tooltipDisplay.getOrDefault("hidden_components", List.of());
            for (int ordinal : hideFlags) {
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) {
                    return false;
                }
                if (!(ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK ? !Boolean.TRUE.equals(tooltipDisplay.get("hide_tooltip")) : !hiddenComponents.contains(HIDE_FLAGS.get(ordinal)))) continue;
                return false;
            }
            return true;
        }
        if (ServerInstance.Release.COMPONENT) {
            for (int ordinal : hideFlags) {
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) {
                    return false;
                }
                if (ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                    if (this.hasComponent("minecraft:hide_additional_tooltip")) continue;
                    return false;
                }
                String name = HIDE_FLAGS.get(ordinal);
                Object component = DataComponent.Map.get(this.components, ComponentType.of(name));
                if (component == null) {
                    return false;
                }
                Map map = ComponentType.encodeJava(name, component).orElse(null);
                if (map != null && Boolean.FALSE.equals(map.get("show_in_tooltip"))) continue;
                return false;
            }
            return true;
        }
        return this.hasEnum(hideFlags, new Object[]{"HideFlags"});
    }

    public boolean hasEnchantment(Object enchant) {
        if (ServerInstance.Release.COMPONENT) {
            EnchantmentTag tag = EnchantmentTag.of(enchant);
            if (tag == null) {
                return false;
            }
            return this.getItem().containsEnchantment(tag.getEnchantment());
        }
        return this.getEnchantment(enchant) != null;
    }

    public void fixSerialization() {
        if (ServerInstance.MAJOR_VERSION < 14) {
            return;
        }
        if (ServerInstance.Release.COMPONENT) {
            return;
        }
        Object tag = this.getExact("display", "Lore");
        if (tag != null) {
            List<Object> lore = TagList.getValue(tag);
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)TagBase.getValue(lore.get(i));
                if (!ChatComponent.isChatComponent(line)) continue;
                lore.set(i, TagBase.newTag(ChatComponent.toJson(ChatComponent.toString(line))));
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public boolean addHideFlags(int ... hideFlags) {
        if ((double)ServerInstance.VERSION >= 21.04) {
            Collection<String> hiddenComponents;
            boolean hideTooltip;
            Map tooltipDisplay = ComponentType.encodeJava("minecraft:tooltip_display", this.getComponent("minecraft:tooltip_display")).orElse(null);
            if (tooltipDisplay == null) {
                hideTooltip = false;
                hiddenComponents = new ArrayList();
            } else {
                hideTooltip = tooltipDisplay.getOrDefault("hide_tooltip", false);
                hiddenComponents = tooltipDisplay.getOrDefault("hidden_components", new ArrayList());
            }
            boolean result = false;
            for (int ordinal : hideFlags) {
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) continue;
                if (ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                    if (hideTooltip) continue;
                    hideTooltip = true;
                    result = true;
                    continue;
                }
                String name = HIDE_FLAGS.get(ordinal);
                if (hiddenComponents.contains(name)) continue;
                hiddenComponents.add(name);
                result = true;
            }
            if (result) {
                this.setComponent("minecraft:tooltip_display", Map.of("hide_tooltip", hideTooltip, "hidden_components", hiddenComponents));
                return true;
            }
            return false;
        }
        if (ServerInstance.Release.COMPONENT) {
            boolean result = false;
            for (int ordinal : hideFlags) {
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) continue;
                if (ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                    result = true;
                    this.setComponent("minecraft:hide_additional_tooltip");
                    continue;
                }
                String name = HIDE_FLAGS.get(ordinal);
                Object component = DataComponent.Map.get(this.components, ComponentType.of(name));
                if (component == null) {
                    result = true;
                    this.setComponent(name, Map.of("show_in_tooltip", false));
                    continue;
                }
                HashMap<String, Boolean> map = ComponentType.encodeJava(name, component).orElse(null);
                if (map == null || Boolean.FALSE.equals(map.get("show_in_tooltip"))) continue;
                result = true;
                map = new HashMap<String, Boolean>(map);
                map.put("show_in_tooltip", false);
                this.setComponent(name, map);
            }
            return result;
        }
        return this.addEnum(hideFlags, new Object[]{"HideFlags"});
    }

    public boolean addEnchantment(Object enchant, int level) {
        EnchantmentTag tag = EnchantmentTag.of(enchant);
        if (tag == null) {
            return false;
        }
        if (ServerInstance.Release.COMPONENT) {
            this.getItem().addUnsafeEnchantment(tag.getEnchantment(), level);
            return true;
        }
        Object enchantment = this.getEnchantment((Object)tag);
        if (enchantment == null) {
            return this.add(Map.of("id", tag.getKey(), "lvl", level), EnchantmentTag.getEnchantmentKey((ItemStack)this.getTypeObject()));
        }
        TagCompound.set(enchantment, "lvl", TagBase.newTag(level));
        return true;
    }

    public boolean setUnbreakable(boolean unbreakable) {
        if (ServerInstance.Release.COMPONENT) {
            this.setComponent("minecraft:unbreakable", Map.of());
            return true;
        }
        return this.set(unbreakable, "Unbreakable");
    }

    @Deprecated
    public boolean setCustomModelData(Integer model) {
        if (ServerInstance.Release.COMPONENT) {
            if (model == null) {
                this.removeComponent("minecraft:custom_model_data");
            } else if (ServerInstance.VERSION >= 21.03f) {
                this.setComponent("minecraft:custom_model_data", Map.of("floats", List.of(Float.valueOf(model.floatValue()))));
            } else {
                this.setComponent("minecraft:custom_model_data", model);
            }
            return true;
        }
        return this.set(model, "CustomModelData");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public boolean setHideFlags(int ... hideFlags) {
        if ((double)ServerInstance.VERSION >= 21.04) {
            Map tooltipDisplay = ComponentType.encodeJava("minecraft:tooltip_display", this.getComponent("minecraft:tooltip_display")).orElse(null);
            boolean hideTooltip = tooltipDisplay != null && tooltipDisplay.getOrDefault("hide_tooltip", false) != false;
            ArrayList<String> hiddenComponents = new ArrayList<String>();
            for (int ordinal : hideFlags) {
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) continue;
                if (ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                    hideTooltip = true;
                    continue;
                }
                hiddenComponents.add(HIDE_FLAGS.get(ordinal));
            }
            this.setComponent("minecraft:tooltip_display", Map.of("hide_tooltip", hideTooltip, "hidden_components", hiddenComponents));
            return true;
        }
        if (ServerInstance.Release.COMPONENT) {
            boolean result = this.addHideFlags(hideFlags);
            HashSet<Integer> toRemove = new HashSet<Integer>(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)));
            for (int ordinal : hideFlags) {
                toRemove.remove(ordinal);
            }
            if (toRemove.isEmpty()) {
                return result;
            }
            int[] flags = new int[toRemove.size()];
            int index = 0;
            for (Integer ordinal : toRemove) {
                flags[index] = ordinal;
                ++index;
            }
            return this.removeHideFlags(flags) || result;
        }
        return this.setEnum(hideFlags, new Object[]{"HideFlags"});
    }

    public boolean setRepairCost(int cost) {
        if (ServerInstance.Release.COMPONENT) {
            DataComponent.MapPatch.set(this.components, ComponentType.of("minecraft:repair_cost"), cost);
            return true;
        }
        return this.set(cost, "RepairCost");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public boolean removeHideFlags(int ... hideFlags) {
        if ((double)ServerInstance.VERSION >= 21.04) {
            Collection hiddenComponents;
            boolean hideTooltip;
            Map tooltipDisplay = ComponentType.encodeJava("minecraft:tooltip_display", this.getComponent("minecraft:tooltip_display")).orElse(null);
            if (tooltipDisplay == null) {
                hideTooltip = false;
                hiddenComponents = new ArrayList();
            } else {
                hideTooltip = tooltipDisplay.getOrDefault("hide_tooltip", false);
                hiddenComponents = tooltipDisplay.getOrDefault("hidden_components", new ArrayList());
            }
            boolean result = false;
            for (int ordinal : hideFlags) {
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) continue;
                if (ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                    if (!hideTooltip) continue;
                    hideTooltip = false;
                    result = true;
                    continue;
                }
                String name = HIDE_FLAGS.get(ordinal);
                if (!hiddenComponents.remove(name)) continue;
                result = true;
            }
            if (result) {
                this.setComponent("minecraft:tooltip_display", Map.of("hide_tooltip", hideTooltip, "hidden_components", hiddenComponents));
                return true;
            }
            return false;
        }
        if (ServerInstance.Release.COMPONENT) {
            boolean result = false;
            for (int ordinal : hideFlags) {
                HashMap<String, Boolean> map;
                if (ordinal < 0 || ordinal >= HIDE_FLAGS.size()) continue;
                if (ordinal == 5 && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                    result = result || this.hasComponent("minecraft:hide_additional_tooltip");
                    this.removeComponent("minecraft:hide_additional_tooltip");
                    continue;
                }
                String name = HIDE_FLAGS.get(ordinal);
                Object component = DataComponent.Map.get(this.components, ComponentType.of(name));
                if (component == null || (map = (HashMap<String, Boolean>)ComponentType.encodeJava(name, component).orElse(null)) == null || !Boolean.FALSE.equals(map.get("show_in_tooltip"))) continue;
                result = true;
                if (map.size() == 1) {
                    this.removeComponent(name);
                    continue;
                }
                map = new HashMap<String, Boolean>(map);
                map.put("show_in_tooltip", true);
                this.setComponent(name, map);
            }
            return result;
        }
        return this.removeEnum(hideFlags, new Object[]{"HideFlags"});
    }

    public int removeEnchantment(EnchantmentTag enchant) {
        EnchantmentTag tag = EnchantmentTag.of((Object)enchant);
        if (tag == null) {
            return 0;
        }
        if (ServerInstance.Release.COMPONENT) {
            return this.getItem().removeEnchantment(tag.getEnchantment());
        }
        String enchantmentKey = EnchantmentTag.getEnchantmentKey((ItemStack)this.getTypeObject());
        Object enchantments = this.getExact(enchantmentKey);
        if (enchantments == null) {
            return 0;
        }
        List<Object> list = TagList.getValue(enchantments);
        if (list.isEmpty()) {
            return 0;
        }
        int index = -1;
        int level = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!tag.compareKey(TagBase.getValue(TagCompound.get(o, "id")))) continue;
            index = i;
            level = Integer.parseInt(String.valueOf(TagBase.getValue(TagCompound.get(o, "lvl"))));
            break;
        }
        if (index < 0) {
            return 0;
        }
        if (list.size() == 1) {
            this.remove(enchantmentKey);
        } else {
            ArrayList<Object> listCopy = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                if (index == i) continue;
                listCopy.add(list.get(i));
            }
            this.set(listCopy, enchantmentKey);
        }
        return level;
    }

    @Deprecated
    public Integer getCustomModelData() {
        if (ServerInstance.Release.COMPONENT) {
            return ComponentType.encodeJava("minecraft:custom_model_data", this.getComponent("minecraft:custom_model_data")).map(model -> {
                if (model instanceof Map) {
                    Object f;
                    Object floats = ((Map)model).get("floats");
                    if (floats instanceof List && !((List)floats).isEmpty() && (f = ((List)floats).get(0)) instanceof Float) {
                        return ((Float)f).intValue();
                    }
                    return null;
                }
                return (Integer)model;
            }).orElse(null);
        }
        return (Integer)this.get("CustomModelData");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public Set<Integer> getHideFlags() {
        if ((double)ServerInstance.VERSION >= 21.04) {
            HashSet<Integer> hideFlags = new HashSet<Integer>();
            Map tooltipDisplay = ComponentType.encodeJava("minecraft:tooltip_display", this.getComponent("minecraft:tooltip_display")).orElse(null);
            if (tooltipDisplay == null) {
                return hideFlags;
            }
            if (tooltipDisplay.getOrDefault("hide_tooltip", false).booleanValue() && this.getItem().getType() != Material.ENCHANTED_BOOK) {
                hideFlags.add(5);
            }
            Collection hiddenComponents = tooltipDisplay.getOrDefault("hidden_components", new ArrayList());
            for (String component : hiddenComponents) {
                int ordinal = HIDE_FLAGS.indexOf(component);
                if (ordinal < 0) continue;
                hideFlags.add(ordinal);
            }
            return hideFlags;
        }
        if (ServerInstance.Release.COMPONENT) {
            HashSet<Integer> hideFlags = new HashSet<Integer>();
            if (this.getItem().hasItemMeta()) {
                for (ItemFlag flag : this.getItem().getItemMeta().getItemFlags()) {
                    hideFlags.add(flag.ordinal());
                }
            }
            return hideFlags;
        }
        return this.getOptional("HideFlags").asOrdinalSet(8);
    }

    public int getRepairCost() {
        if (ServerInstance.Release.COMPONENT) {
            return (Integer)DataComponent.Map.get(this.components, ComponentType.of("minecraft:repair_cost"));
        }
        return this.getOptional("RepairCost").or(0);
    }

    public Object getEnchantment(Object enchant) {
        EnchantmentTag tag = EnchantmentTag.of(enchant);
        if (tag == null) {
            return null;
        }
        if (ServerInstance.Release.COMPONENT) {
            int level = this.getItem().getEnchantmentLevel(tag.getEnchantment());
            if (level > 0) {
                return TagCompound.newTag(RtagMirror.INSTANCE, Map.of("id", tag.getKey(), "lvl", level));
            }
        } else {
            Object enchantments = this.getExact(EnchantmentTag.getEnchantmentKey((ItemStack)this.getTypeObject()));
            if (enchantments != null) {
                for (Object o : TagList.getValue(enchantments)) {
                    if (!tag.compareKey(TagBase.getValue(TagCompound.get(o, "id")))) continue;
                    return o;
                }
            }
        }
        return null;
    }

    public int getEnchantmentLevel(Object enchant) {
        if (ServerInstance.Release.COMPONENT) {
            EnchantmentTag tag = EnchantmentTag.of(enchant);
            if (tag == null) {
                return 0;
            }
            return this.getItem().getEnchantmentLevel(tag.getEnchantment());
        }
        Object enchantment = this.getEnchantment(enchant);
        if (enchantment == null) {
            return 0;
        }
        Object lvl = TagBase.getValue(TagCompound.get(enchantment, "lvl"));
        return lvl == null ? -1 : Integer.parseInt(String.valueOf(lvl));
    }

    public Map<EnchantmentTag, Integer> getEnchantments() {
        HashMap<EnchantmentTag, Integer> enchants = new HashMap<EnchantmentTag, Integer>();
        if (ServerInstance.Release.COMPONENT) {
            for (Map.Entry entry : this.getItem().getEnchantments().entrySet()) {
                enchants.put(EnchantmentTag.of(entry.getKey()), (Integer)entry.getValue());
            }
            return enchants;
        }
        Object enchantments = this.getExact(EnchantmentTag.getEnchantmentKey((ItemStack)this.getTypeObject()));
        if (enchantments == null) {
            return enchants;
        }
        for (EnchantmentTag value : EnchantmentTag.VALUES) {
            for (Object o : TagList.getValue(enchantments)) {
                if (!value.compareKey(TagBase.getValue(TagCompound.get(o, "id")))) continue;
                enchants.put(value, Integer.parseInt(String.valueOf(TagBase.getValue(TagCompound.get(o, "lvl")))));
            }
        }
        return enchants;
    }

    public boolean isUnbreakable() {
        if (ServerInstance.Release.COMPONENT) {
            return DataComponent.Map.has(this.components, ComponentType.of("minecraft:unbreakable"));
        }
        return this.getOptional("Unbreakable").asBoolean(false);
    }

    public static <T extends ItemStack> T edit(T item, Consumer<RtagItem> consumer) {
        return RtagItem.edit(Rtag.INSTANCE, item, consumer);
    }

    public static <T extends ItemStack, R> R edit(T item, Function<RtagItem, R> function) {
        return RtagItem.edit(Rtag.INSTANCE, item, function);
    }

    public static <T extends ItemStack> T edit(Rtag rtag, T item, Consumer<RtagItem> consumer) {
        new RtagItem(rtag, item).edit(consumer).load();
        return item;
    }

    public static <T extends ItemStack, R> R edit(Rtag rtag, T item, Function<RtagItem, R> function) {
        return function.apply(new RtagItem(rtag, item));
    }
}

