/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag;

import com.saicone.rtag.util.ServerInstance;
import org.bukkit.plugin.java.JavaPlugin;

public class RtagPlugin
extends JavaPlugin {
    private static RtagPlugin instance;

    public static RtagPlugin get() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        this.getLogger().info("Found version " + ServerInstance.PACKAGE_VERSION + " (" + ServerInstance.DATA_VERSION + ")");
        this.loadRtagClass("util.EasyLookup", "util.ChatComponent", "util.EnchantmentTag", "util.ItemMaterialTag", "util.SkullTexture");
        this.loadRtagClass("Rtag", "RtagMirror");
        this.loadRtagClass("tag.TagBase", "tag.TagList", "tag.TagCompound");
        if (ServerInstance.Release.COMPONENT) {
            this.loadRtagClass("data.ComponentType", "data.DataComponent");
        }
        this.loadRtagClass("registry.IOValue");
        this.loadRtagClass("stream.TStream", "stream.TStreamTools");
        this.loadRtagClass("util.ProblemReporter");
        this.loadRtagClass("block.BlockObject");
        this.loadRtagClass("entity.EntityObject");
        this.loadRtagClass("item.ItemObject", "item.ItemTagStream");
    }

    private void loadRtagClass(String ... names) {
        for (String name : names) {
            try {
                Class<?> clazz = Class.forName("com.saicone.rtag." + name);
                for (Class<?> declared : clazz.getDeclaredClasses()) {
                    Class.forName(declared.getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

