/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.block;

import com.saicone.rtag.Rtag;
import com.saicone.rtag.registry.IOValue;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.util.EasyLookup;
import com.saicone.rtag.util.ProblemReporter;
import com.saicone.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BlockObject {
    private static final Class<?> BLOCK_STATE;
    private static final Class<?> TILE_ENTITY;
    private static final MethodHandle newBlockPosition;
    private static final MethodHandle getTileEntity;
    private static final MethodHandle getHandle;
    private static final MethodHandle getPosition;
    private static final MethodHandle getWorld;
    private static final MethodHandle getType;
    private static final MethodHandle getRegistry;
    private static final MethodHandle save;
    private static final MethodHandle load;

    BlockObject() {
    }

    public static boolean isTileEntity(Object object) {
        return TILE_ENTITY.isInstance(object);
    }

    public static Object getTileEntity(Block block) throws IllegalArgumentException {
        if (BLOCK_STATE.isInstance(block.getState())) {
            Location loc = block.getLocation();
            try {
                return getTileEntity.invoke(getHandle.invoke(loc.getWorld()), newBlockPosition.invoke(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot convert Bukkit Block into Minecraft TileEntity", t);
            }
        }
        throw new IllegalArgumentException("The provided block state isn't a CraftBlockState");
    }

    public static Object save(Object tile) {
        try {
            if (ServerInstance.Release.COMPONENT) {
                Object registry;
                Object world = getWorld.invoke(tile);
                Object object = registry = world != null ? getRegistry.invoke(world) : Rtag.getMinecraftRegistry();
                if (ServerInstance.VERSION >= 21.05f) {
                    Object output = IOValue.createOutput(ProblemReporter.DISCARDING, registry);
                    save.invoke(tile, output);
                    return IOValue.result(output);
                }
                return save.invoke(tile, registry);
            }
            if (ServerInstance.MAJOR_VERSION >= 18) {
                return save.invoke(tile);
            }
            if (ServerInstance.MAJOR_VERSION >= 9) {
                return save.invoke(tile, TagCompound.newTag());
            }
            Object tag = TagCompound.newTag();
            save.invoke(tile, tag);
            return tag;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void load(Object tile, Object tag) {
        try {
            if (ServerInstance.Release.COMPONENT) {
                Object registry;
                Object world = getWorld.invoke(tile);
                Object object = registry = world != null ? getRegistry.invoke(world) : Rtag.getMinecraftRegistry();
                if (ServerInstance.VERSION >= 21.05f) {
                    load.invoke(tile, IOValue.createInput(ProblemReporter.DISCARDING, registry, tag));
                } else {
                    load.invoke(tile, tag, registry);
                }
            } else if (ServerInstance.MAJOR_VERSION == 16) {
                Object blockData = getType.invoke(getWorld.invoke(tile), getPosition.invoke(tile));
                load.invoke(tile, tag, blockData);
            } else {
                load.invoke(tile, tag);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            EasyLookup.addNMSClass("core.BlockPosition", "BlockPos");
            EasyLookup.addNMSClass("server.level.WorldServer", "ServerLevel");
            EasyLookup.addNMSClass("world.level.World", "Level");
            EasyLookup.addNMSClass("world.level.block.entity.TileEntity", "BlockEntity");
            EasyLookup.addNMSClass("world.level.block.state.IBlockData", "BlockState");
            if (ServerInstance.MAJOR_VERSION >= 16) {
                EasyLookup.addNMSClass("core.IRegistryCustom", "RegistryAccess");
                EasyLookup.addNMSClass("world.level.IWorldReader", "LevelReader");
            }
            EasyLookup.addOBCClass("CraftWorld");
            EasyLookup.addOBCClass("block.CraftBlockState");
            if (ServerInstance.VERSION >= 21.05f) {
                EasyLookup.addNMSClass("world.level.storage.ValueInput");
                EasyLookup.addNMSClass("world.level.storage.ValueOutput");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        BLOCK_STATE = EasyLookup.classById("CraftBlockState");
        TILE_ENTITY = EasyLookup.classById("TileEntity");
        MethodHandle new$BlockPosition = null;
        MethodHandle method$getTileEntity = null;
        MethodHandle method$getHandle = null;
        MethodHandle method$getPosition = null;
        MethodHandle method$getWorld = null;
        MethodHandle method$getType = null;
        MethodHandle method$getRegistry = null;
        MethodHandle method$save = null;
        MethodHandle method$load = null;
        try {
            String getTileEntity = "getTileEntity";
            String save = "b";
            String load = "a";
            String getWorld = "i";
            String getRegistry = "H_";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                getTileEntity = "getBlockEntity";
                save = "saveWithoutMetadata";
                load = "load";
                getWorld = "getLevel";
                getRegistry = "registryAccess";
                if (ServerInstance.Release.COMPONENT) {
                    load = "loadWithComponents";
                }
            } else {
                if (ServerInstance.MAJOR_VERSION >= 9) {
                    save = "save";
                }
                if (ServerInstance.MAJOR_VERSION >= 12) {
                    load = "load";
                }
                if (ServerInstance.MAJOR_VERSION >= 18) {
                    getTileEntity = "c_";
                    save = "m";
                    load = "a";
                }
                if ((double)ServerInstance.VERSION >= 19.03) {
                    save = "o";
                }
                if (ServerInstance.Release.COMPONENT) {
                    save = "d";
                    load = "c";
                }
                if (ServerInstance.VERSION >= 21.02f) {
                    getRegistry = "K_";
                }
                if (ServerInstance.VERSION >= 21.04f) {
                    getRegistry = "J_";
                }
                if (ServerInstance.VERSION >= 21.05f) {
                    save = "e";
                    load = "b";
                    getRegistry = "K_";
                }
            }
            new$BlockPosition = EasyLookup.constructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method$getTileEntity = EasyLookup.method("World", getTileEntity, "TileEntity", "BlockPosition");
            method$getHandle = EasyLookup.method("CraftWorld", "getHandle", "WorldServer", new Object[0]);
            if (ServerInstance.Release.COMPONENT) {
                method$getWorld = EasyLookup.method(TILE_ENTITY, getWorld, "World", new Object[0]);
                method$getRegistry = EasyLookup.method("IWorldReader", getRegistry, "IRegistryCustom", new Object[0]);
            }
            method$save = ServerInstance.Release.COMPONENT ? (ServerInstance.VERSION >= 21.05f ? EasyLookup.method(TILE_ENTITY, save, Void.TYPE, "ValueOutput") : EasyLookup.method(TILE_ENTITY, save, "NBTTagCompound", "HolderLookup.Provider")) : (ServerInstance.MAJOR_VERSION >= 18 ? EasyLookup.method(TILE_ENTITY, save, "NBTTagCompound", new Object[0]) : EasyLookup.method(TILE_ENTITY, save, "NBTTagCompound", "NBTTagCompound"));
            if (ServerInstance.VERSION >= 21.05f) {
                method$load = EasyLookup.method(TILE_ENTITY, load, Void.TYPE, "ValueInput");
            } else if (ServerInstance.Release.COMPONENT) {
                method$load = EasyLookup.method(TILE_ENTITY, load, Void.TYPE, "NBTTagCompound", "HolderLookup.Provider");
            } else if (ServerInstance.MAJOR_VERSION == 16) {
                method$getPosition = EasyLookup.method(TILE_ENTITY, "getPosition", "BlockPosition", new Object[0]);
                method$getWorld = EasyLookup.method(TILE_ENTITY, "getWorld", "World", new Object[0]);
                method$getType = EasyLookup.method("World", "getType", "IBlockData", "BlockPosition");
                method$load = EasyLookup.method(TILE_ENTITY, load, Void.TYPE, "IBlockData", "NBTTagCompound");
            } else {
                method$load = EasyLookup.method(TILE_ENTITY, load, Void.TYPE, "NBTTagCompound");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        newBlockPosition = new$BlockPosition;
        getTileEntity = method$getTileEntity;
        getHandle = method$getHandle;
        getPosition = method$getPosition;
        getWorld = method$getWorld;
        getType = method$getType;
        getRegistry = method$getRegistry;
        save = method$save;
        load = method$load;
    }
}

