/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.entity;

import com.saicone.rtag.Rtag;
import com.saicone.rtag.registry.IOValue;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.util.EasyLookup;
import com.saicone.rtag.util.ProblemReporter;
import com.saicone.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;

public class EntityObject {
    private static final String POSITION_KEY = "Pos";
    private static final Class<?> MC_ENTITY;
    private static final Class<?> CRAFT_ENTITY;
    private static final MethodHandle getEntity;
    private static final MethodHandle getHandle;
    private static final MethodHandle getEncodeId;
    private static final MethodHandle saveAsPassenger;
    private static final MethodHandle saveWithoutId;
    private static final MethodHandle load;
    private static final MethodHandle registryAccess;

    EntityObject() {
    }

    public static boolean isMinecraftEntity(Object object) {
        return MC_ENTITY.isInstance(object);
    }

    public static boolean isCraftEntity(Object object) {
        return CRAFT_ENTITY.isInstance(object);
    }

    public static Entity getEntity(Object entity) throws IllegalArgumentException {
        if (MC_ENTITY.isInstance(entity)) {
            try {
                return getEntity.invoke(Bukkit.getServer(), entity);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot convert Minecraft Entity into Bukkit Entity", t);
            }
        }
        throw new IllegalArgumentException("The provided object isn't a Minecraft entity");
    }

    public static Object getHandle(Entity entity) {
        try {
            return getHandle.invoke(entity);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot convert Bukkit Entity into Minecraft Entity", t);
        }
    }

    public static String getEncodeId(Object entity) {
        return EntityObject.getEncodeId(entity, false);
    }

    public static String getEncodeId(Object entity, boolean includeNonSaveable) {
        try {
            if (ServerInstance.VERSION >= 21.03f && ServerInstance.Platform.PAPER) {
                return getEncodeId.invoke(entity, includeNonSaveable);
            }
            return getEncodeId.invoke(entity);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get encode ID from Minecraft Entity", t);
        }
    }

    public static Object save(Object entity) {
        return EntityObject.save(entity, TagCompound.newTag(), true, false, false);
    }

    public static Object save(Object entity, Object compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        EntityObject.saveWithoutId(entity, compound, includeAll, includeNonSaveable, forceSerialization);
        String id = EntityObject.getEncodeId(entity, includeNonSaveable);
        if (id != null) {
            TagCompound.set(compound, "id", TagBase.newTag(id));
        }
        return compound;
    }

    public static boolean saveAsPassenger(Object entity, Object compound) {
        return EntityObject.saveAsPassenger(entity, compound, true, false, false);
    }

    public static boolean saveAsPassenger(Object entity, Object compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        try {
            if (ServerInstance.VERSION >= 21.05f) {
                Object registry = registryAccess.invoke(entity);
                Object output = IOValue.createOutputWrapping(ProblemReporter.DISCARDING, registry != null ? registry : Rtag.getMinecraftRegistry(), compound);
                if (ServerInstance.Platform.PAPER) {
                    return saveAsPassenger.invoke(entity, output, includeAll, includeNonSaveable, forceSerialization);
                }
                return saveAsPassenger.invoke(entity, output, includeAll);
            }
            if (ServerInstance.VERSION >= 21.03f && ServerInstance.Platform.PAPER) {
                return saveAsPassenger.invoke(entity, TagCompound.newTag(), includeAll, includeNonSaveable, forceSerialization);
            }
            if (ServerInstance.VERSION >= 20.02f) {
                return saveAsPassenger.invoke(entity, TagCompound.newTag(), includeAll);
            }
            boolean result = saveAsPassenger.invoke(entity, TagCompound.newTag());
            if (result && !includeAll) {
                TagCompound.remove(compound, POSITION_KEY);
            }
            return result;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object saveWithoutId(Object entity, Object compound) {
        return EntityObject.saveWithoutId(entity, compound, true, false, false);
    }

    public static Object saveWithoutId(Object entity, Object compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        try {
            if (ServerInstance.VERSION >= 21.05f) {
                Object registry = registryAccess.invoke(entity);
                Object output = IOValue.createOutputWrapping(ProblemReporter.DISCARDING, registry != null ? registry : Rtag.getMinecraftRegistry(), compound);
                if (ServerInstance.Platform.PAPER) {
                    saveWithoutId.invoke(entity, output, includeAll, includeNonSaveable, forceSerialization);
                } else {
                    saveWithoutId.invoke(entity, output, includeAll);
                }
                return IOValue.result(output);
            }
            if (ServerInstance.VERSION >= 21.03f && ServerInstance.Platform.PAPER) {
                return saveWithoutId.invoke(entity, compound, includeAll, includeNonSaveable, forceSerialization);
            }
            if (ServerInstance.VERSION >= 20.02f) {
                return saveWithoutId.invoke(entity, compound, includeAll);
            }
            saveWithoutId.invoke(entity, compound);
            if (!includeAll) {
                TagCompound.remove(compound, POSITION_KEY);
            }
            return compound;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void load(Object entity, Object tag) {
        try {
            if (ServerInstance.VERSION >= 21.05f) {
                Object registry = registryAccess.invoke(entity);
                load.invoke(entity, IOValue.createInput(ProblemReporter.DISCARDING, registry != null ? registry : Rtag.getMinecraftRegistry(), tag));
            } else {
                load.invoke(entity, tag);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            EasyLookup.addNMSClass("world.entity.Entity");
            EasyLookup.addOBCClass("CraftServer");
            EasyLookup.addOBCClass("entity.CraftEntity");
            if (ServerInstance.MAJOR_VERSION >= 16) {
                EasyLookup.addNMSClass("core.IRegistryCustom", "RegistryAccess");
            }
            if (ServerInstance.VERSION >= 21.05f) {
                EasyLookup.addNMSClass("world.level.storage.ValueInput");
                EasyLookup.addNMSClass("world.level.storage.ValueOutput");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        MC_ENTITY = EasyLookup.classById("Entity");
        CRAFT_ENTITY = EasyLookup.classById("CraftEntity");
        MethodHandle method$getEntity = null;
        MethodHandle method$getHandle = null;
        MethodHandle method$getEncodeId = null;
        MethodHandle method$saveAsPassenger = null;
        MethodHandle method$saveWithoutId = null;
        MethodHandle method$load = null;
        MethodHandle method$registryAccess = null;
        try {
            String getEncodeId = "ag";
            String saveAsPassenger = "c";
            String saveWithoutId = "e";
            String load = "f";
            String registryAccess = "dR";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                getEncodeId = "getEncodeId";
                saveAsPassenger = "saveAsPassenger";
                saveWithoutId = "saveWithoutId";
                load = "load";
                registryAccess = "registryAccess";
            } else {
                if (ServerInstance.MAJOR_VERSION >= 9) {
                    getEncodeId = "as";
                }
                if (ServerInstance.MAJOR_VERSION >= 10) {
                    getEncodeId = "at";
                }
                if (ServerInstance.MAJOR_VERSION >= 12) {
                    getEncodeId = "getSaveID";
                    saveWithoutId = "save";
                }
                if (ServerInstance.MAJOR_VERSION >= 16) {
                    saveAsPassenger = "a_";
                    load = "load";
                }
                if (ServerInstance.MAJOR_VERSION >= 17) {
                    saveAsPassenger = "d";
                }
                if (ServerInstance.MAJOR_VERSION >= 18) {
                    getEncodeId = "bk";
                    saveWithoutId = "f";
                    load = "g";
                }
                if (ServerInstance.MAJOR_VERSION >= 19) {
                    getEncodeId = "bn";
                }
                if (ServerInstance.VERSION >= 19.02f) {
                    getEncodeId = "bq";
                }
                if (ServerInstance.VERSION >= 19.03f) {
                    getEncodeId = "bp";
                }
                if (ServerInstance.MAJOR_VERSION >= 20) {
                    getEncodeId = "br";
                }
                if (ServerInstance.VERSION >= 20.02f) {
                    getEncodeId = "bu";
                    saveAsPassenger = "saveAsPassenger";
                    saveWithoutId = "saveWithoutId";
                }
                if (ServerInstance.VERSION >= 20.03f) {
                    getEncodeId = "bw";
                }
                if (ServerInstance.VERSION >= 20.04f) {
                    getEncodeId = "bC";
                }
                if (ServerInstance.MAJOR_VERSION >= 21) {
                    getEncodeId = "bD";
                    registryAccess = "dQ";
                }
                if (ServerInstance.VERSION >= 21.02f) {
                    getEncodeId = "bK";
                    registryAccess = "dY";
                }
                if (ServerInstance.VERSION >= 21.03f) {
                    registryAccess = "dX";
                }
                if (ServerInstance.VERSION >= 21.04f) {
                    getEncodeId = "bI";
                    load = "i";
                }
                if (ServerInstance.VERSION >= 21.05f) {
                    getEncodeId = "bN";
                    load = "e";
                    registryAccess = "eb";
                }
            }
            method$getEntity = EasyLookup.staticMethod("CraftEntity", "getEntity", "CraftEntity", "CraftServer", "Entity");
            method$getHandle = EasyLookup.method("CraftEntity", "getHandle", "Entity", new Object[0]);
            method$getEncodeId = ServerInstance.VERSION >= 21.03f && ServerInstance.Platform.PAPER ? EasyLookup.method("Entity", getEncodeId, String.class, Boolean.TYPE) : EasyLookup.method("Entity", getEncodeId, String.class, new Object[0]);
            method$saveAsPassenger = ServerInstance.VERSION >= 21.05f ? (ServerInstance.Platform.PAPER ? EasyLookup.method("Entity", saveAsPassenger, Boolean.TYPE, "ValueOutput", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE) : EasyLookup.method("Entity", saveAsPassenger, Boolean.TYPE, "ValueOutput", Boolean.TYPE)) : (ServerInstance.VERSION >= 21.03f && ServerInstance.Platform.PAPER ? EasyLookup.method("Entity", saveAsPassenger, Boolean.TYPE, "NBTTagCompound", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE) : (ServerInstance.VERSION >= 20.02f ? EasyLookup.method("Entity", saveAsPassenger, Boolean.TYPE, "NBTTagCompound", Boolean.TYPE) : EasyLookup.method("Entity", saveAsPassenger, Boolean.TYPE, "NBTTagCompound")));
            method$saveWithoutId = ServerInstance.VERSION >= 21.05f ? (ServerInstance.Platform.PAPER ? EasyLookup.method("Entity", saveWithoutId, Void.TYPE, "ValueOutput", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE) : EasyLookup.method("Entity", saveWithoutId, Void.TYPE, "ValueOutput", Boolean.TYPE)) : (ServerInstance.VERSION >= 21.03f && ServerInstance.Platform.PAPER ? EasyLookup.method("Entity", saveWithoutId, "NBTTagCompound", "NBTTagCompound", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE) : (ServerInstance.VERSION >= 20.02f ? EasyLookup.method("Entity", saveWithoutId, "NBTTagCompound", "NBTTagCompound", Boolean.TYPE) : EasyLookup.method("Entity", saveWithoutId, "NBTTagCompound", "NBTTagCompound")));
            method$load = ServerInstance.VERSION >= 21.05f ? EasyLookup.method("Entity", load, Void.TYPE, "ValueInput") : EasyLookup.method("Entity", load, Void.TYPE, "NBTTagCompound");
            if (ServerInstance.Release.COMPONENT) {
                method$registryAccess = EasyLookup.method("Entity", registryAccess, "IRegistryCustom", new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        getEntity = method$getEntity;
        getHandle = method$getHandle;
        getEncodeId = method$getEncodeId;
        saveAsPassenger = method$saveAsPassenger;
        saveWithoutId = method$saveWithoutId;
        load = method$load;
        registryAccess = method$registryAccess;
    }
}

