/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.saicone.rtag.data.ComponentType;
import com.saicone.rtag.data.DataComponent;
import com.saicone.rtag.item.ItemData;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.util.EasyLookup;
import com.saicone.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class ItemObject {
    private static final Class<?> MC_ITEM;
    private static final Class<?> CRAFT_ITEM;
    private static final Object CUSTOM_DATA;
    private static final Object ITEM_REGISTRY;
    private static final Object CODEC;
    private static final MethodHandle newItem;
    private static final MethodHandle newCustomData;
    private static final MethodHandle newMinecraftKey;
    private static final MethodHandle save;
    private static final MethodHandle apply;
    private static final MethodHandle copy;
    private static final MethodHandle isEmpty;
    private static final MethodHandle getItem;
    private static final MethodHandle getTag;
    private static final MethodHandle setItem;
    private static final MethodHandle setTag;
    private static final MethodHandle setCount;
    private static final MethodHandle newCraftItem;
    private static final MethodHandle getHandleField;
    private static final MethodHandle setHandleField;
    private static final MethodHandle getCraftStack;
    private static final MethodHandle asBukkitCopy;
    private static final MethodHandle asCraftMirror;
    private static final MethodHandle asNMSCopy;

    ItemObject() {
    }

    public static Object newItem(Object compound) {
        try {
            if (ServerInstance.Release.COMPONENT) {
                return ((Codec)CODEC).parse((DynamicOps)ComponentType.createGlobalContext(ComponentType.NBT_OPS), compound).result().orElse(null);
            }
            return newItem.invoke(compound);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static ItemStack newCraftItem(ItemStack item) {
        try {
            return newCraftItem.invoke(item);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot create CraftItemStack using ItemStack object", t);
        }
    }

    public static boolean isMinecraftItem(Object object) {
        return MC_ITEM.isInstance(object);
    }

    public static boolean isCraftItem(Object object) {
        return CRAFT_ITEM.isInstance(object);
    }

    public static boolean isEmpty(Object item) {
        try {
            if (ServerInstance.MAJOR_VERSION >= 11) {
                return isEmpty.invoke(item);
            }
            return isEmpty.invoke(item) <= 0;
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot check if ItemStack is empty", t);
        }
    }

    public static boolean hasCustomData(Object item) {
        if (ServerInstance.Release.COMPONENT) {
            return DataComponent.Holder.has(item, CUSTOM_DATA);
        }
        try {
            return getTag.invoke(item) != null;
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get tag from Minecraft ItemStack", t);
        }
    }

    public static Object save(Object item) {
        if (item == null) {
            return TagCompound.newTag();
        }
        try {
            if (ServerInstance.Release.COMPONENT) {
                if (isEmpty.invoke(item)) {
                    return TagCompound.newTag();
                }
                return ((Codec)CODEC).encode(item, (DynamicOps)ComponentType.createGlobalContext(ComponentType.NBT_OPS), TagCompound.newTag()).getOrThrow();
            }
            return save.invoke(item, TagCompound.newTag());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static void load(Object item, Object compound) {
        if (ServerInstance.Release.COMPONENT) {
            Object components;
            Object count;
            Object id = TagCompound.get(compound, "id");
            if (id != null) {
                try {
                    Object loadedItem = getItem.invoke(ITEM_REGISTRY, newMinecraftKey.invoke(TagBase.getValue(id)));
                    if (loadedItem != null) {
                        setItem.invoke(item, loadedItem);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Cannot set item id", t);
                }
            }
            if ((count = TagCompound.get(compound, "count")) != null) {
                try {
                    setCount.invoke(item, Integer.parseInt(String.valueOf(TagBase.getValue(count))));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Cannot set item count", t);
                }
            }
            if ((components = TagCompound.get(compound, "components")) != null) {
                DataComponent.Builder<Optional<?>> builder = DataComponent.Patch.builder();
                for (Map.Entry<String, Object> entry : TagCompound.getValue(components).entrySet()) {
                    Object type = ComponentType.of(entry.getKey());
                    if (type == null) continue;
                    ComponentType.parseNbt(entry.getKey(), entry.getValue()).ifPresent(component -> builder.set(type, Optional.of(component)));
                }
                ItemObject.apply(item, builder.build());
            }
        } else {
            ItemObject.apply(item, compound);
        }
    }

    public static void loadHandle(ItemStack item, Object handle) {
        ItemStack mirror = ItemObject.asCraftMirror(handle);
        if (mirror != null) {
            item.setType(mirror.getType());
            item.setAmount(mirror.getAmount());
            if (ServerInstance.Release.LEGACY) {
                item.setDurability(mirror.getDurability());
            }
            item.setItemMeta(mirror.getItemMeta());
        }
    }

    public static void apply(Object item, Object component) {
        try {
            apply.invoke(item, component);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object copy(Object item) {
        if (ServerInstance.Release.COMPONENT) {
            try {
                return copy.invoke(item);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot copy the provided Minecraft ItemStack", t);
            }
        }
        return ItemObject.newItem(ItemObject.save(item));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static Object[] getComponentPath(Object ... path) throws IndexOutOfBoundsException {
        return ItemData.getComponentPath(0, 0, path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static Object[] getComponentPath(int srcPos, int destPos, Object ... src) throws IndexOutOfBoundsException {
        return ItemData.getComponentPath(srcPos, destPos, src);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static Object[] getTagPath(Object ... path) throws IndexOutOfBoundsException {
        return ItemData.getTagPath(1, 0, path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static Object[] getTagPath(int srcPos, int destPos, Object ... src) throws IndexOutOfBoundsException {
        return ItemData.getTagPath(srcPos, destPos, src);
    }

    public static ItemStack getCraftStack(ItemStack item) {
        if (getCraftStack != null) {
            try {
                return getCraftStack.invoke(item);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot get CraftItemStack from ItemStack object", t);
            }
        }
        if (CRAFT_ITEM.isInstance(item)) {
            return item;
        }
        return null;
    }

    public static Object getHandle(ItemStack item) {
        if (CRAFT_ITEM.isInstance(item)) {
            return ItemObject.getUncheckedHandle(item);
        }
        return ItemObject.asNMSCopy(item);
    }

    public static Object getUncheckedHandle(ItemStack item) {
        try {
            return getHandleField.invoke(item);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object getCustomDataTag(Object item) {
        if (ServerInstance.Release.COMPONENT) {
            Object customData = DataComponent.Holder.get(item, CUSTOM_DATA);
            if (customData == null) {
                return null;
            }
            try {
                return getTag.invoke(customData);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot get tag from custom data component", t);
            }
        }
        try {
            return getTag.invoke(item);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get tag from Minecraft ItemStack", t);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static Object getTag(Object item) {
        return ItemObject.getCustomDataTag(item);
    }

    public static void setHandle(ItemStack item, Object handle) {
        if (CRAFT_ITEM.isInstance(item)) {
            try {
                setHandleField.invoke(item, handle);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot set handle into CraftItemStack", t);
            }
        } else {
            ItemStack copy = ItemObject.asBukkitCopy(handle);
            if (copy != null) {
                item.setType(copy.getType());
                item.setAmount(copy.getAmount());
                if (ServerInstance.Release.LEGACY) {
                    item.setDurability(copy.getDurability());
                }
                item.setItemMeta(copy.getItemMeta());
            }
        }
    }

    public static void setCustomDataTag(Object item, Object tag) {
        if (ServerInstance.Release.COMPONENT) {
            try {
                if (tag == null || TagCompound.getValue(tag).isEmpty()) {
                    DataComponent.MapPatch.remove(DataComponent.Holder.getComponents(item), CUSTOM_DATA);
                }
                DataComponent.MapPatch.set(DataComponent.Holder.getComponents(item), CUSTOM_DATA, newCustomData.invoke(tag));
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot set custom data tag to Minecraft ItemStack", t);
            }
        } else {
            try {
                setTag.invoke(item, tag);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot set tag to Minecraft ItemStack", t);
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static void setTag(Object item, Object tag) {
        ItemObject.setCustomDataTag(item, tag);
    }

    public static ItemStack asBukkitCopy(Object item) {
        try {
            return asBukkitCopy.invoke(item);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot convert Minecraft ItemStack into Bukkit ItemStack", t);
        }
    }

    public static ItemStack asCraftMirror(Object item) {
        try {
            return asCraftMirror.invoke(item);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot convert Minecraft ItemStack into Bukkit ItemStack", t);
        }
    }

    public static Object asNMSCopy(ItemStack item) {
        try {
            return asNMSCopy.invoke(item);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot convert Bukkit ItemStack into Minecraft ItemStack", t);
        }
    }

    static {
        try {
            EasyLookup.addNMSClass("world.item.ItemStack");
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("core.RegistryBlocks", "DefaultedRegistry");
                EasyLookup.addNMSClass("world.item.component.CustomData");
            }
            EasyLookup.addOBCClass("inventory.CraftItemStack");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        MC_ITEM = EasyLookup.classById("ItemStack");
        CRAFT_ITEM = EasyLookup.classById("CraftItemStack");
        Object const$customData = null;
        Object const$item = null;
        Object const$codec = null;
        MethodHandle new$ItemStack = null;
        MethodHandle new$CustomData = null;
        MethodHandle new$MinecraftKey = null;
        MethodHandle new$CraftItemStack = null;
        MethodHandle get$handle = null;
        MethodHandle set$handle = null;
        MethodHandle method$save = null;
        MethodHandle method$apply = null;
        MethodHandle method$copy = null;
        MethodHandle method$isEmpty = null;
        MethodHandle method$getItem = null;
        MethodHandle method$getTag = null;
        MethodHandle method$setItem = null;
        MethodHandle method$setTag = null;
        MethodHandle method$setCount = null;
        MethodHandle method$getCraftStack = null;
        MethodHandle method$asBukkitCopy = null;
        MethodHandle method$asNMSCopy = null;
        MethodHandle method$asCraftMirror = null;
        try {
            String registry$item = "h";
            String key$parse = "a";
            String codec = "b";
            String createStack = "createStack";
            String save = "save";
            String apply = "c";
            String copy = "s";
            String isEmpty = "isEmpty";
            String getItem = "a";
            String getTag = "getTag";
            String setItem = "q";
            String setTag = "setTag";
            String setCount = "e";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                registry$item = "ITEM";
                key$parse = "parse";
                codec = "CODEC";
                apply = "load";
                getItem = "get";
                setItem = "item";
                if (ServerInstance.Release.COMPONENT) {
                    apply = "applyComponentsAndValidate";
                    copy = "copy";
                    getTag = "tag";
                    setCount = "setCount";
                }
                if (ServerInstance.VERSION >= 21.02f) {
                    getItem = "getValue";
                }
            } else {
                if (ServerInstance.MAJOR_VERSION >= 11) {
                    apply = "load";
                }
                if (ServerInstance.MAJOR_VERSION >= 13) {
                    createStack = "a";
                }
                if (ServerInstance.MAJOR_VERSION >= 18) {
                    save = "b";
                    isEmpty = "b";
                    getTag = "s";
                    setTag = "c";
                }
                if ((double)ServerInstance.VERSION >= 18.02) {
                    getTag = "t";
                }
                if (ServerInstance.MAJOR_VERSION >= 19) {
                    getTag = "u";
                }
                if (ServerInstance.MAJOR_VERSION >= 20) {
                    getTag = "v";
                }
                if (ServerInstance.Release.COMPONENT) {
                    apply = "a";
                    isEmpty = "e";
                    getTag = "e";
                }
                if (ServerInstance.DATA_VERSION >= 3839) {
                    getTag = "f";
                }
                if (ServerInstance.MAJOR_VERSION >= 21) {
                    registry$item = "g";
                }
                if (ServerInstance.VERSION >= 21.02f) {
                    codec = "a";
                    copy = "v";
                    isEmpty = "f";
                    setItem = "o";
                }
                if (ServerInstance.VERSION >= 21.03f) {
                    getTag = "g";
                    setItem = "p";
                }
                if (ServerInstance.VERSION >= 21.04f) {
                    codec = "b";
                    setItem = "s";
                }
            }
            if (ServerInstance.Release.COMPONENT) {
                const$customData = ComponentType.of("minecraft:custom_data");
                const$item = EasyLookup.classById("BuiltInRegistries").getDeclaredField(registry$item).get(null);
                const$codec = MC_ITEM.getDeclaredField(codec).get(null);
                new$CustomData = EasyLookup.constructor("CustomData", "NBTTagCompound");
                new$MinecraftKey = ServerInstance.MAJOR_VERSION >= 21 ? EasyLookup.staticMethod("MinecraftKey", key$parse, "MinecraftKey", String.class) : EasyLookup.constructor("MinecraftKey", String.class);
                method$apply = EasyLookup.method(MC_ITEM, apply, Void.TYPE, "DataComponentPatch");
                method$copy = EasyLookup.method(MC_ITEM, copy, MC_ITEM, new Object[0]);
                method$getItem = EasyLookup.method("RegistryBlocks", getItem, Object.class, "MinecraftKey");
                method$getTag = EasyLookup.getter("CustomData", getTag, "NBTTagCompound");
                method$setItem = EasyLookup.unreflectSetter(MC_ITEM, setItem);
                method$setCount = EasyLookup.method(MC_ITEM, setCount, Void.TYPE, Integer.TYPE);
            } else {
                new$ItemStack = ServerInstance.MAJOR_VERSION >= 13 || ServerInstance.MAJOR_VERSION <= 10 ? EasyLookup.staticMethod(MC_ITEM, createStack, "ItemStack", "NBTTagCompound") : EasyLookup.constructor(MC_ITEM, "NBTTagCompound");
                method$save = EasyLookup.method(MC_ITEM, save, "NBTTagCompound", "NBTTagCompound");
                method$apply = EasyLookup.method(MC_ITEM, apply, Void.TYPE, "NBTTagCompound");
                method$getTag = EasyLookup.method(MC_ITEM, getTag, "NBTTagCompound", new Object[0]);
                method$setTag = EasyLookup.method(MC_ITEM, setTag, Void.TYPE, "NBTTagCompound");
            }
            method$isEmpty = ServerInstance.MAJOR_VERSION >= 11 ? EasyLookup.method(MC_ITEM, isEmpty, Boolean.TYPE, new Object[0]) : EasyLookup.getter(MC_ITEM, "count", Integer.TYPE);
            new$CraftItemStack = EasyLookup.constructor(CRAFT_ITEM, ItemStack.class);
            get$handle = EasyLookup.getter(CRAFT_ITEM, "handle", MC_ITEM);
            set$handle = EasyLookup.setter(CRAFT_ITEM, "handle", MC_ITEM);
            if (ServerInstance.Platform.PAPER && ServerInstance.MAJOR_VERSION >= 21) {
                method$getCraftStack = EasyLookup.method(CRAFT_ITEM, "getCraftStack", CRAFT_ITEM, ItemStack.class);
            }
            method$asBukkitCopy = EasyLookup.staticMethod(CRAFT_ITEM, "asBukkitCopy", ItemStack.class, "ItemStack");
            method$asCraftMirror = EasyLookup.staticMethod(CRAFT_ITEM, "asCraftMirror", CRAFT_ITEM, "ItemStack");
            method$asNMSCopy = EasyLookup.staticMethod(CRAFT_ITEM, "asNMSCopy", "ItemStack", ItemStack.class);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        CUSTOM_DATA = const$customData;
        ITEM_REGISTRY = const$item;
        CODEC = const$codec;
        newItem = new$ItemStack;
        newCustomData = new$CustomData;
        newMinecraftKey = new$MinecraftKey;
        save = method$save;
        apply = method$apply;
        copy = method$copy;
        isEmpty = method$isEmpty;
        getItem = method$getItem;
        getTag = method$getTag;
        setItem = method$setItem;
        setTag = method$setTag;
        setCount = method$setCount;
        newCraftItem = new$CraftItemStack;
        getHandleField = get$handle;
        setHandleField = set$handle;
        getCraftStack = method$getCraftStack;
        asBukkitCopy = method$asBukkitCopy;
        asCraftMirror = method$asCraftMirror;
        asNMSCopy = method$asNMSCopy;
    }
}

