/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.saicone.rtag.util.EasyLookup;
import com.saicone.rtag.util.ServerInstance;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullTexture {
    @Deprecated
    private static final String INVALID_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ==";
    @Deprecated
    private static final String LOADING_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzI0MzE5MTFmNDE3OGI0ZDJiNDEzYWE3ZjVjNzhhZTQ0NDdmZTkyNDY5NDNjMzFkZjMxMTYzYzBlMDQzZTBkNiJ9fX0=";
    private static final String TEXTURE_URL = "http://textures.minecraft.net/texture/";
    private static final MethodHandle NEW_PROFILE;
    private static final MethodHandle GET_PROFILE;
    private static final MethodHandle GET_PLAYER_PROFILE;
    private static final MethodHandle GET_META_PROFILE;
    private static final MethodHandle SET_META_PROFILE;
    private static final MethodHandle GET_VALUE;
    private static final MethodHandle GET_SIGNATURE;
    private static final JsonParser JSON_PARSER;
    private static final Supplier<ItemStack> PLAYER_HEAD;
    protected final Cache<String, Profile> cache;
    protected final Executor executor;

    public static SkullTexture mojang() {
        return Mojang.INSTANCE;
    }

    public static SkullTexture playerDB() {
        return PlayerDB.INSTANCE;
    }

    public static SkullTexture craftHead() {
        return CraftHead.INSTANCE;
    }

    public SkullTexture() {
        this((Cache<String, Profile>)CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.HOURS).build());
    }

    public SkullTexture(@Nullable Cache<String, Profile> cache) {
        this(cache, CompletableFuture.completedFuture(null).defaultExecutor());
    }

    public SkullTexture(@NotNull Executor executor) {
        this((Cache<String, Profile>)CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.HOURS).build(), executor);
    }

    public SkullTexture(@Nullable Cache<String, Profile> cache, @NotNull Executor executor) {
        this.cache = cache;
        this.executor = executor;
    }

    @NotNull
    protected Profile caching(@NotNull Object key, @NotNull Supplier<Profile> supplier) {
        if (this.cache == null) {
            return supplier.get();
        }
        Profile value = (Profile)this.cache.getIfPresent((Object)String.valueOf(key));
        if (value == null) {
            try {
                value = supplier.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (value == null) {
                value = Profile.empty();
            }
            this.cache.put((Object)String.valueOf(key), (Object)value);
        }
        return value;
    }

    @NotNull
    public ItemStack item(@NotNull Object object) {
        return SkullTexture.setProfile(PLAYER_HEAD.get(), this.profileFrom(object));
    }

    @NotNull
    public CompletableFuture<ItemStack> itemAsync(@NotNull Object object) {
        return this.itemAsync(object, this.executor);
    }

    @NotNull
    public CompletableFuture<ItemStack> itemAsync(@NotNull Object object, @NotNull Executor executor) {
        Object key = object instanceof Player ? ((Player)object).getUniqueId() : object;
        Profile profile = (Profile)this.cache.getIfPresent((Object)String.valueOf(key));
        if (profile != null) {
            return CompletableFuture.completedFuture(SkullTexture.setProfile(PLAYER_HEAD.get(), profile));
        }
        return CompletableFuture.supplyAsync(() -> SkullTexture.setProfile(PLAYER_HEAD.get(), this.profileFrom(object)), executor);
    }

    @NotNull
    public Profile profileFrom(@NotNull Object object) {
        if (object instanceof Profile) {
            return this.caching(((Profile)object).getUniqueId(), () -> (Profile)object);
        }
        if (object instanceof Player) {
            return this.caching(((Player)object).getUniqueId(), () -> this.profileFromPlayer((Player)object));
        }
        if (object instanceof UUID) {
            return this.caching(object, () -> this.profileFromId((UUID)object));
        }
        String value = String.valueOf(object);
        return this.caching(value, () -> {
            if (value.length() < 32) {
                return this.profileFromName(value);
            }
            if (value.length() == 32 || value.length() == 36) {
                return this.profileFromId(value);
            }
            if (value.startsWith("http")) {
                return Profile.valueOf(this.encodeUrl(value));
            }
            if (value.length() >= 60 && value.length() <= 100) {
                return Profile.valueOf(this.encodeUrlId(value));
            }
            return Profile.valueOf(value);
        });
    }

    @NotNull
    public Profile profileFromPlayer(@Nullable Player player) {
        return SkullTexture.getProfile(player);
    }

    @NotNull
    public Profile profileFromName(@NotNull String name) {
        Profile profile = this.profileFromPlayer(Bukkit.getPlayer((String)name));
        return profile.isEmpty() || profile.isOffline() ? this.fetchProfile(name) : profile;
    }

    @NotNull
    public Profile profileFromId(@NotNull String uniqueId) {
        if (uniqueId.length() == 32) {
            return this.profileFromId(UUID.fromString(new StringBuilder(uniqueId).insert(20, '-').insert(16, '-').insert(12, '-').insert(8, '-').toString()));
        }
        return this.profileFromId(UUID.fromString(uniqueId));
    }

    @NotNull
    public Profile profileFromId(@NotNull UUID uniqueId) {
        Profile profile = this.profileFromPlayer(Bukkit.getPlayer((UUID)uniqueId));
        return profile.isEmpty() || profile.isOffline() ? this.fetchProfile(uniqueId) : profile;
    }

    @NotNull
    public String encodeUrl(@NotNull String url) {
        return new String(Base64.getEncoder().encode(("{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}").getBytes()));
    }

    @NotNull
    public String encodeUrlId(@NotNull String id) {
        return this.encodeUrl(TEXTURE_URL + id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected Optional<JsonObject> fetchJson(@NotNull String url) {
        try (InputStream stream = new URL(url).openStream();){
            String content = new String(stream.readAllBytes());
            if (content.isBlank()) {
                Optional<JsonObject> optional2 = Optional.empty();
                return optional2;
            }
            JsonObject json = JSON_PARSER.parse(content).getAsJsonObject();
            Optional<JsonObject> optional = Optional.of(json);
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read json from url", e);
        }
    }

    @NotNull
    public Profile fetchProfile(@NotNull String name) {
        throw new IllegalStateException("Current SkullTexture instance doesn't provide texture lookup using player name");
    }

    @NotNull
    public Profile fetchProfile(@NotNull UUID uniqueId) {
        throw new IllegalStateException("Current SkullTexture instance doesn't provide texture lookup using player id");
    }

    @NotNull
    public Profile profileSession(@NotNull JsonObject session, @NotNull String idKey, @NotNull String nameKey) {
        JsonPrimitive id = session.getAsJsonPrimitive(idKey);
        JsonPrimitive name = session.getAsJsonPrimitive(nameKey);
        UUID uniqueId = id == null || id.isJsonNull() ? Profile.EMPTY_ID : UUID.fromString(new StringBuilder(id.getAsString()).insert(20, '-').insert(16, '-').insert(12, '-').insert(8, '-').toString());
        JsonArray properties = session.getAsJsonArray("properties");
        if (properties != null) {
            for (JsonElement element : properties) {
                JsonObject property = element.getAsJsonObject();
                if (!property.getAsJsonPrimitive("name").getAsString().equalsIgnoreCase("textures")) continue;
                JsonPrimitive value = property.getAsJsonPrimitive("value");
                JsonPrimitive signature = property.getAsJsonPrimitive("signature");
                return Profile.valueOf(uniqueId, name != null ? name.getAsString() : "null", value != null ? value.getAsString() : null, signature != null ? signature.getAsString() : null);
            }
        }
        return Profile.valueOf(uniqueId, name != null ? name.getAsString() : "null");
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    public static ItemStack setTexture(@NotNull ItemStack head, @Nullable String texture) throws IllegalArgumentException {
        if (texture == null) {
            return head;
        }
        return SkullTexture.setProfile(head, Profile.valueOf(texture));
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    public static ItemStack setProfile(@NotNull ItemStack head, @NotNull Profile profile) throws IllegalArgumentException {
        if (profile.isEmpty()) {
            return head;
        }
        ItemMeta meta = head.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            throw new IllegalArgumentException("The provided item isn't a player head");
        }
        try {
            if (NEW_PROFILE != null) {
                SET_META_PROFILE.invoke(meta, NEW_PROFILE.invoke(profile.getProfile()));
            } else {
                SET_META_PROFILE.invoke(meta, profile.getProfile());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot set profile value to ItemStack", t);
        }
        head.setItemMeta(meta);
        return head;
    }

    @NotNull
    public static Profile getProfile(@Nullable ItemStack item) {
        if (item == null) {
            return Profile.empty();
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            return Profile.empty();
        }
        try {
            Object profile = GET_META_PROFILE.invoke(meta);
            if (profile == null) {
                return Profile.empty();
            }
            if (profile instanceof GameProfile) {
                return new Profile((GameProfile)profile);
            }
            return new Profile(GET_PROFILE.invoke(profile));
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get profile from item", t);
        }
    }

    @NotNull
    public static Profile getProfile(@Nullable Player player) {
        if (player == null) {
            return Profile.empty();
        }
        try {
            return new Profile(GET_PLAYER_PROFILE.invoke(player));
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get online player profile from '" + player.getName() + "'", t);
        }
    }

    @Deprecated
    public static ItemStack getTexturedHead(String texture) {
        return SkullTexture.setTexture(PLAYER_HEAD.get(), SkullTexture.getTextureValue(texture));
    }

    @Deprecated
    public static ItemStack getTexturedHead(String texture, Consumer<ItemStack> callback) {
        if (callback == null) {
            return SkullTexture.getTexturedHead(texture);
        }
        return SkullTexture.setTexture(PLAYER_HEAD.get(), SkullTexture.getTextureValue(texture, value -> callback.accept(SkullTexture.setTexture(PLAYER_HEAD.get(), value))));
    }

    @Deprecated
    public static String getTextureValue(String texture) {
        return SkullTexture.getTextureValue(texture, null);
    }

    @Deprecated
    public static String getTextureValue(String texture, Consumer<String> callback) {
        Profile profile;
        if (texture.length() <= 20 || texture.length() == 36) {
            profile = (Profile)SkullTexture.mojang().cache.getIfPresent((Object)texture);
            if (profile == null) {
                profile = Profile.valueOf(LOADING_TEXTURE);
                SkullTexture.mojang().cache.put((Object)texture, (Object)profile);
                CompletableFuture.supplyAsync(() -> {
                    if (texture.length() == 36) {
                        return SkullTexture.mojang().profileFromId(texture);
                    }
                    return SkullTexture.mojang().profileFromName(texture);
                }).thenAccept(result -> {
                    if (!result.isEmpty()) {
                        SkullTexture.mojang().cache.put((Object)texture, result);
                        if (callback != null) {
                            result.getTexture().ifPresent(callback);
                        }
                    }
                });
            }
        } else {
            profile = SkullTexture.mojang().profileFrom(texture);
        }
        return profile.getTexture().orElse(null);
    }

    @Deprecated
    public static String computePlayerTexture(@NotNull String name) {
        return SkullTexture.computePlayerTexture(name, name);
    }

    @Deprecated
    public static String computePlayerTexture(@NotNull String key, @NotNull String name) {
        String texture = SkullTexture.requestTextureUrl(name);
        if (texture != null) {
            texture = SkullTexture.mojang().encodeUrl(texture);
            SkullTexture.mojang().cache.put((Object)key, (Object)Profile.valueOf(texture));
            return texture;
        }
        SkullTexture.mojang().cache.put((Object)key, (Object)Profile.valueOf(INVALID_TEXTURE));
        return INVALID_TEXTURE;
    }

    @Deprecated
    public static String requestTextureUrl(@NotNull String name) {
        Profile profile = SkullTexture.mojang().fetchProfile(name);
        if (profile == null) {
            return null;
        }
        return profile.getTexture().map(value -> {
            JsonObject texture = SkullTexture.parseJsonObject(new String(Base64.getDecoder().decode((String)value)));
            if (texture != null) {
                return texture.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
            }
            return null;
        }).orElse(null);
    }

    private static JsonObject parseJsonObject(String text) {
        try {
            return new JsonParser().parse(text).getAsJsonObject();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    static {
        try {
            EasyLookup.addOBCClass("entity.CraftPlayer");
            EasyLookup.addOBCClass("inventory.CraftMetaSkull");
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("world.item.component.ResolvableProfile");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        MethodHandle new$ResolvableProfile = null;
        MethodHandle get$profile = null;
        MethodHandle get$player_profile = null;
        MethodHandle get$meta_profile = null;
        MethodHandle set$meta_profile = null;
        MethodHandle get$value = null;
        MethodHandle get$signature = null;
        try {
            String gameProfile = "f";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                gameProfile = "gameProfile";
            }
            if (ServerInstance.Release.COMPONENT) {
                for (Method method : EasyLookup.classOf("CraftMetaSkull").getDeclaredMethods()) {
                    if (!method.getName().equals("setProfile") || method.getParameters().length != 1 || !method.getParameters()[0].getType().getSimpleName().equals("ResolvableProfile")) continue;
                    new$ResolvableProfile = EasyLookup.constructor("ResolvableProfile", GameProfile.class);
                    get$profile = EasyLookup.getter("ResolvableProfile", gameProfile, GameProfile.class);
                }
            }
            get$player_profile = EasyLookup.method("CraftPlayer", "getProfile", GameProfile.class, new Object[0]);
            get$meta_profile = EasyLookup.unreflectGetter("CraftMetaSkull", "profile");
            set$meta_profile = new$ResolvableProfile != null ? EasyLookup.unreflectMethod("CraftMetaSkull", "setProfile", "ResolvableProfile") : (ServerInstance.MAJOR_VERSION >= 15 ? EasyLookup.unreflectMethod("CraftMetaSkull", "setProfile", GameProfile.class) : EasyLookup.unreflectSetter("CraftMetaSkull", "profile"));
            String value = "value";
            for (Method method : Property.class.getDeclaredMethods()) {
                if (!method.getName().equals("getValue")) continue;
                value = "getValue";
                break;
            }
            get$value = EasyLookup.method(Property.class, value, String.class, new Object[0]);
            String signature = "signature";
            for (Method method : Property.class.getDeclaredMethods()) {
                if (!method.getName().equals("getSignature")) continue;
                signature = "getSignature";
                break;
            }
            get$signature = EasyLookup.method(Property.class, signature, String.class, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        NEW_PROFILE = new$ResolvableProfile;
        GET_PROFILE = get$profile;
        GET_PLAYER_PROFILE = get$player_profile;
        GET_META_PROFILE = get$meta_profile;
        SET_META_PROFILE = set$meta_profile;
        GET_VALUE = get$value;
        GET_SIGNATURE = get$signature;
        JSON_PARSER = new JsonParser();
        PLAYER_HEAD = () -> {
            if (ServerInstance.Release.FLAT) {
                return new ItemStack(Material.PLAYER_HEAD);
            }
            return new ItemStack(Material.getMaterial((String)"SKULL_ITEM"), 1, 3);
        };
    }

    @ApiStatus.Experimental
    public static class Mojang
    extends SkullTexture {
        private static final Mojang INSTANCE = new Mojang();
        private static final String USER_API = "https://api.mojang.com/users/profiles/minecraft/";
        private static final String SESSION_API = "https://sessionserver.mojang.com/session/minecraft/profile/";

        public Mojang() {
        }

        public Mojang(@Nullable Cache<String, Profile> cache) {
            super(cache);
        }

        public Mojang(@NotNull Executor executor) {
            super(executor);
        }

        public Mojang(@Nullable Cache<String, Profile> cache, @NotNull Executor executor) {
            super(cache, executor);
        }

        @Override
        @NotNull
        public Profile fetchProfile(@NotNull String name) {
            return this.fetchJson(USER_API + name).flatMap(user -> {
                JsonPrimitive id = user.getAsJsonPrimitive("id");
                if (id != null) {
                    return this.fetchJson(SESSION_API + id.getAsString()).map(session -> this.profileSession((JsonObject)session, "id", "name"));
                }
                return Optional.empty();
            }).orElse(Profile.empty());
        }

        @Override
        @NotNull
        public Profile fetchProfile(@NotNull UUID uniqueId) {
            return this.fetchJson(SESSION_API + uniqueId.toString().replace('-', '\u0000')).map(session -> this.profileSession((JsonObject)session, "id", "name")).orElse(Profile.empty());
        }
    }

    @ApiStatus.Experimental
    public static class PlayerDB
    extends SkullTexture {
        private static final PlayerDB INSTANCE = new PlayerDB();
        private static final String API = "https://playerdb.co/api/player/minecraft/";

        public PlayerDB() {
        }

        public PlayerDB(@Nullable Cache<String, Profile> cache) {
            super(cache);
        }

        public PlayerDB(@NotNull Executor executor) {
            super(executor);
        }

        public PlayerDB(@Nullable Cache<String, Profile> cache, @NotNull Executor executor) {
            super(cache, executor);
        }

        @Override
        @NotNull
        public Profile fetchProfile(@NotNull String name) {
            return this.fetchAny(name);
        }

        @Override
        @NotNull
        public Profile fetchProfile(@NotNull UUID uniqueId) {
            return this.fetchAny(uniqueId.toString());
        }

        @NotNull
        protected Profile fetchAny(@NotNull String any) {
            return this.fetchJson(API + any).map(json -> {
                JsonObject player;
                JsonObject data = json.getAsJsonObject("data");
                if (data != null && (player = data.getAsJsonObject("player")) != null) {
                    return this.profileSession(player, "raw_id", "username");
                }
                return null;
            }).orElse(Profile.empty());
        }
    }

    @ApiStatus.Experimental
    public static class CraftHead
    extends SkullTexture {
        private static final CraftHead INSTANCE = new CraftHead();
        private static final String API = "https://crafthead.net/profile/";

        public CraftHead() {
        }

        public CraftHead(@Nullable Cache<String, Profile> cache) {
            super(cache);
        }

        public CraftHead(@NotNull Executor executor) {
            super(executor);
        }

        public CraftHead(@Nullable Cache<String, Profile> cache, @NotNull Executor executor) {
            super(cache, executor);
        }

        @Override
        @NotNull
        public Profile fetchProfile(@NotNull String name) {
            return this.fetchJson(API + name).map(session -> this.profileSession((JsonObject)session, "id", "name")).orElse(Profile.empty());
        }

        @Override
        @NotNull
        public Profile fetchProfile(@NotNull UUID uniqueId) {
            return this.fetchJson(API + uniqueId).map(session -> this.profileSession((JsonObject)session, "id", "name")).orElse(Profile.empty());
        }
    }

    public static class Profile {
        private static final UUID EMPTY_ID = new UUID(0L, 0L);
        private static final Profile EMPTY = Profile.createProfile(EMPTY_ID, "null", null, null);
        private final GameProfile profile;

        @NotNull
        public static Profile empty() {
            return EMPTY;
        }

        @NotNull
        public static Profile valueOf(@Nullable String texture) {
            return Profile.valueOf(EMPTY_ID, "null", texture);
        }

        @NotNull
        public static Profile valueOf(@NotNull UUID uniqueId, @NotNull String name) {
            return Profile.valueOf(uniqueId, name, null, null);
        }

        @NotNull
        public static Profile valueOf(@NotNull UUID uniqueId, @NotNull String name, @Nullable String texture) {
            return Profile.valueOf(uniqueId, name, texture, null);
        }

        @NotNull
        public static Profile valueOf(@NotNull UUID uniqueId, @NotNull String name, @Nullable String texture, @Nullable String signature) {
            if (uniqueId.equals(EMPTY_ID) && name.equals("null") && texture == null) {
                return Profile.empty();
            }
            return Profile.createProfile(uniqueId, name, texture, signature);
        }

        @NotNull
        private static Profile createProfile(@NotNull UUID uniqueId, @NotNull String name, @Nullable String texture, @Nullable String signature) {
            GameProfile profile = new GameProfile(uniqueId, name);
            if (texture != null) {
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture, signature));
            }
            return new Profile(profile);
        }

        private Profile(@NotNull GameProfile profile) {
            this.profile = profile;
        }

        public boolean isJava() {
            return this.getUniqueId().version() == 4;
        }

        public boolean isOffline() {
            return this.getUniqueId().version() == 3;
        }

        public boolean isBedrock() {
            return this.getUniqueId().toString().startsWith("00000000-0000-0000-0009");
        }

        public boolean isValid() {
            return !this.getUniqueId().equals(EMPTY_ID);
        }

        public boolean isEmpty() {
            return this.profile.getProperties().isEmpty();
        }

        @NotNull
        private GameProfile getProfile() {
            return this.profile;
        }

        @NotNull
        public UUID getUniqueId() {
            return this.profile.getId();
        }

        @NotNull
        public String getName() {
            return this.profile.getName();
        }

        @NotNull
        public Optional<String> getTexture() {
            for (Property texture : this.profile.getProperties().get((Object)"textures")) {
                if (texture == null) continue;
                try {
                    return Optional.ofNullable(GET_VALUE.invoke(texture));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Cannot get texture value from Property object");
                }
            }
            return Optional.empty();
        }

        @NotNull
        public Optional<JsonObject> getTextureJson() {
            return this.getTexture().map(base64 -> {
                String value;
                try {
                    value = new String(Base64.getDecoder().decode((String)base64));
                }
                catch (IllegalArgumentException e) {
                    value = base64;
                }
                return JSON_PARSER.parse(value).getAsJsonObject();
            });
        }

        @NotNull
        public Optional<String> getSignature() {
            for (Property texture : this.profile.getProperties().get((Object)"textures")) {
                if (texture == null) continue;
                try {
                    return Optional.ofNullable(GET_SIGNATURE.invoke(texture));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Cannot get texture signature from Property object");
                }
            }
            return Optional.empty();
        }

        @NotNull
        public Optional<URL> getSkinUrl() {
            return this.getTextureJson().map(json -> {
                JsonPrimitive url;
                JsonObject skin;
                JsonObject textures = json.getAsJsonObject("textures");
                if (textures != null && (skin = textures.getAsJsonObject("SKIN")) != null && (url = skin.getAsJsonPrimitive("url")) != null) {
                    try {
                        return new URL(url.getAsString());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            });
        }

        @NotNull
        public Optional<URL> getCapeUrl() {
            return this.getTextureJson().map(json -> {
                JsonPrimitive url;
                JsonObject skin;
                JsonObject textures = json.getAsJsonObject("textures");
                if (textures != null && (skin = textures.getAsJsonObject("CAPE")) != null && (url = skin.getAsJsonPrimitive("url")) != null) {
                    try {
                        return new URL(url.getAsString());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            });
        }
    }
}

