/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.deepslateinstamine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.nicguzzo.deepslateinstamine.DeepslateInstamineExpectPlatform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static Config INSTANCE = null;
    public boolean enable_renewable_deepslate = true;
    public int renewable_deepslate_below_level = 11;
    public boolean enable_logs_instamine = true;
    public float speed_factor = 1000.0f;
    public String[] pickaxe_instamine_blocks = new String[]{"minecraft:deepslate", "minecraft:cobblestone", "minecraft:end_stone"};
    public String[] pickaxes_that_can_instamine = new String[]{"minecraft:netherite_pickaxe"};
    public String[] axes_that_can_instamine = new String[]{"minecraft:netherite_axe"};
    public String[] axe_instamine_blocks = new String[0];
    public static List<Block> pickaxe_instamine_blk = new ArrayList<Block>();
    public static List<Block> axe_instamine_blk = new ArrayList<Block>();
    public static List<Item> pickaxes_item = new ArrayList<Item>();
    public static List<Item> axes_item = new ArrayList<Item>();
    public static final Logger LOGGER = LogManager.getLogger((String)"deepslateinstamine");

    public static void load_config() {
        FileWriter writer;
        INSTANCE = new Config();
        Gson gson = new Gson();
        File configFile = new File(DeepslateInstamineExpectPlatform.getConfigDirectory().toString(), "deepslate_instamine.json");
        try (FileReader reader = new FileReader(configFile);){
            INSTANCE = (Config)gson.fromJson((Reader)reader, Config.class);
            LOGGER.info("Config: " + String.valueOf(INSTANCE));
            try {
                writer = new FileWriter(configFile);
                try {
                    writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
                    LOGGER.info("Config updated!");
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e2) {
                LOGGER.error("Failed to update config file!");
            }
            LOGGER.info("Config loaded!");
        }
        catch (IOException e) {
            LOGGER.info("No config found, generating!");
            INSTANCE = new Config();
            try {
                writer = new FileWriter(configFile);
                try {
                    writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e2) {
                LOGGER.error("Failed to generate config file!");
            }
        }
        if (INSTANCE != null) {
            Block blk;
            Item item;
            ResourceLocation res;
            for (String id : Config.INSTANCE.pickaxe_instamine_blocks) {
                LOGGER.info("trying: " + id);
                res = ResourceLocation.tryParse((String)id);
                if (res != null) {
                    item = Config.get_from_reg(res);
                    if (item != null && item != Items.AIR) {
                        blk = Block.byItem((Item)item);
                        if (blk != null) {
                            pickaxe_instamine_blk.add(blk);
                            LOGGER.info("Instamine block: " + String.valueOf(blk));
                            continue;
                        }
                        LOGGER.info("This item: " + String.valueOf(item) + " can't be instamined, not a Block");
                        continue;
                    }
                    LOGGER.info("item not found: " + id);
                    continue;
                }
                LOGGER.info("resource not found: " + id);
            }
            for (String id : Config.INSTANCE.pickaxes_that_can_instamine) {
                LOGGER.info("trying: " + id);
                res = ResourceLocation.tryParse((String)id);
                if (res != null) {
                    item = Config.get_from_reg(res);
                    if (item != null && item != Items.AIR) {
                        if (item.getDefaultInstance().getComponents().has(DataComponents.TOOL)) {
                            pickaxes_item.add(item);
                            LOGGER.info("Instamine pickaxe: " + String.valueOf(item));
                            continue;
                        }
                        LOGGER.info("This item: " + String.valueOf(item) + " can't be used to instamine, not a DiggerItem");
                        continue;
                    }
                    LOGGER.info("item not found: " + id);
                    continue;
                }
                LOGGER.info("resource not found: " + id);
            }
            for (String id : Config.INSTANCE.axe_instamine_blocks) {
                LOGGER.info("trying: " + id);
                res = ResourceLocation.tryParse((String)id);
                if (res != null) {
                    item = Config.get_from_reg(res);
                    if (item != null && item != Items.AIR) {
                        blk = Block.byItem((Item)item);
                        if (blk != null) {
                            axe_instamine_blk.add(blk);
                            LOGGER.info("Instamine block: " + String.valueOf(blk));
                            continue;
                        }
                        LOGGER.info("This item: " + String.valueOf(item) + " can't be instamined, not a Block");
                        continue;
                    }
                    LOGGER.info("item not found: " + id);
                    continue;
                }
                LOGGER.info("resource not found: " + id);
            }
            for (String id : Config.INSTANCE.axes_that_can_instamine) {
                LOGGER.info("trying: " + id);
                res = ResourceLocation.tryParse((String)id);
                if (res != null) {
                    item = Config.get_from_reg(res);
                    if (item != null && item != Items.AIR) {
                        if (item.getDefaultInstance().getComponents().has(DataComponents.TOOL)) {
                            axes_item.add(item);
                            LOGGER.info("Instamine axe: " + String.valueOf(item));
                            continue;
                        }
                        LOGGER.info("This item: " + String.valueOf(item) + " can't be used to instamine, not a DiggerItem");
                        continue;
                    }
                    LOGGER.info("item not found: " + id);
                    continue;
                }
                LOGGER.info("resource not found: " + id);
            }
        }
    }

    public static Config get_instance() {
        if (INSTANCE == null) {
            Config.load_config();
        }
        return INSTANCE;
    }

    static Item get_from_reg(ResourceLocation res) {
        return BuiltInRegistries.ITEM.get(res).map(Holder.Reference::value).orElse(null);
    }
}

