/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobblemon_iwa.common.gui.reorder;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.ExitButton;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelGUI;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.cobblemon.mod.common.client.gui.interact.wheel.Orientation;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.starliteheart.cobblemon_iwa.common.gui.reorder.widgets.OptionsWidget;
import net.starliteheart.cobblemon_iwa.common.util.IWAUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB+\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ/\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010&\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b)\u0010*J\u001b\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001b\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0-H\u0002\u00a2\u0006\u0004\b.\u0010/J\u0015\u00102\u001a\u00020\u000f2\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b2\u00103J\u000f\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b7\u0010\u001dR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00108R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00109R\u001c\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\"\u0010=\u001a\u00020<8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lnet/starliteheart/cobblemon_iwa/common/gui/reorder/ReorderOptions;", "Lnet/minecraft/client/gui/screens/Screen;", "Lnet/minecraft/client/gui/components/Renderable;", "Lcom/google/common/collect/Multimap;", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/Orientation;", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelOption;", "options", "", "interactKey", "Lnet/minecraft/network/chat/Component;", "title", "<init>", "(Lcom/google/common/collect/Multimap;Ljava/lang/String;Lnet/minecraft/network/chat/Component;)V", "", "delta", "", "renderBlurredBackground", "(F)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "renderMenuBackground", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "translateMultimapToArray", "(Lcom/google/common/collect/Multimap;)V", "", "array", "translateArrayToMultimap", "([Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelOption;)Lcom/google/common/collect/Multimap;", "init", "()V", "displayOptionsGrid", "", "mouseX", "mouseY", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "sourceIndex", "targetIndex", "swapOptionSlot", "(II)V", "columnIndex", "shakedownColumn", "(I)V", "saveOptions", "()Lcom/google/common/collect/Multimap;", "Lkotlin/Pair;", "getBasePosition", "()Lkotlin/Pair;", "Lnet/minecraft/sounds/SoundEvent;", "soundEvent", "playSound", "(Lnet/minecraft/sounds/SoundEvent;)V", "", "isPauseScreen", "()Z", "onClose", "Lcom/google/common/collect/Multimap;", "Ljava/lang/String;", "optionsArray", "[Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelOption;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "optionsGrid", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "getOptionsGrid", "()Lnet/minecraft/client/gui/components/events/GuiEventListener;", "setOptionsGrid", "(Lnet/minecraft/client/gui/components/events/GuiEventListener;)V", "Companion", "cobblemon_iwa-common"})
@SourceDebugExtension(value={"SMAP\nReorderOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReorderOptions.kt\nnet/starliteheart/cobblemon_iwa/common/gui/reorder/ReorderOptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,240:1\n1878#2,2:241\n1878#2,3:243\n1880#2:246\n1761#2,3:252\n1761#2,3:256\n13870#3,3:247\n13870#3,2:250\n13872#3:255\n*S KotlinDebug\n*F\n+ 1 ReorderOptions.kt\nnet/starliteheart/cobblemon_iwa/common/gui/reorder/ReorderOptions\n*L\n54#1:241,2\n55#1:243,3\n54#1:246\n139#1:252,3\n155#1:256,3\n65#1:247,3\n134#1:250,2\n134#1:255\n*E\n"})
public final class ReorderOptions
extends Screen
implements Renderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Multimap<Orientation, InteractWheelOption> options;
    @NotNull
    private final String interactKey;
    @NotNull
    private final InteractWheelOption[] optionsArray;
    public GuiEventListener optionsGrid;
    private static final int BASE_WIDTH = 273;
    private static final int BASE_HEIGHT = 164;
    @NotNull
    private static final ResourceLocation backgroundResource = IWAUtilsKt.iwaResource("textures/gui/reorder/reorder_menu_base.png");
    @NotNull
    private static final String[] headings;
    private static final int MAX_PAGES = 4;

    public ReorderOptions(@NotNull Multimap<Orientation, InteractWheelOption> options, @NotNull String interactKey, @NotNull Component title) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)interactKey, (String)"interactKey");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(title);
        this.options = options;
        this.interactKey = interactKey;
        this.optionsArray = new InteractWheelOption[32];
    }

    protected void renderBlurredBackground(float delta) {
    }

    protected void renderMenuBackground(@NotNull GuiGraphics context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @NotNull
    public final GuiEventListener getOptionsGrid() {
        GuiEventListener guiEventListener = this.optionsGrid;
        if (guiEventListener != null) {
            return guiEventListener;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"optionsGrid");
        return null;
    }

    public final void setOptionsGrid(@NotNull GuiEventListener guiEventListener) {
        Intrinsics.checkNotNullParameter((Object)guiEventListener, (String)"<set-?>");
        this.optionsGrid = guiEventListener;
    }

    /*
     * WARNING - void declaration
     */
    private final void translateMultimapToArray(Multimap<Orientation, InteractWheelOption> options) {
        Iterable $this$forEachIndexed$iv = (Iterable)Orientation.getEntries();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void orientation;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Orientation orientation2 = (Orientation)item$iv;
            int offset = n;
            boolean bl = false;
            Collection collection = options.get((Object)orientation);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Iterable $this$forEachIndexed$iv2 = collection;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void option;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                InteractWheelOption interactWheelOption = (InteractWheelOption)item$iv2;
                int index = n2;
                boolean bl2 = false;
                if (this.optionsArray.length <= offset + index * 8) {
                    throw new InvalidParameterException("Too many InteractWheelOptions in one orientation column");
                }
                this.optionsArray[offset + index * 8] = option;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Multimap<Orientation, InteractWheelOption> translateArrayToMultimap(InteractWheelOption[] array) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
        Multimap options = (Multimap)arrayListMultimap;
        InteractWheelOption[] $this$forEachIndexed$iv = array;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (InteractWheelOption item$iv : $this$forEachIndexed$iv) {
            void option;
            int n = index$iv++;
            InteractWheelOption interactWheelOption = item$iv;
            int index = n;
            boolean bl = false;
            if (option == null) continue;
            options.put(Orientation.getEntries().get(index % 8), (Object)option);
        }
        return options;
    }

    protected void init() {
        this.translateMultimapToArray(this.options);
        Pair<Integer, Integer> pair = this.getBasePosition();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        this.displayOptionsGrid();
        this.addRenderableWidget((GuiEventListener)new ExitButton(x + 244, y + 148, arg_0 -> ReorderOptions.init$lambda$0(this, arg_0)));
    }

    private final void displayOptionsGrid() {
        if (this.optionsGrid != null) {
            this.removeWidget(this.getOptionsGrid());
        }
        Pair<Integer, Integer> pair = this.getBasePosition();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        this.setOptionsGrid((GuiEventListener)new OptionsWidget(x + 13, y + 19, this, this.optionsArray));
        GuiEventListener element = this.getOptionsGrid();
        if (element instanceof Renderable && element instanceof NarratableEntry) {
            this.addRenderableWidget(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pair<Integer, Integer> pair = this.getBasePosition();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        PoseStack matrices = context.pose();
        Intrinsics.checkNotNull((Object)matrices);
        PoseStack poseStack = matrices;
        ResourceLocation resourceLocation = backgroundResource;
        GuiUtilsKt.blitk$default((PoseStack)poseStack, (ResourceLocation)resourceLocation, (Number)x, (Number)y, (Number)164, (Number)273, null, null, null, null, null, null, null, null, null, (boolean)false, (float)0.0f, (int)131008, null);
        ResourceLocation resourceLocation2 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
        MutableComponent mutableComponent = Component.translatable((String)"cobblemon_iwa.ui.reorder.title");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        RenderHelperKt.drawScaledText$default((GuiGraphics)context, (ResourceLocation)resourceLocation2, (MutableComponent)TextKt.bold((MutableComponent)mutableComponent), (Number)Float.valueOf((float)x + 7.0f), (Number)Float.valueOf((float)y + 2.5f), (float)0.0f, null, (int)0, (int)0, (boolean)false, (boolean)true, null, null, (int)7136, null);
        String[] $this$forEachIndexed$iv = headings;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (String item$iv : $this$forEachIndexed$iv) {
            boolean bl;
            MutableComponent mutableComponent2;
            ResourceLocation resourceLocation3;
            int index;
            block8: {
                void heading;
                int n = index$iv++;
                object = item$iv;
                index = n;
                boolean bl2 = false;
                resourceLocation3 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
                MutableComponent mutableComponent3 = Component.literal((String)heading);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"literal(...)");
                mutableComponent2 = TextKt.bold((MutableComponent)mutableComponent3);
                Iterable $this$any$iv = (Iterable)new IntRange(1, 4);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int page = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl3 = false;
                        if (!new ScreenRectangle(x + 17 + index * 32, y - 9 + page * 31, 27, 27).containsPoint(mouseX, mouseY)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            int n = bl ? 0xFFFF00 : 0xFFFFFF;
            float f = (float)x + 31.5f + (float)index * 32.0f;
            float f2 = (float)y + 13.5f;
            RenderHelperKt.drawScaledText$default((GuiGraphics)context, (ResourceLocation)resourceLocation3, (MutableComponent)mutableComponent2, (Number)Float.valueOf(f), (Number)Float.valueOf(f2), (float)0.0f, null, (int)0, (int)n, (boolean)true, (boolean)true, null, null, (int)6368, null);
        }
        for (int page = 1; page < 5; ++page) {
            boolean bl;
            MutableComponent mutableComponent4;
            ResourceLocation resourceLocation4;
            block9: {
                resourceLocation4 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
                MutableComponent mutableComponent5 = Component.literal((String)String.valueOf(page));
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"literal(...)");
                mutableComponent4 = TextKt.bold((MutableComponent)mutableComponent5);
                Iterable $this$any$iv = (Iterable)ArraysKt.getIndices((Object[])headings);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    object = $this$any$iv.iterator();
                    while (object.hasNext()) {
                        int element$iv;
                        int index = element$iv = ((IntIterator)object).nextInt();
                        boolean bl4 = false;
                        if (!new ScreenRectangle(x + 17 + index * 32, y - 9 + page * 31, 27, 27).containsPoint(mouseX, mouseY)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            int n = bl ? 0xFFFF00 : 0xFFFFFF;
            float f = (float)x + 10.5f;
            float f3 = (float)y + 0.5f + (float)page * 31.0f;
            RenderHelperKt.drawScaledText$default((GuiGraphics)context, (ResourceLocation)resourceLocation4, (MutableComponent)mutableComponent4, (Number)Float.valueOf(f), (Number)Float.valueOf(f3), (float)0.0f, null, (int)0, (int)n, (boolean)true, (boolean)true, null, null, (int)6368, null);
        }
        super.render(context, mouseX, mouseY, delta);
    }

    public final void swapOptionSlot(int sourceIndex, int targetIndex) {
        if (sourceIndex >= this.optionsArray.length || targetIndex >= this.optionsArray.length) {
            return;
        }
        InteractWheelOption sourceOption = (InteractWheelOption)ArraysKt.getOrNull((Object[])this.optionsArray, (int)sourceIndex);
        if (sourceOption != null) {
            InteractWheelOption targetOption = (InteractWheelOption)ArraysKt.getOrNull((Object[])this.optionsArray, (int)targetIndex);
            this.optionsArray[targetIndex] = sourceOption;
            this.optionsArray[sourceIndex] = targetOption;
            int sourceColumnIndex = sourceIndex % 8;
            int targetColumnIndex = targetIndex % 8;
            this.shakedownColumn(sourceColumnIndex);
            if (sourceColumnIndex != targetColumnIndex) {
                this.shakedownColumn(targetColumnIndex);
            }
            this.displayOptionsGrid();
        }
    }

    private final void shakedownColumn(int columnIndex) {
        block0: for (int i = 0; i < 3; ++i) {
            int sourceIndex = i * 8 + columnIndex;
            InteractWheelOption sourceOption = (InteractWheelOption)ArraysKt.getOrNull((Object[])this.optionsArray, (int)sourceIndex);
            if (sourceOption != null) continue;
            for (int j = i + 1; j < 4; ++j) {
                int targetIndex = j * 8 + columnIndex;
                InteractWheelOption targetOption = (InteractWheelOption)ArraysKt.getOrNull((Object[])this.optionsArray, (int)targetIndex);
                if (targetOption == null) continue;
                this.optionsArray[targetIndex] = sourceOption;
                this.optionsArray[sourceIndex] = targetOption;
                continue block0;
            }
        }
    }

    private final Multimap<Orientation, InteractWheelOption> saveOptions() {
        Multimap<Orientation, InteractWheelOption> newOptions = this.translateArrayToMultimap(this.optionsArray);
        IWAUtilsKt.saveOptionsToConfig(this.interactKey, newOptions);
        return newOptions;
    }

    private final Pair<Integer, Integer> getBasePosition() {
        return new Pair((Object)((this.width - 273) / 2), (Object)((this.height - 164) / 2));
    }

    public final void playSound(@NotNull SoundEvent soundEvent) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"soundEvent");
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)1.0f));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.saveOptions();
        super.onClose();
    }

    private static final void init$lambda$0(ReorderOptions this$0, Button it) {
        this$0.playSound(CobblemonSounds.GUI_CLICK);
        Minecraft minecraft = Minecraft.getInstance();
        Multimap<Orientation, InteractWheelOption> multimap = this$0.saveOptions();
        MutableComponent mutableComponent = Component.translatable((String)this$0.interactKey);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        minecraft.setScreen((Screen)new InteractWheelGUI(multimap, (Component)mutableComponent));
    }

    static {
        String[] stringArray = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
        headings = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/starliteheart/cobblemon_iwa/common/gui/reorder/ReorderOptions$Companion;", "", "<init>", "()V", "", "BASE_WIDTH", "I", "BASE_HEIGHT", "Lnet/minecraft/resources/ResourceLocation;", "backgroundResource", "Lnet/minecraft/resources/ResourceLocation;", "", "", "headings", "[Ljava/lang/String;", "MAX_PAGES", "cobblemon_iwa-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

