/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobblemon_iwa.common.util;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.ExitButton;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.cobblemon.mod.common.client.gui.interact.wheel.Orientation;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.starliteheart.cobblemon_iwa.common.CobblemonIWA;
import net.starliteheart.cobblemon_iwa.common.config.IWAConfig;
import net.starliteheart.cobblemon_iwa.common.gui.ReorderButton;
import net.starliteheart.cobblemon_iwa.common.gui.reorder.ReorderOptions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\n\u001a;\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a#\u0010\u0014\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a)\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a)\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a=\u0010\u001f\u001a\u00020\u001e2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010 \u001a!\u0010\"\u001a\u00020!2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b\"\u0010#\u001a)\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020$2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006("}, d2={"", "path", "Lnet/minecraft/resources/ResourceLocation;", "iwaResource", "(Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "Lnet/starliteheart/cobblemon_iwa/common/config/IWAConfig;", "getConfig", "()Lnet/starliteheart/cobblemon_iwa/common/config/IWAConfig;", "", "saveConfig", "()V", "Lcom/google/common/collect/Multimap;", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/Orientation;", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelOption;", "options", "", "Lnet/starliteheart/cobblemon_iwa/common/config/IWAConfig$OrderedOption;", "ordering", "reorderOptions", "(Lcom/google/common/collect/Multimap;Ljava/util/List;)Lcom/google/common/collect/Multimap;", "getNextFreeOrientation", "(Lcom/google/common/collect/Multimap;)Lcom/cobblemon/mod/common/client/gui/interact/wheel/Orientation;", "translateToOrderedOptions", "(Lcom/google/common/collect/Multimap;)Ljava/util/List;", "interactKey", "saveOptionsToConfig", "(Ljava/lang/String;Lcom/google/common/collect/Multimap;)V", "Lkotlin/Pair;", "", "pos", "Lnet/starliteheart/cobblemon_iwa/common/gui/ReorderButton;", "createReorderButton", "(Lkotlin/Pair;Lcom/google/common/collect/Multimap;Ljava/lang/String;)Lnet/starliteheart/cobblemon_iwa/common/gui/ReorderButton;", "Lcom/cobblemon/mod/common/client/gui/ExitButton;", "createExitButton", "(Lkotlin/Pair;)Lcom/cobblemon/mod/common/client/gui/ExitButton;", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "renderBaseAddon", "(Lnet/minecraft/client/gui/GuiGraphics;Lkotlin/Pair;)V", "cobblemon_iwa-common"})
@SourceDebugExtension(value={"SMAP\nIWAUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IWAUtils.kt\nnet/starliteheart/cobblemon_iwa/common/util/IWAUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1#2:142\n1563#3:143\n1634#3,3:144\n*S KotlinDebug\n*F\n+ 1 IWAUtils.kt\nnet/starliteheart/cobblemon_iwa/common/util/IWAUtilsKt\n*L\n74#1:143\n74#1:144,3\n*E\n"})
public final class IWAUtilsKt {
    @NotNull
    public static final ResourceLocation iwaResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon_iwa", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public static final IWAConfig getConfig() {
        ConfigData configData = AutoConfig.getConfigHolder(IWAConfig.class).get();
        Intrinsics.checkNotNullExpressionValue((Object)configData, (String)"get(...)");
        return (IWAConfig)configData;
    }

    public static final void saveConfig() {
        AutoConfig.getConfigHolder(IWAConfig.class).save();
    }

    @NotNull
    public static final Multimap<Orientation, InteractWheelOption> reorderOptions(@NotNull Multimap<Orientation, InteractWheelOption> options, @NotNull List<IWAConfig.OrderedOption> ordering) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(ordering, (String)"ordering");
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
        Multimap ordered = (Multimap)arrayListMultimap;
        IWAConfig config = IWAUtilsKt.getConfig();
        for (IWAConfig.OrderedOption object : ordering) {
            Map.Entry option;
            Object v2;
            Object object2;
            Orientation orientation;
            block8: {
                String resource = object.component1();
                orientation = object.component2();
                ResourceLocation location = ResourceLocation.parse((String)resource);
                Collection collection = options.entries();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"entries(...)");
                object2 = collection;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Map.Entry entry = (Map.Entry)t;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    InteractWheelOption value = (InteractWheelOption)entry.getValue();
                    if (!Intrinsics.areEqual((Object)value.getIconResource(), (Object)location)) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            Map.Entry entry = option = (Map.Entry)v2;
            if (entry == null) continue;
            object2 = entry;
            boolean bl = false;
            Orientation key = (Orientation)object2.getKey();
            InteractWheelOption value = (InteractWheelOption)object2.getValue();
            ordered.put((Object)orientation, (Object)value);
            options.remove((Object)key, (Object)value);
        }
        if (!options.isEmpty()) {
            boolean bl = config.getAutofillUnlisted();
            if (!bl) {
                ordered.putAll(options);
            } else if (bl) {
                for (Map.Entry entry : options.entries()) {
                    Intrinsics.checkNotNull((Object)entry);
                    InteractWheelOption value = (InteractWheelOption)entry.getValue();
                    ordered.put((Object)IWAUtilsKt.getNextFreeOrientation((Multimap<Orientation, InteractWheelOption>)ordered), (Object)value);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ordered;
    }

    private static final Orientation getNextFreeOrientation(Multimap<Orientation, InteractWheelOption> options) {
        Orientation largest = Orientation.NORTH;
        for (Orientation orientation : Orientation.getEntries()) {
            if (!options.containsKey((Object)orientation)) {
                return orientation;
            }
            if (options.get((Object)orientation).size() >= options.get((Object)largest).size()) continue;
            largest = orientation;
        }
        return largest;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IWAConfig.OrderedOption> translateToOrderedOptions(Multimap<Orientation, InteractWheelOption> options) {
        void $this$mapTo$iv$iv;
        Collection collection = options.entries();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"entries(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Orientation orientation = (Orientation)entry.getKey();
            InteractWheelOption option = (InteractWheelOption)entry.getValue();
            String string = option.getIconResource().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Intrinsics.checkNotNull((Object)orientation);
            collection2.add(new IWAConfig.OrderedOption(string, orientation));
        }
        return (List)destination$iv$iv;
    }

    public static final void saveOptionsToConfig(@NotNull String interactKey, @NotNull Multimap<Orientation, InteractWheelOption> options) {
        Intrinsics.checkNotNullParameter((Object)interactKey, (String)"interactKey");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        List<IWAConfig.OrderedOption> orderedOptions = IWAUtilsKt.translateToOrderedOptions(options);
        IWAConfig config = IWAUtilsKt.getConfig();
        String string = interactKey;
        if (Intrinsics.areEqual((Object)string, (Object)"cobblemon.ui.interact.pokemon")) {
            config.setPokemonOrderedOptions(orderedOptions);
        } else if (Intrinsics.areEqual((Object)string, (Object)"cobblemon.ui.interact.player")) {
            config.setPlayerOrderedOptions(orderedOptions);
        } else {
            CobblemonIWA.INSTANCE.getLOGGER().warn("Unknown interact key found when saving to config. Aborting config save.");
            return;
        }
        IWAUtilsKt.saveConfig();
    }

    @NotNull
    public static final ReorderButton createReorderButton(@NotNull Pair<Integer, Integer> pos, @NotNull Multimap<Orientation, InteractWheelOption> options, @NotNull String interactKey) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)interactKey, (String)"interactKey");
        return new ReorderButton(((Number)pos.getFirst()).intValue() + 28, ((Number)pos.getSecond()).intValue() + 162, arg_0 -> IWAUtilsKt.createReorderButton$lambda$0(options, interactKey, arg_0));
    }

    @NotNull
    public static final ExitButton createExitButton(@NotNull Pair<Integer, Integer> pos) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        return new ExitButton(((Number)pos.getFirst()).intValue() + 116, ((Number)pos.getSecond()).intValue() + 162, IWAUtilsKt::createExitButton$lambda$0);
    }

    public static final void renderBaseAddon(@NotNull GuiGraphics context, @NotNull Pair<Integer, Integer> pos) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        PoseStack poseStack2 = poseStack;
        ResourceLocation resourceLocation = IWAUtilsKt.iwaResource("textures/gui/interact/interact_wheel_base_addon.png");
        int n = ((Number)pos.getFirst()).intValue() + 25;
        int n2 = ((Number)pos.getSecond()).intValue() + 146;
        GuiUtilsKt.blitk$default((PoseStack)poseStack2, (ResourceLocation)resourceLocation, (Number)n, (Number)n2, (Number)32, (Number)120, null, null, null, null, null, null, null, null, null, (boolean)false, (float)0.0f, (int)131008, null);
    }

    private static final void createReorderButton$lambda$0(Multimap $options, String $interactKey, Button it) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CobblemonSounds.GUI_CLICK, (float)1.0f));
        Minecraft minecraft = Minecraft.getInstance();
        MutableComponent mutableComponent = Component.translatable((String)"cobblemon_iwa.ui.reorder");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        minecraft.setScreen((Screen)new ReorderOptions((Multimap<Orientation, InteractWheelOption>)$options, $interactKey, (Component)mutableComponent));
    }

    private static final void createExitButton$lambda$0(Button it) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CobblemonSounds.GUI_CLICK, (float)1.0f));
        Minecraft.getInstance().setScreen(null);
    }
}

