/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.compile.ebc.efi;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.compile.ebc.efi.EFIBootServicesTable;
import org.bread_experts_group.api.compile.ebc.efi.EFIMemoryType;
import org.bread_experts_group.api.compile.ebc.efi.EFISystemTable;
import org.bread_experts_group.api.compile.ebc.efi.protocol.EFIFileProtocol;
import org.bread_experts_group.api.compile.ebc.efi.protocol.EFISimpleTextOutputProtocol;
import org.bread_experts_group.api.compile.ebc.efi.protocol.EFITime;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007b\u0002\b\u000bJ$\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007b\u0002\b\u000bJs\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0007b\u0002\b\u000b\u00a2\u0006\u0004\b\u001e\u0010\u001fJs\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0007b\u0002\b\u000b\u00a2\u0006\u0004\b!\u0010\"J\u0014\u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007b\u0002\b\u000bJ\u0014\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007b\u0002\b\u000bJ\u0014\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000fH\u0007b\u0002\b\u000bJ\u0014\u0010'\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000fH\u0007b\u0002\b\u000bJ\u0014\u0010(\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000fH\u0007b\u0002\b\u000bJ,\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007b\u0002\b\u000bJ,\u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007b\u0002\b\u000bJ\u001c\u0010-\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/H\u0007b\u0002\b\u000bJ\u0014\u00100\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000fH\u0007b\u0002\b\u000bJ\u001c\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007b\u0002\b\u000b\u00a8\u00063"}, d2={"Lorg/bread_experts_group/api/compile/ebc/efi/EFIExample;", "", "<init>", "()V", "printHex", "", "systemTable", "Lorg/bread_experts_group/api/compile/ebc/efi/EFISystemTable;", "l", "pad", "", "Lkotlin/jvm/JvmStatic;", "printDecimal", "populateGUID", "into", "Ljava/lang/foreign/MemorySegment;", "i0", "Lkotlin/UInt;", "s0", "Lkotlin/UShort;", "s1", "b0", "Lkotlin/UByte;", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "populateGUID-X7LrNfc", "(Ljava/lang/foreign/MemorySegment;ISSBBBBBBBB)J", "testGUID", "testGUID-X7LrNfc", "(Lorg/bread_experts_group/api/compile/ebc/efi/EFISystemTable;ISSBBBBBBBB)J", "testMedia", "testConsole", "flash_EFI_SIMPLE_FILE_SYSTEM_PROTOCOL_GUID", "guid", "flash_EFI_FILE_SYSTEM_INFO", "flash_EFI_FILE_INFO", "readFileSystemInfo", "from", "Lorg/bread_experts_group/api/compile/ebc/efi/protocol/EFIFileProtocol;", "readFileInfo", "printTime", "time", "Lorg/bread_experts_group/api/compile/ebc/efi/protocol/EFITime;", "flash_EFI_GRAPHICS_OUTPUT_PROTOCOL_GUID", "efiMain", "imageHandle", "bread_server_lib"})
public final class EFIExample {
    @NotNull
    public static final EFIExample INSTANCE = new EFIExample();

    private EFIExample() {
    }

    @JvmStatic
    public static final long printHex(@NotNull EFISystemTable systemTable, long l, int pad) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        MemorySegment string = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, 34L).getData();
        long offset = 32L;
        long remainder = l;
        do {
            short s;
            offset -= (long)2;
            if (remainder > 0L) {
                long nibble = remainder & 0xFL;
                remainder >>>= 4;
                s = (short)((long)(nibble > 9L ? 55 : 48) + nibble);
            } else {
                s = 48;
            }
            short character = s;
            string.set(ValueLayout.JAVA_SHORT, offset, character);
        } while (remainder > 0L);
        string.set(ValueLayout.JAVA_SHORT, 32L, (short)0);
        EFISimpleTextOutputProtocol eFISimpleTextOutputProtocol = systemTable.getConOut();
        MemorySegment memorySegment = string.asSlice(offset);
        Intrinsics.checkNotNullExpressionValue(memorySegment, "asSlice(...)");
        eFISimpleTextOutputProtocol.outputStringAt(memorySegment);
        return 0L;
    }

    @JvmStatic
    public static final long printDecimal(@NotNull EFISystemTable systemTable, long l, int pad) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        MemorySegment string = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, 42L).getData();
        long offset = 40L;
        long remainder = l;
        int alpha = pad;
        do {
            short s;
            --alpha;
            offset -= (long)2;
            if (remainder > 0L) {
                long nibble = remainder % (long)10;
                remainder /= (long)10;
                s = (short)((long)48 + nibble);
            } else {
                s = 48;
            }
            short character = s;
            string.set(ValueLayout.JAVA_SHORT, offset, character);
        } while (remainder > 0L || alpha > 0);
        string.set(ValueLayout.JAVA_SHORT, 40L, (short)0);
        EFISimpleTextOutputProtocol eFISimpleTextOutputProtocol = systemTable.getConOut();
        MemorySegment memorySegment = string.asSlice(offset);
        Intrinsics.checkNotNullExpressionValue(memorySegment, "asSlice(...)");
        eFISimpleTextOutputProtocol.outputStringAt(memorySegment);
        return 0L;
    }

    @JvmStatic
    public static final long populateGUID-X7LrNfc(@NotNull MemorySegment into, int n, short s, short s2, byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        Intrinsics.checkNotNullParameter(into, "into");
        into.set(ValueLayout.JAVA_INT, 0L, n);
        into.set(ValueLayout.JAVA_SHORT, 4L, s);
        into.set(ValueLayout.JAVA_SHORT, 6L, s2);
        into.set(ValueLayout.JAVA_BYTE, 8L, by);
        into.set(ValueLayout.JAVA_BYTE, 9L, by2);
        into.set(ValueLayout.JAVA_BYTE, 10L, by3);
        into.set(ValueLayout.JAVA_BYTE, 11L, by4);
        into.set(ValueLayout.JAVA_BYTE, 12L, by5);
        into.set(ValueLayout.JAVA_BYTE, 13L, by6);
        into.set(ValueLayout.JAVA_BYTE, 14L, by7);
        into.set(ValueLayout.JAVA_BYTE, 15L, by8);
        return 0L;
    }

    @JvmStatic
    public static final long testGUID-X7LrNfc(@NotNull EFISystemTable systemTable, int n, short s, short s2, byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        MemorySegment guid = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, 16L).getData();
        EFIExample.populateGUID-X7LrNfc(guid, n, s, s2, by, by2, by3, by4, by5, by6, by7, by8);
        EFIBootServicesTable eFIBootServicesTable = systemTable.getBootServices();
        MemorySegment memorySegment = MemorySegment.NULL;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
        return eFIBootServicesTable.locateProtocol(guid, memorySegment).getStatus();
    }

    @JvmStatic
    public static final long testMedia(@NotNull EFISystemTable systemTable) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        systemTable.getConOut().outputString("EFI_LOAD_FILE_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 1458319505, (short)-27316, (short)4562, (byte)-114, (byte)63, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_LOAD_FILE2_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 1074184385, (short)-845, (short)16446, (byte)-103, (byte)109, (byte)74, (byte)108, (byte)-121, (byte)36, (byte)-32, (byte)109) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_SIMPLE_FILE_SYSTEM_PROTOCOL / EFI_FILE_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1773249758, (short)25689, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_TAPE_IO_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 513009203, (short)-10662, (short)17822, (byte)-85, (byte)-124, (byte)-109, (byte)-39, (byte)-20, (byte)38, (byte)109, (byte)24) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_DISK_IO_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -835432079, (short)-17909, (short)4562, (byte)-114, (byte)79, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_DISK_IO2_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 354193070, (short)32556, (short)18220, (byte)-98, (byte)84, (byte)-104, (byte)40, (byte)25, (byte)79, (byte)106, (byte)-120) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_BLOCK_IO_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1773249759, (short)25689, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_BLOCK_IO2_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1485101966, (short)-7550, (short)20127, (byte)-94, (byte)69, (byte)-62, (byte)-64, (byte)-30, (byte)123, (byte)-68, (byte)-63) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_BLOCK_IO_CRYPTO_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1610313542, (short)16154, (short)19276, (byte)-85, (byte)-112, (byte)79, (byte)-87, (byte)-105, (byte)38, (byte)-95, (byte)-24) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_ERASE_BLOCK_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1784043202, (short)-22418, (short)18726, (byte)-86, (byte)-17, (byte)-103, (byte)24, (byte)-25, (byte)114, (byte)-39, (byte)-121) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_ATA_PASS_THRU_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 490596336, (short)2055, (short)16975, (byte)-86, (byte)105, (byte)17, (byte)-91, (byte)78, (byte)25, (byte)-92, (byte)111) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_STORAGE_SECURITY_COMMAND_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -930411667, (short)3580, (short)18855, (byte)-100, (byte)-76, (byte)73, (byte)7, (byte)75, (byte)76, (byte)58, (byte)120) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_NVM_EXPRESS_PASS_THRU_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 1388806930, (short)-28964, (short)16947, (byte)-104, (byte)-14, (byte)26, (byte)26, (byte)-91, (byte)-29, (byte)-120, (byte)-91) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_SD_MMC_PASS_THRU_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 1903096025, (short)-125, (short)20329, (byte)-127, (byte)-23, (byte)81, (byte)-117, (byte)-45, (byte)-102, (byte)-114, (byte)112) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_RAM_DISK_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1422352161, (short)26739, (short)17577, (byte)-121, (byte)-26, (byte)-44, (byte)-21, (byte)86, (byte)20, (byte)-124, (byte)73) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_PARTITION_INFO_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1930234324, (short)-17253, (short)18465, (byte)-128, (byte)-115, (byte)-20, (byte)-98, (byte)-60, (byte)33, (byte)-95, (byte)-96) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_NVDIMM_LABEL_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -737449088, (short)-26667, (short)17026, (byte)-69, (byte)29, (byte)34, (byte)58, (byte)22, (byte)-111, (byte)-128, (byte)88) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_UFS_DEVICE_CONFIG_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1206125904, (short)3763, (short)19705, (byte)-124, (byte)101, (byte)127, (byte)-87, (byte)-122, (byte)54, (byte)22, (byte)100) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        return 0L;
    }

    @JvmStatic
    public static final long testConsole(@NotNull EFISystemTable systemTable) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        systemTable.getConOut().outputString("EFI_SIMPLE_TEXT_INPUT_EX_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -576817868, (short)30562, (short)18072, (byte)-116, (byte)20, (byte)-11, (byte)-123, (byte)23, (byte)-90, (byte)37, (byte)-86) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_SIMPLE_TEXT_INPUT_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 947156929, (short)27079, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_SIMPLE_TEXT_OUTPUT_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 947156930, (short)27079, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_SIMPLE_POINTER_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, 830966919, (short)2933, (short)4565, (byte)-102, (byte)79, (byte)0, (byte)-112, (byte)39, (byte)63, (byte)-63, (byte)77) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_ABSOLUTE_POINTER_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1923493077, (short)-14763, (short)19177, (byte)-101, (byte)21, (byte)-14, (byte)89, (byte)4, (byte)-103, (byte)42, (byte)67) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_SERIAL_IO_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1155149969, (short)-3628, (short)4562, (byte)-102, (byte)12, (byte)0, (byte)-112, (byte)39, (byte)63, (byte)-63, (byte)-3) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        systemTable.getConOut().outputString("EFI_GRAPHICS_OUTPUT_PROTOCOL Status: ");
        if ((int)EFIExample.testGUID-X7LrNfc(systemTable, -1874679330, (short)9180, (short)19000, (byte)-106, (byte)-5, (byte)122, (byte)-34, (byte)-48, (byte)-128, (byte)81, (byte)106) != 0) {
            systemTable.getConOut().outputString("Un");
        }
        systemTable.getConOut().outputString("Supported\r\n");
        return 0L;
    }

    @JvmStatic
    public static final long flash_EFI_SIMPLE_FILE_SYSTEM_PROTOCOL_GUID(@NotNull MemorySegment guid) {
        Intrinsics.checkNotNullParameter(guid, "guid");
        return EFIExample.populateGUID-X7LrNfc(guid, -1773249758, (short)25689, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59);
    }

    @JvmStatic
    public static final long flash_EFI_FILE_SYSTEM_INFO(@NotNull MemorySegment guid) {
        Intrinsics.checkNotNullParameter(guid, "guid");
        return EFIExample.populateGUID-X7LrNfc(guid, 156724883, (short)27967, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59);
    }

    @JvmStatic
    public static final long flash_EFI_FILE_INFO(@NotNull MemorySegment guid) {
        Intrinsics.checkNotNullParameter(guid, "guid");
        return EFIExample.populateGUID-X7LrNfc(guid, 156724882, (short)27967, (short)4562, (byte)-114, (byte)57, (byte)0, (byte)-96, (byte)-55, (byte)105, (byte)114, (byte)59);
    }

    @JvmStatic
    public static final long readFileSystemInfo(@NotNull EFISystemTable systemTable, @NotNull MemorySegment guid, @NotNull EFIFileProtocol from, @NotNull MemorySegment into) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        Intrinsics.checkNotNullParameter(guid, "guid");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(into, "into");
        MemorySegment bufferSize = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, 8L).getData();
        EFIExample.flash_EFI_FILE_SYSTEM_INFO(guid);
        bufferSize.set(ValueLayout.JAVA_LONG, 0L, 0L);
        MemorySegment memorySegment = MemorySegment.NULL;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
        from.getInfo(guid, bufferSize, memorySegment);
        long requiredSize = bufferSize.get(ValueLayout.JAVA_LONG, 0L);
        MemorySegment buffer = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, requiredSize).getData();
        long status = from.getInfo(guid, bufferSize, buffer);
        into.set(ValueLayout.ADDRESS, 0L, buffer);
        return status;
    }

    @JvmStatic
    public static final long readFileInfo(@NotNull EFISystemTable systemTable, @NotNull MemorySegment guid, @NotNull EFIFileProtocol from, @NotNull MemorySegment into) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        Intrinsics.checkNotNullParameter(guid, "guid");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(into, "into");
        MemorySegment bufferSize = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, 8L).getData();
        EFIExample.flash_EFI_FILE_INFO(guid);
        bufferSize.set(ValueLayout.JAVA_LONG, 0L, 0L);
        MemorySegment memorySegment = MemorySegment.NULL;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
        from.getInfo(guid, bufferSize, memorySegment);
        long requiredSize = bufferSize.get(ValueLayout.JAVA_LONG, 0L);
        MemorySegment buffer = systemTable.getBootServices().allocatePool(EFIMemoryType.EfiLoaderData, requiredSize).getData();
        long status = from.getInfo(guid, bufferSize, buffer);
        into.set(ValueLayout.ADDRESS, 0L, buffer);
        return status;
    }

    @JvmStatic
    public static final long printTime(@NotNull EFISystemTable systemTable, @NotNull EFITime time) {
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        Intrinsics.checkNotNullParameter(time, "time");
        EFIExample.printDecimal(systemTable, time.getYear(), 4);
        systemTable.getConOut().outputString("/");
        EFIExample.printDecimal(systemTable, time.getMonth(), 2);
        systemTable.getConOut().outputString("/");
        EFIExample.printDecimal(systemTable, time.getDay(), 2);
        systemTable.getConOut().outputString(" ");
        EFIExample.printDecimal(systemTable, time.getHour(), 2);
        systemTable.getConOut().outputString(":");
        EFIExample.printDecimal(systemTable, time.getMinute(), 2);
        systemTable.getConOut().outputString(":");
        EFIExample.printDecimal(systemTable, time.getSecond(), 2);
        systemTable.getConOut().outputString(".");
        EFIExample.printDecimal(systemTable, time.getNanosecond(), 9);
        short timeZone = time.getTimeZone();
        if (timeZone > 0) {
            systemTable.getConOut().outputString("+");
        }
        EFIExample.printDecimal(systemTable, timeZone, 4);
        return 0L;
    }

    @JvmStatic
    public static final long flash_EFI_GRAPHICS_OUTPUT_PROTOCOL_GUID(@NotNull MemorySegment guid) {
        Intrinsics.checkNotNullParameter(guid, "guid");
        return EFIExample.populateGUID-X7LrNfc(guid, -1874679330, (short)9180, (short)19000, (byte)-106, (byte)-5, (byte)122, (byte)-34, (byte)-48, (byte)-128, (byte)81, (byte)106);
    }

    @JvmStatic
    public static final long efiMain(@NotNull MemorySegment imageHandle, @NotNull EFISystemTable systemTable) {
        Intrinsics.checkNotNullParameter(imageHandle, "imageHandle");
        Intrinsics.checkNotNullParameter(systemTable, "systemTable");
        String a = "dynvar12345";
        String b = "dynvarABCD";
        systemTable.getConOut().outputString("prefix-" + a + b + "-suffix");
        return 0L;
    }
}

