/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.compile.pe;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.Flaggable;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.MappedEnumeration;
import org.bread_experts_group.api.compile.mzdos.MZDOSFile;
import org.bread_experts_group.api.compile.pe.PE32OptionalHeader;
import org.bread_experts_group.api.compile.pe.PE32WindowsOptionalHeader;
import org.bread_experts_group.api.compile.pe.PECharacteristics;
import org.bread_experts_group.api.compile.pe.PEMachineTypes;
import org.bread_experts_group.api.compile.pe.PESection;
import org.bread_experts_group.api.compile.pe.PESectionCharacteristics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/bread_experts_group/api/compile/pe/PEFile;", "", "structure", "Lorg/bread_experts_group/api/compile/pe/PEFile$FileStructure;", "<init>", "(Lorg/bread_experts_group/api/compile/pe/PEFile$FileStructure;)V", "build", "", "into", "Ljava/nio/channels/SeekableByteChannel;", "Companion", "FileStructure", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nPEFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PEFile.kt\norg/bread_experts_group/api/compile/pe/PEFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1869#2,2:114\n1869#2,2:116\n*S KotlinDebug\n*F\n+ 1 PEFile.kt\norg/bread_experts_group/api/compile/pe/PEFile\n*L\n63#1:114,2\n74#1:116,2\n*E\n"})
public final class PEFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileStructure structure;

    private PEFile(FileStructure structure) {
        this.structure = structure;
    }

    public final void build(@NotNull SeekableByteChannel into) {
        block8: {
            Intrinsics.checkNotNullParameter(into, "into");
            ByteBuffer buffer = null;
            buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            MZDOSFile mZDOSFile = this.structure.getMz();
            if (mZDOSFile != null) {
                MZDOSFile it = mZDOSFile;
                boolean bl = false;
                it.build(into);
                buffer.putInt(UInt.constructor-impl((int)(into.position() + (long)4)));
                buffer.put((byte)80);
                buffer.put((byte)69);
                buffer.putShort((short)0);
                into.write(buffer.clear());
            }
            long savedPosition = into.position();
            buffer = ByteBuffer.allocate(20);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(this.structure.getMachineType().getRaw().unbox-impl());
            buffer.putShort((short)this.structure.getSections().size());
            buffer.putInt(UInt.constructor-impl((int)this.structure.getCreatedTime().toEpochSecond()));
            buffer.putInt(0);
            buffer.putInt(0);
            int optionalHeaderOffset = buffer.position();
            buffer.putShort((short)0);
            buffer.putShort((short)Flaggable.Companion.raw((Collection<? extends Flaggable>)this.structure.getCharacteristics()));
            into.position(savedPosition + (long)20);
            PE32OptionalHeader pE32OptionalHeader = this.structure.getOptionalHeader();
            if (pE32OptionalHeader != null) {
                pE32OptionalHeader.build(into);
            }
            long afterOHWrite = into.position();
            buffer.position(optionalHeaderOffset);
            buffer.putShort((short)(afterOHWrite - (savedPosition + (long)20)));
            into.position(savedPosition);
            into.write(buffer.clear());
            into.position(afterOHWrite);
            Iterable $this$forEach$iv = this.structure.getSections();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PESection it = (PESection)element$iv;
                boolean bl = false;
                it.build(into);
            }
            long headerEnd = into.position();
            PE32OptionalHeader pE32OptionalHeader2 = this.structure.getOptionalHeader();
            if (pE32OptionalHeader2 == null) break block8;
            PE32OptionalHeader optionalHeader = pE32OptionalHeader2;
            boolean bl = false;
            Object object = this.structure.getOptionalHeader();
            if (object != null && (object = ((PE32OptionalHeader)object).getWindowsOptionalHeader()) != null) {
                Object windowsHeader = object;
                boolean bl2 = false;
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int sizeOfCode = 0;
                int sizeOfInitData = 0;
                int sizeOfUnInitData = 0;
                Iterable $this$forEach$iv2 = this.structure.getSections();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    byte[] rawData;
                    PESection section = (PESection)element$iv;
                    boolean bl3 = false;
                    if (section.getRawData$bread_server_lib() == null) continue;
                    int dataPosition = FormattingKt.normalize((int)into.position(), ((PE32WindowsOptionalHeader)windowsHeader).getFileAlignment-pVg5ArA$bread_server_lib());
                    into.position(dataPosition);
                    into.write(ByteBuffer.wrap(rawData));
                    long afterWrite = into.position();
                    into.position(section.getSizeOfRawDataPosition$bread_server_lib());
                    int sizeOfRawData = FormattingKt.normalize(rawData.length, ((PE32WindowsOptionalHeader)windowsHeader).getFileAlignment-pVg5ArA$bread_server_lib());
                    buffer.putInt(sizeOfRawData);
                    buffer.putInt(dataPosition);
                    into.write(buffer.clear());
                    buffer.clear();
                    if (rawData.length < sizeOfRawData) {
                        into.position((long)dataPosition + (long)sizeOfRawData - 1L);
                        into.write(ByteBuffer.allocate(1));
                    }
                    into.position(afterWrite);
                    if (section.getCharacteristics$bread_server_lib().contains(PESectionCharacteristics.IMAGE_SCN_CNT_CODE)) {
                        sizeOfCode += FormattingKt.normalize(rawData.length, ((PE32WindowsOptionalHeader)windowsHeader).getFileAlignment-pVg5ArA$bread_server_lib());
                    }
                    if (section.getCharacteristics$bread_server_lib().contains(PESectionCharacteristics.IMAGE_SCN_CNT_INITIALIZED_DATA)) {
                        sizeOfInitData += FormattingKt.normalize(rawData.length, ((PE32WindowsOptionalHeader)windowsHeader).getFileAlignment-pVg5ArA$bread_server_lib());
                    }
                    if (!section.getCharacteristics$bread_server_lib().contains(PESectionCharacteristics.IMAGE_SCN_CNT_UNINITIALIZED_DATA)) continue;
                    sizeOfUnInitData += FormattingKt.normalize(rawData.length, ((PE32WindowsOptionalHeader)windowsHeader).getFileAlignment-pVg5ArA$bread_server_lib());
                }
                buffer.clear();
                into.position(((PE32WindowsOptionalHeader)windowsHeader).getSizeOfImagePosition$bread_server_lib());
                buffer.putInt(FormattingKt.normalize(65536, ((PE32WindowsOptionalHeader)windowsHeader).getSectionAlignment-pVg5ArA$bread_server_lib()));
                buffer.putInt(FormattingKt.normalize((int)headerEnd, ((PE32WindowsOptionalHeader)windowsHeader).getFileAlignment-pVg5ArA$bread_server_lib()));
                into.write(buffer.clear());
                into.position(optionalHeader.getCodeSizePosition$bread_server_lib());
                buffer = ByteBuffer.allocate(12);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putInt(sizeOfCode);
                buffer.putInt(sizeOfInitData);
                buffer.putInt(sizeOfUnInitData);
                into.write(buffer.clear());
            }
        }
    }

    public /* synthetic */ PEFile(FileStructure structure, DefaultConstructorMarker $constructor_marker) {
        this(structure);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/bread_experts_group/api/compile/pe/PEFile$Companion;", "", "<init>", "()V", "of", "Lorg/bread_experts_group/api/compile/pe/PEFile;", "builder", "Lkotlin/Function1;", "Lorg/bread_experts_group/api/compile/pe/PEFile$FileStructure;", "", "Lkotlin/ExtensionFunctionType;", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PEFile of(@NotNull Function1<? super FileStructure, Unit> builder) {
            Intrinsics.checkNotNullParameter(builder, "builder");
            FileStructure pe = new FileStructure();
            builder.invoke(pe);
            return new PEFile(pe, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lorg/bread_experts_group/api/compile/pe/PEFile$FileStructure;", "", "<init>", "()V", "mz", "Lorg/bread_experts_group/api/compile/mzdos/MZDOSFile;", "getMz", "()Lorg/bread_experts_group/api/compile/mzdos/MZDOSFile;", "setMz", "(Lorg/bread_experts_group/api/compile/mzdos/MZDOSFile;)V", "machineType", "Lorg/bread_experts_group/MappedEnumeration;", "Lkotlin/UShort;", "Lorg/bread_experts_group/api/compile/pe/PEMachineTypes;", "getMachineType", "()Lorg/bread_experts_group/MappedEnumeration;", "setMachineType", "(Lorg/bread_experts_group/MappedEnumeration;)V", "sections", "", "Lorg/bread_experts_group/api/compile/pe/PESection;", "getSections", "()Ljava/util/List;", "setSections", "(Ljava/util/List;)V", "createdTime", "Ljava/time/ZonedDateTime;", "getCreatedTime", "()Ljava/time/ZonedDateTime;", "setCreatedTime", "(Ljava/time/ZonedDateTime;)V", "characteristics", "Ljava/util/EnumSet;", "Lorg/bread_experts_group/api/compile/pe/PECharacteristics;", "getCharacteristics", "()Ljava/util/EnumSet;", "setCharacteristics", "(Ljava/util/EnumSet;)V", "optionalHeader", "Lorg/bread_experts_group/api/compile/pe/PE32OptionalHeader;", "getOptionalHeader", "()Lorg/bread_experts_group/api/compile/pe/PE32OptionalHeader;", "setOptionalHeader", "(Lorg/bread_experts_group/api/compile/pe/PE32OptionalHeader;)V", "bread_server_lib"})
    public static final class FileStructure {
        @Nullable
        private MZDOSFile mz;
        @NotNull
        private MappedEnumeration<UShort, PEMachineTypes> machineType = new MappedEnumeration(PEMachineTypes.IMAGE_FILE_MACHINE_UNKNOWN);
        @NotNull
        private List<PESection> sections = CollectionsKt.emptyList();
        @NotNull
        private ZonedDateTime createdTime;
        @NotNull
        private EnumSet<PECharacteristics> characteristics;
        @Nullable
        private PE32OptionalHeader optionalHeader;

        public FileStructure() {
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue(zonedDateTime, "now(...)");
            this.createdTime = zonedDateTime;
            EnumSet<PECharacteristics> enumSet = EnumSet.noneOf(PECharacteristics.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, "noneOf(...)");
            this.characteristics = enumSet;
        }

        @Nullable
        public final MZDOSFile getMz() {
            return this.mz;
        }

        public final void setMz(@Nullable MZDOSFile mZDOSFile) {
            this.mz = mZDOSFile;
        }

        @NotNull
        public final MappedEnumeration<UShort, PEMachineTypes> getMachineType() {
            return this.machineType;
        }

        public final void setMachineType(@NotNull MappedEnumeration<UShort, PEMachineTypes> mappedEnumeration) {
            Intrinsics.checkNotNullParameter(mappedEnumeration, "<set-?>");
            this.machineType = mappedEnumeration;
        }

        @NotNull
        public final List<PESection> getSections() {
            return this.sections;
        }

        public final void setSections(@NotNull List<PESection> list) {
            Intrinsics.checkNotNullParameter(list, "<set-?>");
            this.sections = list;
        }

        @NotNull
        public final ZonedDateTime getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(@NotNull ZonedDateTime zonedDateTime) {
            Intrinsics.checkNotNullParameter(zonedDateTime, "<set-?>");
            this.createdTime = zonedDateTime;
        }

        @NotNull
        public final EnumSet<PECharacteristics> getCharacteristics() {
            return this.characteristics;
        }

        public final void setCharacteristics(@NotNull EnumSet<PECharacteristics> enumSet) {
            Intrinsics.checkNotNullParameter(enumSet, "<set-?>");
            this.characteristics = enumSet;
        }

        @Nullable
        public final PE32OptionalHeader getOptionalHeader() {
            return this.optionalHeader;
        }

        public final void setOptionalHeader(@Nullable PE32OptionalHeader pE32OptionalHeader) {
            this.optionalHeader = pE32OptionalHeader;
        }
    }
}

