/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.api.feature.CheckedImplementation;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.FeatureImplementation;
import org.bread_experts_group.api.feature.Implementation;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.feature.NoFeatureAvailableException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u0002H\u00010\u00022\u00020\u0003J;\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0001\u0010\u0012*\u00028\u0000\"\u000e\b\u0002\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00120\n2\u0006\u0010\u0014\u001a\u0002H\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J9\u0010\u0018\u001a\u0002H\u0012\"\b\b\u0001\u0010\u0012*\u00028\u0000\"\u000e\b\u0002\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00120\n2\u0006\u0010\u0014\u001a\u0002H\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R,\u0010\b\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019\u00c0\u0006\u0003"}, d2={"Lorg/bread_experts_group/api/feature/FeatureProvider;", "X", "Lorg/bread_experts_group/api/feature/FeatureImplementation;", "", "features", "", "getFeatures", "()Ljava/util/List;", "supportedFeatures", "", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "getSupportedFeatures", "()Ljava/util/Map;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "getOrNull", "I", "E", "feature", "allowEmulated", "", "(Lorg/bread_experts_group/api/feature/FeatureExpression;Z)Lorg/bread_experts_group/api/feature/FeatureImplementation;", "get", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nFeatureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureProvider.kt\norg/bread_experts_group/api/feature/FeatureProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,52:1\n295#2,2:53\n295#2,2:55\n382#3,7:57\n*S KotlinDebug\n*F\n+ 1 FeatureProvider.kt\norg/bread_experts_group/api/feature/FeatureProvider\n*L\n29#1:53,2\n40#1:55,2\n44#1:57,7\n*E\n"})
public interface FeatureProvider<X extends FeatureImplementation<? extends X>> {
    @NotNull
    public List<X> getFeatures();

    @NotNull
    public Map<FeatureExpression<? extends X>, List<X>> getSupportedFeatures();

    @NotNull
    public Logger getLogger();

    /*
     * WARNING - void declaration
     */
    @Nullable
    default public <I extends X, E extends FeatureExpression<I>> I getOrNull(@NotNull E feature, boolean allowEmulated) {
        Object object;
        void $this$getOrPut$iv;
        Object v2;
        block9: {
            Intrinsics.checkNotNullParameter(feature, "feature");
            List<X> supported = this.getSupportedFeatures().get(feature);
            if (supported != null) {
                FeatureImplementation featureImplementation;
                if (allowEmulated) {
                    featureImplementation = (FeatureImplementation)CollectionsKt.firstOrNull(supported);
                } else {
                    Object v1;
                    block8: {
                        Iterable $this$firstOrNull$iv = supported;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            FeatureImplementation it = (FeatureImplementation)element$iv;
                            boolean bl = false;
                            if (!(((Implementation)it).getSource() != ImplementationSource.JVM_EMULATED)) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    featureImplementation = v1;
                }
                FeatureImplementation featureImplementation2 = featureImplementation;
                Intrinsics.checkNotNull(featureImplementation2, "null cannot be cast to non-null type I of org.bread_experts_group.api.feature.FeatureProvider.getOrNull");
                return (I)featureImplementation2;
            }
            this.getFeatures().removeIf(arg_0 -> FeatureProvider.getOrNull$lambda$2(arg_0 -> FeatureProvider.getOrNull$lambda$1(this, arg_0), arg_0));
            Iterable $this$firstOrNull$iv = this.getFeatures();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FeatureImplementation it = (FeatureImplementation)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getExpresses(), feature) && (allowEmulated ? true : ((Implementation)it).getSource() != ImplementationSource.JVM_EMULATED))) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        FeatureImplementation featureImplementation = v2;
        if (featureImplementation == null) {
            return null;
        }
        FeatureImplementation found = featureImplementation;
        Map<FeatureExpression<X>, List<X>> $this$firstOrNull$iv = this.getSupportedFeatures();
        E key$iv = feature;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(found);
        return (I)found;
    }

    public static /* synthetic */ FeatureImplementation getOrNull$default(FeatureProvider featureProvider, FeatureExpression featureExpression, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrNull");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return featureProvider.getOrNull(featureExpression, bl);
    }

    @NotNull
    default public <I extends X, E extends FeatureExpression<I>> I get(@NotNull E feature, boolean allowEmulated) {
        Intrinsics.checkNotNullParameter(feature, "feature");
        I i = this.getOrNull(feature, allowEmulated);
        if (i == null) {
            throw new NoFeatureAvailableException(feature.getName());
        }
        return i;
    }

    public static /* synthetic */ FeatureImplementation get$default(FeatureProvider featureProvider, FeatureExpression featureExpression, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return featureProvider.get(featureExpression, bl);
    }

    private static boolean getOrNull$lambda$1(FeatureProvider this$0, FeatureImplementation it) {
        boolean bl;
        Intrinsics.checkNotNullParameter(it, "it");
        try {
            bl = it instanceof CheckedImplementation ? !((CheckedImplementation)((Object)it)).supported() : false;
        }
        catch (Exception e) {
            this$0.getLogger().log(Level.INFO, e, FeatureProvider::getOrNull$lambda$1$0);
            bl = true;
        }
        return bl;
    }

    private static String getOrNull$lambda$1$0() {
        return "Exception during feature support check";
    }

    private static boolean getOrNull$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static <X extends FeatureImplementation<? extends X>, I extends X, E extends FeatureExpression<I>> I getOrNull(@NotNull FeatureProvider<X> $this, @NotNull E feature, boolean allowEmulated) {
            Intrinsics.checkNotNullParameter(feature, "feature");
            return (I)((FeatureProvider)$this).getOrNull(feature, allowEmulated);
        }

        public static /* synthetic */ FeatureImplementation getOrNull$default(FeatureProvider featureProvider, FeatureExpression featureExpression, boolean bl, int n, Object object) {
            return FeatureProvider.getOrNull$default(featureProvider, featureExpression, bl, n, object);
        }

        @Deprecated
        @NotNull
        public static <X extends FeatureImplementation<? extends X>, I extends X, E extends FeatureExpression<I>> I get(@NotNull FeatureProvider<X> $this, @NotNull E feature, boolean allowEmulated) {
            Intrinsics.checkNotNullParameter(feature, "feature");
            return (I)((FeatureProvider)$this).get(feature, allowEmulated);
        }

        public static /* synthetic */ FeatureImplementation get$default(FeatureProvider featureProvider, FeatureExpression featureExpression, boolean bl, int n, Object object) {
            return FeatureProvider.get$default(featureProvider, featureExpression, bl, n, object);
        }
    }
}

