/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.console.feature.device.feature.windows;

import java.lang.invoke.MethodHandle;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.coding.CodingFormat;
import org.bread_experts_group.api.coding.windows.WindowsCodingFormat;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOCodingSetFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOCodingSetFeature;", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOCodingSetFeature;", "input", "", "<init>", "(Z)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "setCoding", "", "coding", "Lorg/bread_experts_group/api/coding/CodingFormat;", "bread_server_lib"})
public final class WindowsGraphicsConsoleIOCodingSetFeature
extends GraphicsConsoleIOCodingSetFeature {
    private final boolean input;
    @NotNull
    private final ImplementationSource source;

    public WindowsGraphicsConsoleIOCodingSetFeature(boolean input) {
        this.input = input;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeSetConsoleCP() != null && WindowsKernelHandlesKt.getNativeSetConsoleOutputCP() != null;
    }

    @Override
    public void setCoding(@NotNull CodingFormat coding) {
        int status;
        Intrinsics.checkNotNullParameter(coding, "coding");
        WindowsCodingFormat cfr_ignored_0 = (WindowsCodingFormat)coding;
        if (this.input) {
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeSetConsoleCP();
            Intrinsics.checkNotNull(methodHandle);
            v1 = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), ((WindowsCodingFormat)coding).getPageNr-pVg5ArA());
        } else {
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeSetConsoleOutputCP();
            Intrinsics.checkNotNull(methodHandle);
            v1 = status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), ((WindowsCodingFormat)coding).getPageNr-pVg5ArA());
        }
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
    }
}

