/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.console.feature.device.feature.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOEvent;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOEventGetFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLastErrorException;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0003J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000f\u0010 \u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOEventGetFeature;", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOEventGetFeature;", "handle", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "arena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "record", "modifierMap", "", "Lkotlin/UInt;", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOEvent$KeyModifiers;", "decodeRecord", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOEvent;", "getEvent", "pollEvent", "peekEvent", "peekNextEvent", "getEvents", "", "returnIfNone", "maxLength", "", "peekEvents", "getEventCount", "getEventCount-pVg5ArA", "()I", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsGraphicsConsoleIOEventGetFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsGraphicsConsoleIOEventGetFeature.kt\norg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOEventGetFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1803#2,3:176\n*S KotlinDebug\n*F\n+ 1 WindowsGraphicsConsoleIOEventGetFeature.kt\norg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOEventGetFeature\n*L\n48#1:176,3\n*E\n"})
public final class WindowsGraphicsConsoleIOEventGetFeature
extends GraphicsConsoleIOEventGetFeature {
    @NotNull
    private final MemorySegment handle;
    @NotNull
    private final ImplementationSource source;
    private final Arena arena;
    private final MemorySegment record;
    @NotNull
    private final Map<UInt, GraphicsConsoleIOEvent.KeyModifiers> modifierMap;

    public WindowsGraphicsConsoleIOEventGetFeature(@NotNull MemorySegment handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        this.handle = handle;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        this.arena = Arena.ofShared();
        this.record = this.arena.allocate(WindowsLayoutsKt.getINPUT_RECORD());
        Pair[] pairArray = new Pair[]{TuplesKt.to(UInt.box-impl(1), GraphicsConsoleIOEvent.KeyModifiers.RIGHT_ALT), TuplesKt.to(UInt.box-impl(2), GraphicsConsoleIOEvent.KeyModifiers.LEFT_ALT), TuplesKt.to(UInt.box-impl(4), GraphicsConsoleIOEvent.KeyModifiers.RIGHT_CTRL), TuplesKt.to(UInt.box-impl(8), GraphicsConsoleIOEvent.KeyModifiers.LEFT_CTRL), TuplesKt.to(UInt.box-impl(16), GraphicsConsoleIOEvent.KeyModifiers.SHIFT), TuplesKt.to(UInt.box-impl(32), GraphicsConsoleIOEvent.KeyModifiers.NUM_LOCK), TuplesKt.to(UInt.box-impl(64), GraphicsConsoleIOEvent.KeyModifiers.SCROLL_LOCK), TuplesKt.to(UInt.box-impl(128), GraphicsConsoleIOEvent.KeyModifiers.CAPS_LOCK)};
        this.modifierMap = MapsKt.mapOf(pairArray);
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        if (WindowsKernelHandlesKt.getNativeGetNumberOfConsoleInputEvents() == null || WindowsKernelHandlesKt.getNativeReadConsoleInputExW() == null) {
            return false;
        }
        try {
            this.getEventCount-pVg5ArA();
        }
        catch (WindowsLastErrorException windowsLastErrorException) {
            return false;
        }
        return true;
    }

    @NotNull
    public final GraphicsConsoleIOEvent decodeRecord(@NotNull MemorySegment record) {
        Intrinsics.checkNotNullParameter(record, "record");
        return switch (WindowsLayoutsKt.getINPUT_RECORD_EventType().get(record, 0L)) {
            case 1 -> {
                void $this$fold$iv;
                void initial$iv;
                MemorySegment key = WindowsLayoutsKt.getINPUT_RECORD_KeyEvent().invokeExact(record, 0L);
                int modifiersRaw = WindowsLayoutsKt.getKEY_EVENT_RECORD_dwControlKeyState().get(key, 0);
                Iterable var5_6 = this.modifierMap.entrySet();
                EnumSet<GraphicsConsoleIOEvent.KeyModifiers> var6_7 = EnumSet.noneOf(GraphicsConsoleIOEvent.KeyModifiers.class);
                boolean $i$f$fold = false;
                void accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void r;
                    Map.Entry var11_12 = (Map.Entry)element$iv;
                    void a = accumulator$iv;
                    boolean $i$a$-fold-WindowsGraphicsConsoleIOEventGetFeature$decodeRecord$modifiers$1 = false;
                    if ((modifiersRaw & ((UInt)r.getKey()).unbox-impl()) > 0) {
                        a.add(r.getValue());
                    }
                    accumulator$iv = a;
                }
                void modifiers = accumulator$iv;
                boolean v0 = WindowsLayoutsKt.getKEY_EVENT_RECORD_bKeyDown().get(key, 0L) == 1;
                short v1 = WindowsLayoutsKt.getKEY_EVENT_RECORD_wRepeatCount().get(key, 0L);
                short v2 = WindowsLayoutsKt.getKEY_EVENT_RECORD_wVirtualKeyCode().get(key, 0L);
                short v3 = WindowsLayoutsKt.getKEY_EVENT_RECORD_wVirtualScanCode().get(key, 0L);
                char v4 = (char)(UShort.constructor-impl(WindowsLayoutsKt.getKEY_EVENT_RECORD_uChar_UnicodeChar().get(key, 0L)) & 0xFFFF);
                Intrinsics.checkNotNull(modifiers);
                yield new GraphicsConsoleIOEvent.Key(v0, v1, v2, v3, v4, (EnumSet<GraphicsConsoleIOEvent.KeyModifiers>)modifiers);
            }
            case 4 -> {
                MemorySegment bufferSize = WindowsLayoutsKt.getINPUT_RECORD_WindowBufferSizeEvent().invokeExact(record, 0L);
                MemorySegment coord = WindowsLayoutsKt.getWINDOW_BUFFER_SIZE_RECORD_COORD().invokeExact(bufferSize, 0L);
                yield new GraphicsConsoleIOEvent.WindowSize(WindowsLayoutsKt.getCOORD_X().get(coord, 0L), WindowsLayoutsKt.getCOORD_Y().get(coord, 0L));
            }
            default -> new GraphicsConsoleIOEvent.OperatingSystemDependent();
        };
    }

    @Override
    @Nullable
    public GraphicsConsoleIOEvent getEvent() {
        GraphicsConsoleIOEvent graphicsConsoleIOEvent;
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadConsoleInputExW();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, this.record, 1, WindowsUtilitiesKt.getThreadLocalDWORD0(), (short)2);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        if (WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L) > 0) {
            MemorySegment memorySegment = this.record;
            Intrinsics.checkNotNullExpressionValue(memorySegment, "record");
            graphicsConsoleIOEvent = this.decodeRecord(memorySegment);
        } else {
            graphicsConsoleIOEvent = null;
        }
        return graphicsConsoleIOEvent;
    }

    @Override
    @NotNull
    public GraphicsConsoleIOEvent pollEvent() {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadConsoleInputExW();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, this.record, 1, WindowsUtilitiesKt.getThreadLocalDWORD0(), (short)0);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        MemorySegment memorySegment = this.record;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "record");
        return this.decodeRecord(memorySegment);
    }

    @Override
    @Nullable
    public GraphicsConsoleIOEvent peekEvent() {
        GraphicsConsoleIOEvent graphicsConsoleIOEvent;
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadConsoleInputExW();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, this.record, 1, WindowsUtilitiesKt.getThreadLocalDWORD0(), (short)3);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        if (WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L) > 0) {
            MemorySegment memorySegment = this.record;
            Intrinsics.checkNotNullExpressionValue(memorySegment, "record");
            graphicsConsoleIOEvent = this.decodeRecord(memorySegment);
        } else {
            graphicsConsoleIOEvent = null;
        }
        return graphicsConsoleIOEvent;
    }

    @Override
    @NotNull
    public GraphicsConsoleIOEvent peekNextEvent() {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadConsoleInputExW();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, this.record, 1, WindowsUtilitiesKt.getThreadLocalDWORD0(), (short)1);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        MemorySegment memorySegment = this.record;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "record");
        return this.decodeRecord(memorySegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GraphicsConsoleIOEvent> getEvents(boolean returnIfNone, int maxLength) {
        List list;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena it = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment events = this.arena.allocate(WindowsLayoutsKt.getINPUT_RECORD(), maxLength);
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadConsoleInputExW();
            Intrinsics.checkNotNull(methodHandle);
            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, events, maxLength, WindowsUtilitiesKt.getThreadLocalDWORD0(), (short)(returnIfNone ? 2 : 0));
            if (status == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
            int count = WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L);
            ArrayList<GraphicsConsoleIOEvent> arrayList = new ArrayList<GraphicsConsoleIOEvent>(count);
            int n = 0;
            while (n < count) {
                void it2;
                int n2;
                int n3 = n2 = n++;
                ArrayList<GraphicsConsoleIOEvent> arrayList2 = arrayList;
                boolean bl2 = false;
                MemorySegment memorySegment = events.asSlice(WindowsLayoutsKt.getINPUT_RECORD().byteSize() * (long)it2);
                Intrinsics.checkNotNullExpressionValue(memorySegment, "asSlice(...)");
                arrayList2.add(this.decodeRecord(memorySegment));
            }
            list = arrayList;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<GraphicsConsoleIOEvent> peekEvents(boolean returnIfNone, int maxLength) {
        List<GraphicsConsoleIOEvent> list;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            List<GraphicsConsoleIOEvent> list2;
            Arena it = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment events = this.arena.allocate(WindowsLayoutsKt.getINPUT_RECORD(), maxLength);
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadConsoleInputExW();
            Intrinsics.checkNotNull(methodHandle);
            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, events, maxLength, WindowsUtilitiesKt.getThreadLocalDWORD0(), (short)(returnIfNone ? 3 : 1));
            if (status == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
            int i = 0;
            int count = WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L);
            List<GraphicsConsoleIOEvent> $this$peekEvents_u24lambda_u240_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            while (i < count) {
                int n = i;
                i = n + 1;
                MemorySegment memorySegment = events.asSlice(WindowsLayoutsKt.getINPUT_RECORD().byteSize() * (long)n);
                Intrinsics.checkNotNullExpressionValue(memorySegment, "asSlice(...)");
                $this$peekEvents_u24lambda_u240_u240.add(this.decodeRecord(memorySegment));
            }
            list = CollectionsKt.build(list2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    @Override
    public int getEventCount-pVg5ArA() {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeGetNumberOfConsoleInputEvents();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, WindowsUtilitiesKt.getThreadLocalDWORD0());
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return UInt.constructor-impl(WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L));
    }
}

