/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.console.feature.device.feature.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOModeGetFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleModes;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOModeGetFeature;", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOModeGetFeature;", "handle", "Ljava/lang/foreign/MemorySegment;", "mapping", "", "Lkotlin/UInt;", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleModes;", "<init>", "(Ljava/lang/foreign/MemorySegment;Ljava/util/Map;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "getMode", "Lkotlin/Pair;", "", "supported", "", "mode", "Ljava/util/EnumSet;", "()Ljava/util/EnumSet;", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsGraphicsConsoleIOModeGetFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsGraphicsConsoleIOModeGetFeature.kt\norg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOModeGetFeature\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,43:1\n216#2,2:44\n*S KotlinDebug\n*F\n+ 1 WindowsGraphicsConsoleIOModeGetFeature.kt\norg/bread_experts_group/api/graphics/feature/console/feature/device/feature/windows/WindowsGraphicsConsoleIOModeGetFeature\n*L\n40#1:44,2\n*E\n"})
public final class WindowsGraphicsConsoleIOModeGetFeature
extends GraphicsConsoleIOModeGetFeature {
    @NotNull
    private final MemorySegment handle;
    @NotNull
    private final Map<UInt, GraphicsConsoleModes> mapping;
    @NotNull
    private final ImplementationSource source;

    public WindowsGraphicsConsoleIOModeGetFeature(@NotNull MemorySegment handle, @NotNull Map<UInt, ? extends GraphicsConsoleModes> mapping) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        Intrinsics.checkNotNullParameter(mapping, "mapping");
        this.handle = handle;
        this.mapping = mapping;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    private final Pair<Integer, UInt> getMode() {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeGetConsoleMode();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, WindowsUtilitiesKt.getThreadLocalDWORD0());
        return TuplesKt.to(status, UInt.box-impl(UInt.constructor-impl(WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L))));
    }

    @Override
    public boolean supported() {
        if (WindowsKernelHandlesKt.getNativeGetConsoleMode() == null) {
            return false;
        }
        int status = ((Number)this.getMode().component1()).intValue();
        return status != 0;
    }

    @Override
    @NotNull
    public EnumSet<GraphicsConsoleModes> getMode() {
        Pair<Integer, UInt> pair = this.getMode();
        int status = ((Number)pair.component1()).intValue();
        int mode = pair.component2().unbox-impl();
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        EnumSet<GraphicsConsoleModes> modes = EnumSet.noneOf(GraphicsConsoleModes.class);
        Map<UInt, GraphicsConsoleModes> $this$forEach$iv = this.mapping;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UInt, GraphicsConsoleModes>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<UInt, GraphicsConsoleModes> element$iv;
            Map.Entry<UInt, GraphicsConsoleModes> entry = element$iv = iterator2.next();
            boolean bl = false;
            int k = entry.getKey().unbox-impl();
            GraphicsConsoleModes v = entry.getValue();
            if (Integer.compareUnsigned(UInt.constructor-impl(mode & k), 0) <= 0) continue;
            modes.add(v);
        }
        Intrinsics.checkNotNull(modes);
        return modes;
    }
}

