/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.console.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.GraphicsFeatures;
import org.bread_experts_group.api.graphics.feature.console.GraphicsConsoleFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/bread_experts_group/api/graphics/feature/console/windows/WindowsGraphicsConsoleFeature;", "Lorg/bread_experts_group/api/graphics/feature/console/GraphicsConsoleFeature;", "<init>", "()V", "expresses", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "getExpresses", "()Lorg/bread_experts_group/api/feature/FeatureExpression;", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "bread_server_lib"})
public final class WindowsGraphicsConsoleFeature
extends GraphicsConsoleFeature {
    @NotNull
    private final FeatureExpression<GraphicsConsoleFeature> expresses = GraphicsFeatures.INSTANCE.getCUI_CONSOLE();
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;

    @Override
    @NotNull
    public FeatureExpression<GraphicsConsoleFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeAllocConsoleWithOptions();
        if (methodHandle == null) {
            return false;
        }
        int result = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), MemorySegment.NULL, WindowsUtilitiesKt.getThreadLocalDWORD0());
        if (result != 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        int consoleStatus = WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L);
        return consoleStatus != 0;
    }
}

