/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window.feature.opengl;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowOpenGLContextFeature;
import org.bread_experts_group.api.graphics.feature.window.feature.opengl.OpenGLErrorKt;
import org.bread_experts_group.api.graphics.feature.window.feature.opengl.OpenGLShaderParameterName;
import org.bread_experts_group.api.graphics.feature.window.feature.opengl.OpenGLShaderType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u000f0\u000fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShader;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "from", "Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowOpenGLContextFeature;", "type", "Lorg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShaderType;", "<init>", "(Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowOpenGLContextFeature;Lorg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShaderType;)V", "handle", "", "getHandle", "()I", "source", "", "", "getSource", "()[Ljava/lang/String;", "setSource", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "compile", "", "compileInfoLog", "kotlin.jvm.PlatformType", "close", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nOpenGLShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenGLShader.kt\norg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,52:1\n13870#2,3:53\n*S KotlinDebug\n*F\n+ 1 OpenGLShader.kt\norg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShader\n*L\n17#1:53,3\n*E\n"})
public final class OpenGLShader
implements AutoCloseable {
    @NotNull
    private final GraphicsWindowOpenGLContextFeature from;
    private final int handle;
    @NotNull
    private String[] source;

    public OpenGLShader(@NotNull GraphicsWindowOpenGLContextFeature from, @NotNull OpenGLShaderType type) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(type, "type");
        this.from = from;
        this.handle = this.from.glCreateShader(type);
        this.source = new String[0];
    }

    public final int getHandle() {
        return this.handle;
    }

    @NotNull
    public final String[] getSource() {
        return this.source;
    }

    public final void setSource(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "<set-?>");
        this.source = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean compile() {
        boolean bl;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl2 = false;
            MemorySegment sourceArray = arena.allocate(ValueLayout.ADDRESS, this.source.length);
            String[] $this$forEachIndexed$iv = this.source;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (String item$iv : $this$forEachIndexed$iv) {
                void source;
                int n = index$iv++;
                String string = item$iv;
                int i = n;
                boolean bl3 = false;
                sourceArray.set(ValueLayout.ADDRESS, (long)i, arena.allocateFrom((String)source, Charsets.US_ASCII));
            }
            int n = this.source.length;
            Intrinsics.checkNotNull(sourceArray);
            MemorySegment memorySegment = MemorySegment.NULL;
            Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
            this.from.glShaderSource(this.handle, n, sourceArray, memorySegment);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            this.from.glCompileShader(this.handle);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            MemorySegment compileStatus = arena.allocate(ValueLayout.JAVA_BOOLEAN);
            Intrinsics.checkNotNull(compileStatus);
            this.from.glGetShaderiv(this.handle, OpenGLShaderParameterName.GL_COMPILE_STATUS, compileStatus);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            bl = compileStatus.get(ValueLayout.JAVA_BOOLEAN, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String compileInfoLog() {
        String string;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment length = arena.allocate(ValueLayout.JAVA_INT);
            Intrinsics.checkNotNull(length);
            this.from.glGetShaderiv(this.handle, OpenGLShaderParameterName.GL_INFO_LOG_LENGTH, length);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            int infoLogLength = length.get(ValueLayout.JAVA_INT, 0L);
            MemorySegment infoLog = arena.allocate(infoLogLength);
            Intrinsics.checkNotNull(infoLog);
            this.from.glGetShaderInfoLog(this.handle, infoLogLength, length, infoLog);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            string = infoLog.getString(0L, Charsets.US_ASCII);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return string;
    }

    @Override
    public void close() {
        this.from.glDeleteShader(this.handle);
        OpenGLErrorKt.checkAndThrow(this.from.glGetError());
    }
}

