/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window.wayland;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.GraphicsFeatures;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindow;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindowFeature;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindowTemplate;
import org.bread_experts_group.api.graphics.feature.window.wayland.WaylandGraphicsWindow;
import org.bread_experts_group.api.graphics.feature.window.wayland.WaylandGraphicsWindowTemplate;
import org.bread_experts_group.ffi.wayland.WaylandHandlesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/wayland/WaylandGraphicsWindowFeature;", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindowFeature;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "expresses", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "getExpresses", "()Lorg/bread_experts_group/api/feature/FeatureExpression;", "createTemplate", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindowTemplate;", "createWindow", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindow;", "template", "supported", "", "bread_server_lib"})
public final class WaylandGraphicsWindowFeature
extends GraphicsWindowFeature {
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    @NotNull
    private final FeatureExpression<GraphicsWindowFeature> expresses = GraphicsFeatures.INSTANCE.getGUI_WINDOW();

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public FeatureExpression<GraphicsWindowFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public GraphicsWindowTemplate createTemplate() {
        return new WaylandGraphicsWindowTemplate();
    }

    @Override
    @NotNull
    public GraphicsWindow createWindow(@NotNull GraphicsWindowTemplate template) {
        Intrinsics.checkNotNullParameter(template, "template");
        return new WaylandGraphicsWindow((WaylandGraphicsWindowTemplate)template);
    }

    @Override
    public boolean supported() {
        MethodHandle methodHandle = WaylandHandlesKt.getNativeWLDisplayConnect();
        if (methodHandle == null) {
            return false;
        }
        MemorySegment display = methodHandle.invokeExact(MemorySegment.NULL);
        if (Intrinsics.areEqual(display, MemorySegment.NULL)) {
            return false;
        }
        MethodHandle methodHandle2 = WaylandHandlesKt.getNativeWLDisplayDisconnect();
        if (methodHandle2 == null) {
            return false;
        }
        methodHandle2.invokeExact(display);
        return true;
    }
}

