/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.GraphicsFeatures;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindow;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindowFeature;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindowTemplate;
import org.bread_experts_group.api.graphics.feature.window.windows.WindowsGraphicsWindow;
import org.bread_experts_group.api.graphics.feature.window.windows.WindowsGraphicsWindowTemplate;
import org.bread_experts_group.ffi.windows.WindowStationAccessRights;
import org.bread_experts_group.ffi.windows.WindowsUserHandlesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/windows/WindowsGraphicsWindowFeature;", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindowFeature;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "expresses", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "getExpresses", "()Lorg/bread_experts_group/api/feature/FeatureExpression;", "supported", "", "createTemplate", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindowTemplate;", "createWindow", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindow;", "template", "bread_server_lib"})
public final class WindowsGraphicsWindowFeature
extends GraphicsWindowFeature {
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    @NotNull
    private final FeatureExpression<GraphicsWindowFeature> expresses = GraphicsFeatures.INSTANCE.getGUI_WINDOW();

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public FeatureExpression<GraphicsWindowFeature> getExpresses() {
        return this.expresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supported() {
        boolean bl;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl2 = false;
            if (WindowsUserHandlesKt.getNativeOpenWindowStationW() != null && WindowsUserHandlesKt.getNativeGetProcessWindowStation() != null && WindowsUserHandlesKt.getNativeSetProcessWindowStation() != null && WindowsUserHandlesKt.getNativeOpenDesktopW() != null && WindowsUserHandlesKt.getNativeCloseWindowStation() != null && WindowsUserHandlesKt.getNativeCloseDesktop() != null) {
                MemorySegment station = WindowsUserHandlesKt.getNativeOpenWindowStationW().invokeExact(arena.allocateFrom("WinSta0", Charsets.UTF_16LE), 0, (int)WindowStationAccessRights.READ_CONTROL.getPosition());
                if (Intrinsics.areEqual(station, MemorySegment.NULL)) {
                    boolean bl3 = false;
                    return bl3;
                }
                MemorySegment savedStation = WindowsUserHandlesKt.getNativeGetProcessWindowStation().invokeExact();
                int setStationCheck = WindowsUserHandlesKt.getNativeSetProcessWindowStation().invokeExact(station);
                if (setStationCheck == 0) {
                    boolean bl4 = false;
                    return bl4;
                }
                MemorySegment stationDesktop = WindowsUserHandlesKt.getNativeOpenDesktopW().invokeExact(arena.allocateFrom("Default", Charsets.UTF_16LE), 0, 0, (int)WindowStationAccessRights.READ_CONTROL.getPosition());
                WindowsUserHandlesKt.getNativeSetProcessWindowStation().invokeExact(savedStation);
                boolean stationDesktopOK = !Intrinsics.areEqual(stationDesktop, MemorySegment.NULL);
                WindowsUserHandlesKt.getNativeCloseWindowStation().invokeExact(station);
                WindowsUserHandlesKt.getNativeCloseDesktop().invokeExact(stationDesktop);
                boolean bl5 = stationDesktopOK;
                return bl5;
            }
            bl = false;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    @Override
    @NotNull
    public GraphicsWindowTemplate createTemplate() {
        return new WindowsGraphicsWindowTemplate();
    }

    @Override
    @NotNull
    public GraphicsWindow createWindow(@NotNull GraphicsWindowTemplate template) {
        Intrinsics.checkNotNullParameter(template, "template");
        return new WindowsGraphicsWindow((WindowsGraphicsWindowTemplate)template);
    }
}

