/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.PreInitializableClosable;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowNameFeature;
import org.bread_experts_group.api.graphics.feature.window.windows.WindowsGraphicsWindow;
import org.bread_experts_group.ffi.windows.WindowsMessageTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/windows/WindowsGraphicsWindowNameFeature;", "Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowNameFeature;", "Lorg/bread_experts_group/api/PreInitializableClosable;", "window", "Lorg/bread_experts_group/api/graphics/feature/window/windows/WindowsGraphicsWindow;", "<init>", "(Lorg/bread_experts_group/api/graphics/feature/window/windows/WindowsGraphicsWindow;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "internalName", "", "open", "", "close", "value", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "bread_server_lib"})
public final class WindowsGraphicsWindowNameFeature
extends GraphicsWindowNameFeature
implements PreInitializableClosable {
    @NotNull
    private final WindowsGraphicsWindow window;
    @NotNull
    private final ImplementationSource source;
    @Nullable
    private String internalName;

    public WindowsGraphicsWindowNameFeature(@NotNull WindowsGraphicsWindow window) {
        Intrinsics.checkNotNullParameter(window, "window");
        this.window = window;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        this.internalName = "BSL Window";
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public void open() {
        this.internalName = null;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getName() {
        String string = this.internalName;
        if (string == null) {
            String string2;
            AutoCloseable autoCloseable = Arena.ofConfined();
            Throwable throwable = null;
            try {
                Arena arena = (Arena)autoCloseable;
                boolean bl = false;
                long textLength = this.window.sendMessage$bread_server_lib(WindowsMessageTypes.WM_GETTEXTLENGTH, 0L, 0L) + 1L;
                MemorySegment buffer = arena.allocate(textLength * (long)2);
                this.window.sendMessage$bread_server_lib(WindowsMessageTypes.WM_GETTEXT, textLength, buffer.address());
                String string3 = buffer.getString(0L, Charsets.UTF_16LE);
                string2 = string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "use(...)");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.internalName != null) {
            this.internalName = value;
        } else {
            AutoCloseable autoCloseable = Arena.ofConfined();
            Throwable throwable = null;
            try {
                Arena arena = (Arena)autoCloseable;
                boolean bl = false;
                Long l = this.window.sendMessage$bread_server_lib(WindowsMessageTypes.WM_SETTEXT, 0L, arena.allocateFrom(value, Charsets.UTF_16LE).address());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
    }
}

