/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindowTemplate;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUserHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\t\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR;\u0010\n\u001a,\u0012\u0004\u0012\u00020\f\u0012\"\u0012 \u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/windows/WindowsGraphicsWindowTemplate;", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindowTemplate;", "<init>", "()V", "arena", "Ljava/lang/foreign/Arena;", "classAtom", "", "getClassAtom", "()S", "windows", "", "Ljava/lang/foreign/MemorySegment;", "Lkotlin/Function4;", "", "", "getWindows", "()Ljava/util/Map;", "wndProc", "hWnd", "message", "wParam", "lParam", "Companion", "bread_server_lib"})
public final class WindowsGraphicsWindowTemplate
extends GraphicsWindowTemplate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Arena arena;
    private final short classAtom;
    @NotNull
    private final Map<MemorySegment, Function4<MemorySegment, Integer, Long, Long, Long>> windows;
    private static int counter;

    public WindowsGraphicsWindowTemplate() {
        Arena arena = Arena.ofConfined();
        Intrinsics.checkNotNullExpressionValue(arena, "ofConfined(...)");
        this.arena = arena;
        this.windows = new LinkedHashMap();
        MemorySegment classExA = this.arena.allocate(WindowsLayoutsKt.getWNDCLASSEXA());
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeGetModuleHandleW();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment localHandle = methodHandle.invokeExact(MemorySegment.NULL);
        MethodHandles.Lookup methodHandles = MethodHandles.lookup();
        WindowsLayoutsKt.getWNDCLASSEXA_cbSize().set(classExA, 0, (int)classExA.byteSize());
        Object[] objectArray = new Class[]{Integer.TYPE, Long.TYPE, Long.TYPE};
        MethodHandle methodHandle2 = methodHandles.findSpecial(this.getClass(), "wndProc", MethodType.methodType(Long.TYPE, MemorySegment.class, objectArray), this.getClass()).bindTo(this);
        objectArray = new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG};
        WindowsLayoutsKt.getWNDCLASSEXA_lpfnWndProc().set(classExA, 0, ForeignFunctionInterfaceKt.getNativeLinker().upcallStub(methodHandle2, FunctionDescriptor.of(ValueLayout.JAVA_LONG, (MemoryLayout[])objectArray), this.arena, new Linker.Option[0]));
        WindowsLayoutsKt.getWNDCLASSEXA_hInstance().set(classExA, 0, localHandle);
        int n = counter;
        counter = n + 1;
        WindowsLayoutsKt.getWNDCLASSEXA_lpszClassName().set(classExA, 0, this.arena.allocateFrom("bsl" + n, Charsets.UTF_16LE));
        MethodHandle methodHandle3 = WindowsUserHandlesKt.getNativeRegisterClassExW();
        Intrinsics.checkNotNull(methodHandle3);
        short classAtom = methodHandle3.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), classExA);
        if (classAtom == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        this.classAtom = classAtom;
    }

    public final short getClassAtom() {
        return this.classAtom;
    }

    @NotNull
    public final Map<MemorySegment, Function4<MemorySegment, Integer, Long, Long, Long>> getWindows() {
        return this.windows;
    }

    public final long wndProc(@NotNull MemorySegment hWnd, int message, long wParam, long lParam) {
        Intrinsics.checkNotNullParameter(hWnd, "hWnd");
        Function4<MemorySegment, Integer, Long, Long, Long> function4 = this.windows.get(hWnd);
        if (function4 == null) {
            MethodHandle methodHandle = WindowsUserHandlesKt.getNativeDefWindowProcW();
            Intrinsics.checkNotNull(methodHandle);
            return methodHandle.invokeExact(hWnd, message, wParam, lParam);
        }
        Function4<MemorySegment, Integer, Long, Long, Long> proc = function4;
        return ((Number)proc.invoke(hWnd, message, wParam, lParam)).longValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/windows/WindowsGraphicsWindowTemplate$Companion;", "", "<init>", "()V", "counter", "", "getCounter", "()I", "setCounter", "(I)V", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCounter() {
            return counter;
        }

        public final void setCounter(int n) {
            counter = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

