/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.blob.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.bread_experts_group.api.secure.blob.SecureDataBlob;
import org.bread_experts_group.api.secure.blob.SecuredByteArray;
import org.bread_experts_group.api.secure.blob.feature.windows.WindowsCrossProcessEncryptedSecureDataBlobFeature;
import org.bread_experts_group.api.secure.blob.feature.windows.WindowsLocalProcessEncryptedSecureDataBlobFeature;
import org.bread_experts_group.api.secure.blob.feature.windows.WindowsLocalUserEncryptedSecureDataBlobFeature;
import org.bread_experts_group.api.secure.blob.windows.WindowsSecureDataBlob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\u0019\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0014H\u0096\u0002J\u0019\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\u0019\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0017H\u0096\u0002J\u0019\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0014H\u0096\u0002J\b\u0010*\u001a\u00020\u000bH\u0014J\b\u0010+\u001a\u00020,H\u0016R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006-"}, d2={"Lorg/bread_experts_group/api/secure/blob/windows/WindowsSecureDataBlob;", "Lorg/bread_experts_group/api/secure/blob/SecureDataBlob;", "<init>", "()V", "arena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "getArena$bread_server_lib", "()Ljava/lang/foreign/Arena;", "decrypt", "Lkotlin/Function0;", "", "getDecrypt", "()Lkotlin/jvm/functions/Function0;", "setDecrypt", "(Lkotlin/jvm/functions/Function0;)V", "encrypt", "getEncrypt", "setEncrypt", "get", "", "index", "", "Lorg/bread_experts_group/api/secure/blob/SecuredByteArray;", "indices", "Lkotlin/ranges/LongRange;", "set", "b", "", "internallyManagedSegment", "Ljava/lang/foreign/MemorySegment;", "managedSegmentRealSize", "getManagedSegmentRealSize$bread_server_lib", "()J", "setManagedSegmentRealSize$bread_server_lib", "(J)V", "value", "managedSegment", "getManagedSegment$bread_server_lib", "()Ljava/lang/foreign/MemorySegment;", "setManagedSegment$bread_server_lib", "(Ljava/lang/foreign/MemorySegment;)V", "cleanup", "toString", "", "bread_server_lib"})
public final class WindowsSecureDataBlob
extends SecureDataBlob {
    private final Arena arena;
    @NotNull
    private Function0<Unit> decrypt;
    @NotNull
    private Function0<Unit> encrypt;
    @Nullable
    private MemorySegment internallyManagedSegment;
    private long managedSegmentRealSize;

    public WindowsSecureDataBlob() {
        this.getFeatures().add(new WindowsLocalProcessEncryptedSecureDataBlobFeature(this));
        this.getFeatures().add(new WindowsCrossProcessEncryptedSecureDataBlobFeature(this));
        this.getFeatures().add(new WindowsLocalUserEncryptedSecureDataBlobFeature(this));
        this.arena = Arena.ofShared();
        this.decrypt = WindowsSecureDataBlob::decrypt$lambda$0;
        this.encrypt = this.getDecrypt();
    }

    public final Arena getArena$bread_server_lib() {
        return this.arena;
    }

    @Override
    @NotNull
    public Function0<Unit> getDecrypt() {
        return this.decrypt;
    }

    @Override
    public void setDecrypt(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, "<set-?>");
        this.decrypt = function0;
    }

    @Override
    @NotNull
    public Function0<Unit> getEncrypt() {
        return this.encrypt;
    }

    @Override
    public void setEncrypt(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, "<set-?>");
        this.encrypt = function0;
    }

    @Override
    public byte get(long index) {
        this.getDecrypt().invoke();
        byte r2 = this.getManagedSegment$bread_server_lib().get(ValueLayout.JAVA_BYTE, index);
        this.getEncrypt().invoke();
        return r2;
    }

    @Override
    @NotNull
    public SecuredByteArray get(@NotNull LongRange indices) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        this.getDecrypt().invoke();
        byte[] a = this.getManagedSegment$bread_server_lib().asSlice(indices.getFirst(), indices.getLast() - indices.getFirst() + 1L).toArray(ValueLayout.JAVA_BYTE);
        this.getEncrypt().invoke();
        Intrinsics.checkNotNull(a);
        return new SecuredByteArray(a);
    }

    @Override
    public void set(long index, byte b) {
        this.getDecrypt().invoke();
        this.getManagedSegment$bread_server_lib().set(ValueLayout.JAVA_BYTE, index, b);
        this.getEncrypt().invoke();
    }

    @Override
    public void set(long index, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.getDecrypt().invoke();
        MemorySegment.copy(b, 0, this.getManagedSegment$bread_server_lib(), ValueLayout.JAVA_BYTE, index, b.length);
        this.getEncrypt().invoke();
    }

    @Override
    public void set(long index, @NotNull SecuredByteArray b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.set(index, b.getAround());
    }

    @Override
    public void set(@NotNull LongRange indices, byte b) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        this.getDecrypt().invoke();
        this.getManagedSegment$bread_server_lib().asSlice(indices.getFirst(), indices.getLast() - indices.getFirst() + 1L).fill(b);
        this.getEncrypt().invoke();
    }

    public final long getManagedSegmentRealSize$bread_server_lib() {
        return this.managedSegmentRealSize;
    }

    public final void setManagedSegmentRealSize$bread_server_lib(long l) {
        this.managedSegmentRealSize = l;
    }

    @NotNull
    public final MemorySegment getManagedSegment$bread_server_lib() {
        MemorySegment memorySegment = this.internallyManagedSegment;
        if (memorySegment == null) {
            throw new IllegalStateException("The secure data blob has not been initialized");
        }
        return memorySegment;
    }

    public final void setManagedSegment$bread_server_lib(@NotNull MemorySegment value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.internallyManagedSegment != null) {
            throw new IllegalStateException("Secure data blob has already been initialized");
        }
        this.internallyManagedSegment = value.reinterpret(this.arena, arg_0 -> WindowsSecureDataBlob._set_managedSegment_$lambda$0(this, arg_0));
    }

    @Override
    protected void cleanup() {
        this.arena.close();
        Function0 err2 = cleanup.err.1.INSTANCE;
        this.setEncrypt(err2);
        this.setDecrypt(err2);
    }

    @NotNull
    public String toString() {
        return "SecureDataBlob[Windows-specific, " + this.getManagedSegment$bread_server_lib().byteSize() + " bytes (real size " + this.managedSegmentRealSize + " bytes)]";
    }

    private static final Unit decrypt$lambda$0() {
        throw new IllegalStateException("Decryption not initialized");
    }

    private static final void _set_managedSegment_$lambda$0(WindowsSecureDataBlob this$0, MemorySegment it) {
        it.reinterpret(this$0.managedSegmentRealSize).fill((byte)0);
    }
}

