/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.CryptographySystem;
import org.bread_experts_group.api.secure.cryptography.CryptographySystemFeatures;
import org.bread_experts_group.api.secure.cryptography.CryptographySystemProvider;
import org.bread_experts_group.api.secure.cryptography.windows.WindowsBCryptCryptographySystem;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCSHAKEXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCommonHashingKt;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsKMACXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsMACHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsMACSIMDHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsSIMDHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.random.WindowsRandomFeature;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptAlgorithmFlags;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptInterface;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderDescription;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderImageDescription;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderInterfaceDescription;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderMode;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R,\u0010\b\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/WindowsBCryptCryptographySystemProvider;", "Lorg/bread_experts_group/api/secure/cryptography/CryptographySystemProvider;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "providerInterfaceMap", "", "Lorg/bread_experts_group/ffi/windows/bcrypt/WindowsBCryptInterface;", "", "", "", "logger", "Ljava/util/logging/Logger;", "supported", "", "new", "Lorg/bread_experts_group/api/secure/cryptography/CryptographySystem;", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsBCryptCryptographySystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsBCryptCryptographySystemProvider.kt\norg/bread_experts_group/api/secure/cryptography/windows/WindowsBCryptCryptographySystemProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,471:1\n1869#2,2:472\n1285#2,2:474\n1299#2,4:476\n1285#2,2:480\n1299#2,2:482\n1869#2:484\n1870#2:492\n1302#2:493\n382#3,7:485\n*S KotlinDebug\n*F\n+ 1 WindowsBCryptCryptographySystemProvider.kt\norg/bread_experts_group/api/secure/cryptography/windows/WindowsBCryptCryptographySystemProvider\n*L\n40#1:472,2\n46#1:474,2\n46#1:476,4\n47#1:480,2\n47#1:482,2\n67#1:484\n67#1:492\n47#1:493\n69#1:485,7\n*E\n"})
public final class WindowsBCryptCryptographySystemProvider
extends CryptographySystemProvider {
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    @NotNull
    private Map<WindowsBCryptInterface, ? extends Map<String, Set<String>>> providerInterfaceMap = MapsKt.emptyMap();
    @NotNull
    private final Logger logger = ColoredHandler.Companion.newLogger$default(ColoredHandler.Companion, "TMP logger", null, 2, null);

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean supported() {
        boolean bl;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            boolean bl2;
            block19: {
                MethodHandle methodHandle;
                List<String> list;
                Arena arena = (Arena)autoCloseable;
                boolean bl3 = false;
                MemorySegment bufferSz = arena.allocate(WindowsUtilitiesKt.getULONG());
                MemorySegment bufferLoc = arena.allocate(ValueLayout.ADDRESS);
                List<String> $this$supported_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
                boolean bl4 = false;
                if (WindowsBCryptHandlesKt.getNativeBCryptEnumRegisteredProviders() == null) {
                    boolean bl5 = false;
                    return bl5;
                }
                Intrinsics.checkNotNull(bufferSz);
                Intrinsics.checkNotNull(bufferLoc);
                WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, bufferSz, bufferLoc);
                MemorySegment buffer = bufferLoc.get(ValueLayout.ADDRESS, 0L).reinterpret((long)UInt.constructor-impl(bufferSz.get(WindowsUtilitiesKt.getULONG(), 0L)) & 0xFFFFFFFFL, arena, WindowsBCryptCryptographySystemProvider::supported$lambda$0$0$0);
                long count = (long)UInt.constructor-impl(buffer.get(WindowsUtilitiesKt.getULONG(), 0L)) & 0xFFFFFFFFL;
                if (count == 0L) {
                    bl2 = false;
                } else {
                    MemorySegment memorySegment;
                    Object object;
                    Object object2;
                    Iterable $this$associateWithTo$iv$iv;
                    MemorySegment array = buffer.get(ValueLayout.ADDRESS, 8L).reinterpret(ValueLayout.ADDRESS.byteSize() * count);
                    long offset = 0L;
                    Iterable $this$forEach$iv = RangesKt.until(0, count);
                    boolean $i$f$forEach22 = false;
                    Iterator iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        long element$iv = ((LongIterator)iterator2).nextLong();
                        boolean bl6 = false;
                        MemorySegment string = array.get(ValueLayout.ADDRESS, offset);
                        $this$supported_u24lambda_u240_u240.add(string.reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE));
                        offset += ValueLayout.ADDRESS.byteSize();
                    }
                    List<String> readStrings = CollectionsKt.build(list);
                    Iterable $this$associateWith$iv = readStrings;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                    Iterable iterable2 = $this$associateWith$iv;
                    Map destination$iv$iv = result$iv;
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        void it;
                        String $i$f$forEach22 = (String)element$iv$iv;
                        object2 = element$iv$iv;
                        object = destination$iv$iv;
                        boolean bl7 = false;
                        memorySegment = arena.allocateFrom((String)it, Charsets.UTF_16LE);
                        object.put(object2, memorySegment);
                    }
                    Map allocatedStrings = destination$iv$iv;
                    $this$associateWith$iv = WindowsBCryptInterface.getEntries();
                    object = this;
                    $i$f$associateWith = false;
                    result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                    $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    destination$iv$iv = result$iv;
                    $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        WindowsBCryptInterface it = (WindowsBCryptInterface)element$iv$iv;
                        memorySegment = element$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl8 = false;
                        Map functionMap = new LinkedHashMap();
                        for (String providerName : readStrings) {
                            void bcInterface;
                            bufferSz.set(WindowsUtilitiesKt.getULONG(), 0L, 0);
                            bufferLoc.set(ValueLayout.ADDRESS, 0L, MemorySegment.NULL);
                            MethodHandle methodHandle2 = WindowsBCryptHandlesKt.getNativeBCryptQueryProviderRegistration();
                            if (methodHandle2 == null) {
                                bl2 = false;
                                break block19;
                            }
                            Object v = allocatedStrings.get(providerName);
                            Intrinsics.checkNotNull(v);
                            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle2, v, WindowsBCryptProviderMode.CRYPT_ANY.getId-pVg5ArA(), bcInterface.getId-pVg5ArA(), bufferSz, bufferLoc);
                            MemorySegment memorySegment2 = bufferLoc.get(ValueLayout.ADDRESS, 0L).reinterpret((long)UInt.constructor-impl(bufferSz.get(WindowsUtilitiesKt.getULONG(), 0L)) & 0xFFFFFFFFL, arena, WindowsBCryptCryptographySystemProvider::supported$lambda$0$2$0);
                            Intrinsics.checkNotNullExpressionValue(memorySegment2, "reinterpret(...)");
                            WindowsBCryptProviderDescription provider = new WindowsBCryptProviderDescription(memorySegment2);
                            Object object3 = provider.getUserMode();
                            if (object3 == null || (object3 = ((WindowsBCryptProviderImageDescription)object3).getInterfaces()) == null) continue;
                            Iterable $this$forEach$iv2 = (Iterable)object3;
                            boolean $i$f$forEach3 = false;
                            for (Object element$iv : $this$forEach$iv2) {
                                WindowsBCryptProviderInterfaceDescription it2 = (WindowsBCryptProviderInterfaceDescription)element$iv;
                                boolean bl9 = false;
                                for (String function : it2.getBcFunctions()) {
                                    Object object4;
                                    void $this$getOrPut$iv;
                                    Map map = functionMap;
                                    String key$iv = function;
                                    boolean $i$f$getOrPut = false;
                                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                                    if (value$iv == null) {
                                        boolean bl10 = false;
                                        Set answer$iv = new LinkedHashSet();
                                        $this$getOrPut$iv.put(key$iv, answer$iv);
                                        object4 = answer$iv;
                                    } else {
                                        object4 = value$iv;
                                    }
                                    Set aliasMap = (Set)object4;
                                    aliasMap.addAll((Collection)provider.getAliases());
                                    Intrinsics.checkNotNull(providerName);
                                    aliasMap.add(providerName);
                                }
                            }
                        }
                        Map map = functionMap;
                        object2.put((MemorySegment)memorySegment, (Map)map);
                    }
                    ((WindowsBCryptCryptographySystemProvider)object).providerInterfaceMap = destination$iv$iv;
                    boolean bl11 = true;
                    return bl11;
                }
            }
            bl = bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    @Override
    @NotNull
    public CryptographySystem new() {
        WindowsBCryptCryptographySystem system = new WindowsBCryptCryptographySystem();
        system.getExposedFeatures$bread_server_lib().add(new WindowsRandomFeature(CryptographySystemFeatures.INSTANCE.getRANDOM_SYSTEM_PREFERRED(), null));
        block62: for (Map.Entry<WindowsBCryptInterface, ? extends Map<String, Set<String>>> entry : this.providerInterfaceMap.entrySet()) {
            WindowsBCryptInterface iface = entry.getKey();
            Map<String, Set<String>> functions = entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[iface.ordinal()]) {
                case 1: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$0(iface, function));
                    }
                    continue block62;
                }
                case 2: {
                    String function;
                    block64: for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        Set<String> providers = entry2.getValue();
                        switch (function) {
                            case "AES-GMAC": {
                                continue block64;
                            }
                            case "MD2": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2(), WindowsBCryptHandlesKt.getBCRYPT_MD2_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_MD2_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD2_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD2_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "MD4": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4(), WindowsBCryptHandlesKt.getBCRYPT_MD4_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_MD4_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD4_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD4_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "MD5": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5(), WindowsBCryptHandlesKt.getBCRYPT_MD5_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_MD5_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD5_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD5_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA1": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1(), WindowsBCryptHandlesKt.getBCRYPT_SHA1_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA1_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA1_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA1_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256(), WindowsBCryptHandlesKt.getBCRYPT_SHA256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA256_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA256_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA384": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384(), WindowsBCryptHandlesKt.getBCRYPT_SHA384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA384_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA384_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA512": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512(), WindowsBCryptHandlesKt.getBCRYPT_SHA512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA512_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA512_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA3-256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_256_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_256_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA3-384": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_384_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_384_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHA3-512": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_512_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_512_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "SHAKE128": {
                                Arena it = Arena.ofShared();
                                boolean bl = false;
                                String string = (String)CollectionsKt.first((Iterable)providers);
                                Intrinsics.checkNotNull(it);
                                EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_REUSABLE_FLAG);
                                Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
                                MemorySegment algorithm = WindowsCommonHashingKt.createBCryptAlgorithm(function, string, it, enumSet);
                                system.getExposedFeatures$bread_server_lib().add(new WindowsXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHAKE128(), algorithm, it));
                                continue block64;
                            }
                            case "SHAKE256": {
                                Arena it = Arena.ofShared();
                                boolean bl = false;
                                String string = (String)CollectionsKt.first((Iterable)providers);
                                Intrinsics.checkNotNull(it);
                                EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_REUSABLE_FLAG);
                                Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
                                MemorySegment algorithm = WindowsCommonHashingKt.createBCryptAlgorithm(function, string, it, enumSet);
                                system.getExposedFeatures$bread_server_lib().add(new WindowsXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHAKE256(), algorithm, it));
                                continue block64;
                            }
                            case "CSHAKE128": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsCSHAKEXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_CSHAKE128(), WindowsBCryptHandlesKt.getBCRYPT_CSHAKE128_ALG_HANDLE()));
                                continue block64;
                            }
                            case "CSHAKE256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsCSHAKEXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_CSHAKE256(), WindowsBCryptHandlesKt.getBCRYPT_CSHAKE256_ALG_HANDLE()));
                                continue block64;
                            }
                            case "AES-CMAC": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_AES_CMAC(), WindowsBCryptHandlesKt.getBCRYPT_AES_CMAC_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_AES_CMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_AES_CMAC_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "KMAC128": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsKMACXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_KMAC128(), WindowsBCryptHandlesKt.getBCRYPT_KMAC128_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                            case "KMAC256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsKMACXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_KMAC256(), WindowsBCryptHandlesKt.getBCRYPT_KMAC256_ALG_HANDLE(), null, 4, null));
                                continue block64;
                            }
                        }
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$3(iface, function));
                    }
                    continue block62;
                }
                case 3: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$4(iface, function));
                    }
                    continue block62;
                }
                case 4: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$5(iface, function));
                    }
                    continue block62;
                }
                case 5: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$6(iface, function));
                    }
                    continue block62;
                }
                case 6: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    block68: while (iterator2.hasNext()) {
                        switch (function = iterator2.next().getKey()) {
                            case "DUALECRNG": 
                            case "FIPS186DSARNG": {
                                continue block68;
                            }
                            case "RNG": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsRandomFeature(CryptographySystemFeatures.INSTANCE.getRANDOM(), WindowsBCryptHandlesKt.getBCRYPT_RNG_ALG_HANDLE()));
                                continue block68;
                            }
                        }
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$7(iface, function));
                    }
                    continue block62;
                }
                case 7: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$8(iface, function));
                    }
                    continue block62;
                }
                case 8: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$9(iface, function));
                    }
                    continue block62;
                }
                case 9: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$10(iface, function));
                    }
                    continue block62;
                }
                case 10: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$11(iface, function));
                    }
                    continue block62;
                }
                case 11: {
                    String function;
                    Iterator<Map.Entry<String, Set<String>>> iterator2 = functions.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        function = iterator2.next().getKey();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$12(iface, function));
                    }
                    continue block62;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return system;
    }

    private static final void supported$lambda$0$0$0(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptFreeBuffer();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(it);
    }

    private static final void supported$lambda$0$2$0(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptFreeBuffer();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(it);
    }

    private static final String new$lambda$0(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$3(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$4(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$5(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$6(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$7(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$8(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$9(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$10(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$11(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$12(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WindowsBCryptInterface.values().length];
            try {
                nArray[WindowsBCryptInterface.BCRYPT_CIPHER_INTERFACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_HASH_INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_SECRET_AGREEMENT_INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_SIGNATURE_INTERFACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_RNG_INTERFACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_KEY_DERIVATION_INTERFACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_KEY_STORAGE_INTERFACE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_SCHANNEL_INTERFACE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_SCHANNEL_SIGNATURE_INTERFACE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_KEY_PROTECTION_INTERFACE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

