/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.CryptographySystemFeatures;
import org.bread_experts_group.api.secure.cryptography.feature.hash.HashingMACSIMDFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCommonHashingKt;
import org.bread_experts_group.ffi.windows.WindowsNTSTATUSException;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHashOperationType;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptLayoutsKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptMultiOperationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0016J#\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0016\u00a2\u0006\u0002\u0010\"J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001bH\u0016J\u001b\u0010\u001d\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0016\u00a2\u0006\u0002\u0010#J\u001b\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010%J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0016\u00a2\u0006\u0002\u0010&R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsMACSIMDHashingFeature;", "Lorg/bread_experts_group/api/secure/cryptography/feature/hash/HashingMACSIMDFeature;", "expresses", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "algorithm", "Ljava/lang/foreign/MemorySegment;", "arena", "Ljava/lang/foreign/Arena;", "<init>", "(Lorg/bread_experts_group/api/feature/FeatureExpression;Ljava/lang/foreign/MemorySegment;Ljava/lang/foreign/Arena;)V", "getExpresses", "()Lorg/bread_experts_group/api/feature/FeatureExpression;", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "internalHash", "hash", "getHash", "()Ljava/lang/foreign/MemorySegment;", "size", "", "supported", "", "start", "", "key", "", "n", "add", "i", "", "b", "", "([I[[B)V", "([[B)V", "flush", "([I)[[B", "()[[B", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsMACSIMDHashingFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsMACSIMDHashingFeature.kt\norg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsMACSIMDHashingFeature\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,123:1\n13880#2,3:124\n*S KotlinDebug\n*F\n+ 1 WindowsMACSIMDHashingFeature.kt\norg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsMACSIMDHashingFeature\n*L\n61#1:124,3\n*E\n"})
public final class WindowsMACSIMDHashingFeature
extends HashingMACSIMDFeature {
    @NotNull
    private final FeatureExpression<HashingMACSIMDFeature> expresses;
    @NotNull
    private final MemorySegment algorithm;
    @NotNull
    private final Arena arena;
    @NotNull
    private final ImplementationSource source;
    @Nullable
    private MemorySegment internalHash;
    private int size;

    public WindowsMACSIMDHashingFeature(@NotNull FeatureExpression<HashingMACSIMDFeature> expresses, @NotNull MemorySegment algorithm, @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter(expresses, "expresses");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(arena, "arena");
        this.expresses = expresses;
        this.algorithm = algorithm;
        this.arena = arena;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    public /* synthetic */ WindowsMACSIMDHashingFeature(FeatureExpression featureExpression, MemorySegment memorySegment, Arena arena, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Arena arena2 = Arena.ofShared();
            Intrinsics.checkNotNullExpressionValue(arena2, "ofShared(...)");
            arena = arena2;
        }
        this(featureExpression, memorySegment, arena);
    }

    @Override
    @NotNull
    public FeatureExpression<HashingMACSIMDFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    private final MemorySegment getHash() {
        MemorySegment memorySegment = this.internalHash;
        if (memorySegment == null) {
            throw new IllegalStateException("Secret not initialized");
        }
        return memorySegment;
    }

    @Override
    public boolean supported() {
        try {
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            this.start(byArray, 3);
            byArray = new byte[]{4, 5, 6};
            this.add(byArray);
            this.flush();
            this.internalHash = null;
        }
        catch (WindowsNTSTATUSException windowsNTSTATUSException) {
            return false;
        }
        return true;
    }

    @Override
    public void start(@NotNull byte[] key, int n) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (Intrinsics.areEqual(this.getExpresses(), CryptographySystemFeatures.INSTANCE.getHASHING_AES_CMAC_SIMD())) {
            int[] nArray = new int[]{16, 24, 32};
            if (!ArraysKt.contains(nArray, key.length)) {
                throw new IllegalArgumentException("AES-CMAC requires 128/192/256-bit key");
            }
        }
        this.internalHash = WindowsCommonHashingKt.createBCryptMultiHashHandle(this.algorithm, this.arena, n, key);
        this.size = n;
    }

    @Override
    public void add(@NotNull int[] i, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(i, "i");
        Intrinsics.checkNotNullParameter(b, "b");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void add(@NotNull int[] i, @NotNull byte[][] b) {
        Intrinsics.checkNotNullParameter(i, "i");
        Intrinsics.checkNotNullParameter(b, "b");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void add(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            this.getHash();
            if (b.length != this.size) {
                throw new IllegalArgumentException("SIMD input [" + b.length + " element(s)] is not equal to size of operation [" + this.size + "]");
            }
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), b.length);
            byte[] $this$forEachIndexed$iv = b;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (byte item$iv : $this$forEachIndexed$iv) {
                void byteVal;
                int n = index$iv++;
                byte by = item$iv;
                int index = n;
                boolean bl2 = false;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)index, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, index);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_HASH_DATA.getId-pVg5ArA());
                MemorySegment data = tempArena.allocateFrom(ValueLayout.JAVA_BYTE, (byte)byteVal);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, data);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, 1);
            }
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n, allocated, (int)allocated.byteSize(), 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void add(@NotNull byte[][] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public byte[][] flush(@NotNull int[] i) {
        Intrinsics.checkNotNullParameter(i, "i");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[][] flush() {
        Object object;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            int n;
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            this.getHash();
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), this.size);
            Intrinsics.checkNotNull(tempArena);
            int digestLength = WindowsCommonHashingKt.hashGetDigestLength(this.algorithm, tempArena);
            int n2 = 0;
            int n3 = this.size;
            Object object2 = new MemorySegment[n3];
            while (n2 < n3) {
                n = n2++;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)n, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, n);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_FINISH_HASH.getId-pVg5ArA());
                MemorySegment allocated2 = tempArena.allocate(digestLength);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, allocated2);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, digestLength);
                object2[n] = allocated2;
            }
            MemorySegment[] buffers = object2;
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n4 = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n4, allocated, (int)allocated.byteSize(), 0);
            n2 = 0;
            n3 = this.size;
            object2 = new byte[n3][];
            while (n2 < n3) {
                n = n2++;
                byte[] byArray = buffers[n].toArray(ValueLayout.JAVA_BYTE);
                Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                object2[n] = byArray;
            }
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return (byte[][])object;
    }
}

