/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.feature.hash.SIMDHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCommonHashingKt;
import org.bread_experts_group.ffi.windows.WindowsNTSTATUSException;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHashOperationType;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptLayoutsKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptMultiOperationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001b\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J#\u0010\u001b\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001eH\u0016\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001e2\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010$J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001eH\u0016\u00a2\u0006\u0002\u0010%R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsSIMDHashingFeature;", "Lorg/bread_experts_group/api/secure/cryptography/feature/hash/SIMDHashingFeature;", "expresses", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "algorithm", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Lorg/bread_experts_group/api/feature/FeatureExpression;Ljava/lang/foreign/MemorySegment;)V", "getExpresses", "()Lorg/bread_experts_group/api/feature/FeatureExpression;", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "arena", "Ljava/lang/foreign/Arena;", "internalHash", "hash", "getHash", "()Ljava/lang/foreign/MemorySegment;", "size", "", "supported", "", "start", "", "n", "add", "b", "", "", "([[B)V", "i", "", "([I[[B)V", "flush", "([I)[[B", "()[[B", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsSIMDHashingFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSIMDHashingFeature.kt\norg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsSIMDHashingFeature\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,226:1\n13880#2,3:227\n13870#2,3:230\n13000#2,2:233\n13880#2,3:235\n13000#2,2:238\n13870#2,3:240\n13000#2,2:243\n*S KotlinDebug\n*F\n+ 1 WindowsSIMDHashingFeature.kt\norg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsSIMDHashingFeature\n*L\n50#1:227,3\n81#1:230,3\n106#1:233,2\n111#1:235,3\n135#1:238,2\n140#1:240,3\n165#1:243,2\n*E\n"})
public final class WindowsSIMDHashingFeature
extends SIMDHashingFeature {
    @NotNull
    private final FeatureExpression<SIMDHashingFeature> expresses;
    @NotNull
    private final MemorySegment algorithm;
    @NotNull
    private final ImplementationSource source;
    @NotNull
    private final Arena arena;
    @Nullable
    private MemorySegment internalHash;
    private int size;

    public WindowsSIMDHashingFeature(@NotNull FeatureExpression<SIMDHashingFeature> expresses, @NotNull MemorySegment algorithm) {
        Intrinsics.checkNotNullParameter(expresses, "expresses");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this.expresses = expresses;
        this.algorithm = algorithm;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        Arena arena = Arena.ofShared();
        Intrinsics.checkNotNullExpressionValue(arena, "ofShared(...)");
        this.arena = arena;
    }

    @Override
    @NotNull
    public FeatureExpression<SIMDHashingFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    private final MemorySegment getHash() {
        MemorySegment memorySegment = this.internalHash;
        if (memorySegment == null) {
            throw new IllegalStateException("SIMD hashing operation not started");
        }
        return memorySegment;
    }

    @Override
    public boolean supported() {
        try {
            this.start(3);
            byte[] byArray = new byte[]{1, 2, 3};
            this.add(byArray);
            this.flush();
            this.internalHash = null;
        }
        catch (WindowsNTSTATUSException windowsNTSTATUSException) {
            return false;
        }
        return true;
    }

    @Override
    public void start(int n) {
        this.internalHash = WindowsCommonHashingKt.createBCryptMultiHashHandle$default(this.algorithm, this.arena, n, null, 8, null);
        this.size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void add(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            if (b.length != this.size) {
                throw new IllegalArgumentException("SIMD input [" + b.length + " element(s)] is not equal to size of operation [" + this.size + "]");
            }
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), b.length);
            byte[] $this$forEachIndexed$iv = b;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (byte item$iv : $this$forEachIndexed$iv) {
                void byteVal;
                int n = index$iv++;
                byte by = item$iv;
                int index = n;
                boolean bl2 = false;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)index, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, index);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_HASH_DATA.getId-pVg5ArA());
                MemorySegment data = tempArena.allocateFrom(ValueLayout.JAVA_BYTE, (byte)byteVal);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, data);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, 1);
            }
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n, allocated, (int)allocated.byteSize(), 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void add(@NotNull byte[][] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            if (((Object[])b).length != this.size) {
                throw new IllegalArgumentException("SIMD input [" + ((Object[])b).length + " element(s)] is not equal to size of operation [" + this.size + "]");
            }
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), ((Object[])b).length);
            Object[] $this$forEachIndexed$iv = (Object[])b;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void bytes;
                int n = index$iv++;
                byte[] byArray = (byte[])item$iv;
                int index = n;
                boolean bl2 = false;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)index, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, index);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_HASH_DATA.getId-pVg5ArA());
                MemorySegment data = tempArena.allocate(ValueLayout.JAVA_BYTE, ((void)bytes).length);
                MemorySegment.copy(bytes, 0, data, ValueLayout.JAVA_BYTE, 0L, ((void)bytes).length);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, data);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, ((void)bytes).length);
            }
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n, allocated, (int)allocated.byteSize(), 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void add(@NotNull int[] i, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(i, "i");
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            boolean bl;
            Arena tempArena;
            block8: {
                tempArena = (Arena)autoCloseable;
                boolean bl2 = false;
                int[] $this$any$iv = i;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    int element$iv;
                    int it = element$iv = $this$any$iv[j];
                    boolean bl3 = false;
                    if (!(it >= this.size)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (bl) {
                throw new IllegalArgumentException("Index array contains indices out of bounds");
            }
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), b.length);
            byte[] $this$forEachIndexed$iv = b;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (byte item$iv : $this$forEachIndexed$iv) {
                void byteVal;
                int n = index$iv++;
                byte by = item$iv;
                int index = n;
                boolean bl4 = false;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)index, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, i[index]);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_HASH_DATA.getId-pVg5ArA());
                MemorySegment data = tempArena.allocateFrom(ValueLayout.JAVA_BYTE, (byte)byteVal);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, data);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, 1);
            }
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n, allocated, (int)allocated.byteSize(), 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void add(@NotNull int[] i, @NotNull byte[][] b) {
        Intrinsics.checkNotNullParameter(i, "i");
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            boolean bl;
            Arena tempArena;
            block8: {
                tempArena = (Arena)autoCloseable;
                boolean bl2 = false;
                int[] $this$any$iv = i;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    int element$iv;
                    int it = element$iv = $this$any$iv[j];
                    boolean bl3 = false;
                    if (!(it >= this.size)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (bl) {
                throw new IllegalArgumentException("Index array contains indices out of bounds");
            }
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), ((Object[])b).length);
            Object[] $this$forEachIndexed$iv = (Object[])b;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void bytes;
                int n = index$iv++;
                byte[] byArray = (byte[])item$iv;
                int index = n;
                boolean bl4 = false;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)index, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, i[index]);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_HASH_DATA.getId-pVg5ArA());
                MemorySegment data = tempArena.allocate(ValueLayout.JAVA_BYTE, ((void)bytes).length);
                MemorySegment.copy(bytes, 0, data, ValueLayout.JAVA_BYTE, 0L, ((void)bytes).length);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, data);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, ((void)bytes).length);
            }
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n, allocated, (int)allocated.byteSize(), 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[][] flush(@NotNull int[] i) {
        Object object;
        Intrinsics.checkNotNullParameter(i, "i");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            int n;
            boolean bl;
            int n2;
            Arena tempArena;
            block9: {
                tempArena = (Arena)autoCloseable;
                boolean bl2 = false;
                int[] $this$any$iv = i;
                boolean $i$f$any = false;
                n2 = $this$any$iv.length;
                for (int j = 0; j < n2; ++j) {
                    int element$iv;
                    int it = element$iv = $this$any$iv[j];
                    boolean bl3 = false;
                    if (!(it >= this.size)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (bl) {
                throw new IllegalArgumentException("Index array contains indices out of bounds");
            }
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), i.length);
            Intrinsics.checkNotNull(tempArena);
            int digestLength = WindowsCommonHashingKt.hashGetDigestLength(this.algorithm, tempArena);
            n2 = 0;
            int n3 = i.length;
            Object object2 = new MemorySegment[n3];
            while (n2 < n3) {
                n = n2++;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)n, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, i[n]);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_FINISH_HASH.getId-pVg5ArA());
                MemorySegment allocated2 = tempArena.allocate(digestLength);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, allocated2);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, digestLength);
                object2[n] = allocated2;
            }
            MemorySegment[] buffers = object2;
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n4 = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n4, allocated, (int)allocated.byteSize(), 0);
            n2 = 0;
            n3 = i.length;
            object2 = new byte[n3][];
            while (n2 < n3) {
                n = n2++;
                byte[] byArray = buffers[n].toArray(ValueLayout.JAVA_BYTE);
                Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                object2[n] = byArray;
            }
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return (byte[][])object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[][] flush() {
        Object object;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            int n;
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment allocated = tempArena.allocate(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION(), this.size);
            Intrinsics.checkNotNull(tempArena);
            int digestLength = WindowsCommonHashingKt.hashGetDigestLength(this.algorithm, tempArena);
            int n2 = 0;
            int n3 = this.size;
            Object object2 = new MemorySegment[n3];
            while (n2 < n3) {
                n = n2++;
                MemorySegment operation = allocated.asSlice(WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION().byteSize() * (long)n, WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION());
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_iHash().set(operation, 0, n);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_hashOperation().set(operation, 0, WindowsBCryptHashOperationType.BCRYPT_HASH_OPERATION_FINISH_HASH.getId-pVg5ArA());
                MemorySegment allocated2 = tempArena.allocate(digestLength);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_pbBuffer().set(operation, 0, allocated2);
                WindowsBCryptLayoutsKt.getBCRYPT_MULTI_HASH_OPERATION_cbBuffer().set(operation, 0, digestLength);
                object2[n] = allocated2;
            }
            MemorySegment[] buffers = object2;
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptProcessMultiOperations();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Integer n4 = WindowsBCryptMultiOperationType.BCRYPT_OPERATION_TYPE_HASH.getId-pVg5ArA();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, n4, allocated, (int)allocated.byteSize(), 0);
            n2 = 0;
            n3 = this.size;
            object2 = new byte[n3][];
            while (n2 < n3) {
                n = n2++;
                byte[] byArray = buffers[n].toArray(ValueLayout.JAVA_BYTE);
                Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                object2[n] = byArray;
            }
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return (byte[][])object;
    }
}

