/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.FeatureProvider;
import org.bread_experts_group.api.system.feature.SystemFeatureImplementation;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR6\u0010\r\u001a$\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00020\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/api/system/SystemProvider;", "Lorg/bread_experts_group/api/feature/FeatureProvider;", "Lorg/bread_experts_group/api/system/feature/SystemFeatureImplementation;", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "features", "", "getFeatures", "()Ljava/util/List;", "supportedFeatures", "", "Lorg/bread_experts_group/api/feature/FeatureExpression;", "getSupportedFeatures", "()Ljava/util/Map;", "bread_server_lib"})
public final class SystemProvider
implements FeatureProvider<SystemFeatureImplementation<?>> {
    @NotNull
    public static final SystemProvider INSTANCE = new SystemProvider();
    @NotNull
    private static final Logger logger = ColoredHandler.Companion.newLogger$default(ColoredHandler.Companion, "TMP logger", null, 2, null);
    @NotNull
    private static final List<SystemFeatureImplementation<?>> features;
    @NotNull
    private static final Map<FeatureExpression<? extends SystemFeatureImplementation<?>>, List<SystemFeatureImplementation<?>>> supportedFeatures;

    private SystemProvider() {
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return logger;
    }

    @Override
    @NotNull
    public List<SystemFeatureImplementation<?>> getFeatures() {
        return features;
    }

    @Override
    @NotNull
    public Map<FeatureExpression<? extends SystemFeatureImplementation<?>>, List<SystemFeatureImplementation<?>>> getSupportedFeatures() {
        return supportedFeatures;
    }

    static {
        ServiceLoader<SystemFeatureImplementation> serviceLoader = ServiceLoader.load(SystemFeatureImplementation.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
        features = CollectionsKt.toMutableList((Iterable)serviceLoader);
        supportedFeatures = new LinkedHashMap();
    }
}

