/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.io.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.io.feature.IODeviceDataRangeLockFeature;
import org.bread_experts_group.api.system.device.io.feature.lock.IODeviceDataRangeLockHandle;
import org.bread_experts_group.api.system.device.io.lock.IODeviceDataRangeLockFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.lock.WindowsIODeviceDataRangeLockFeatures;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J;\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0014\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/api/system/device/io/windows/WindowsIODeviceDataRangeLockFeature;", "Lorg/bread_experts_group/api/system/device/io/feature/IODeviceDataRangeLockFeature;", "handle", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "acquire", "Lkotlin/Pair;", "Lorg/bread_experts_group/api/system/device/io/feature/lock/IODeviceDataRangeLockHandle;", "", "Lorg/bread_experts_group/api/system/device/io/lock/IODeviceDataRangeLockFeatureIdentifier;", "length", "", "features", "", "(J[Lorg/bread_experts_group/api/system/device/io/lock/IODeviceDataRangeLockFeatureIdentifier;)Lkotlin/Pair;", "bread_server_lib"})
public final class WindowsIODeviceDataRangeLockFeature
extends IODeviceDataRangeLockFeature {
    @NotNull
    private final MemorySegment handle;
    @NotNull
    private final ImplementationSource source;

    public WindowsIODeviceDataRangeLockFeature(@NotNull MemorySegment handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        this.handle = handle;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeLockFileEx() != null && WindowsKernelHandlesKt.getNativeUnlockFileEx() != null;
    }

    @Override
    @NotNull
    public Pair<IODeviceDataRangeLockHandle, List<IODeviceDataRangeLockFeatureIdentifier>> acquire(long length, IODeviceDataRangeLockFeatureIdentifier ... features2) {
        Intrinsics.checkNotNullParameter(features2, "features");
        List supportedFeatures = new ArrayList();
        int flags = 0;
        if (ArraysKt.contains(features2, WindowsIODeviceDataRangeLockFeatures.EXCLUSIVE)) {
            flags |= 2;
            supportedFeatures.add(WindowsIODeviceDataRangeLockFeatures.EXCLUSIVE);
        }
        if (!ArraysKt.contains(features2, WindowsIODeviceDataRangeLockFeatures.WAIT_UNTIL_AVAILABLE)) {
            flags |= 1;
            supportedFeatures.add(WindowsIODeviceDataRangeLockFeatures.WAIT_UNTIL_AVAILABLE);
        }
        Arena arena = Arena.ofConfined();
        MemorySegment overlapped = arena.allocate(WindowsLayoutsKt.getOVERLAPPED());
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeLockFileEx();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, flags, 0, (int)(length & 0xFFFFFFFFL), (int)(length >> 32), overlapped);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return TuplesKt.to(new IODeviceDataRangeLockHandle(this, length, overlapped, arena){
            final /* synthetic */ WindowsIODeviceDataRangeLockFeature this$0;
            final /* synthetic */ long $length;
            final /* synthetic */ MemorySegment $overlapped;
            final /* synthetic */ Arena $arena;
            {
                this.this$0 = $receiver;
                this.$length = $length;
                this.$overlapped = $overlapped;
                this.$arena = $arena;
            }

            public void release() {
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeUnlockFileEx();
                Intrinsics.checkNotNull(methodHandle);
                int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), WindowsIODeviceDataRangeLockFeature.access$getHandle$p(this.this$0), 0, (int)(this.$length & 0xFFFFFFFFL), (int)(this.$length >> 32), this.$overlapped);
                if (status == 0) {
                    WindowsUtilitiesKt.throwLastError();
                    throw new KotlinNothingValueException();
                }
                this.$arena.close();
            }
        }, supportedFeatures);
    }

    public static final /* synthetic */ MemorySegment access$getHandle$p(WindowsIODeviceDataRangeLockFeature $this) {
        return $this.handle;
    }
}

