/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.io.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.io.feature.IODeviceReadFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/bread_experts_group/api/system/device/io/windows/WindowsIODeviceReadFeature;", "Lorg/bread_experts_group/api/system/device/io/feature/IODeviceReadFeature;", "handle", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "read", "", "into", "bread_server_lib"})
public final class WindowsIODeviceReadFeature
extends IODeviceReadFeature {
    @NotNull
    private final MemorySegment handle;
    @NotNull
    private final ImplementationSource source;

    public WindowsIODeviceReadFeature(@NotNull MemorySegment handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        this.handle = handle;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public int read(@NotNull MemorySegment into) {
        Intrinsics.checkNotNullParameter(into, "into");
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadFile();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, into, (int)RangesKt.coerceAtMost(into.byteSize(), Integer.MAX_VALUE), WindowsUtilitiesKt.getThreadLocalDWORD0(), MemorySegment.NULL);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L);
    }
}

