/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.io.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.io.IODevice;
import org.bread_experts_group.api.system.device.io.IODeviceFeatureImplementation;
import org.bread_experts_group.api.system.device.io.feature.IODeviceReopenFeature;
import org.bread_experts_group.api.system.device.io.open.OpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.open.ReOpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.windows.WindowsIODevice;
import org.bread_experts_group.api.system.device.io.windows.WindowsIODeviceReleaseFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceIODeviceFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J3\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/api/system/device/io/windows/WindowsIODeviceReopenFeature;", "Lorg/bread_experts_group/api/system/device/io/feature/IODeviceReopenFeature;", "handle", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "reopen", "Lkotlin/Pair;", "Lorg/bread_experts_group/api/system/device/io/IODevice;", "", "Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;", "features", "", "Lorg/bread_experts_group/api/system/device/io/open/ReOpenIODeviceFeatureIdentifier;", "([Lorg/bread_experts_group/api/system/device/io/open/ReOpenIODeviceFeatureIdentifier;)Lkotlin/Pair;", "bread_server_lib"})
public final class WindowsIODeviceReopenFeature
extends IODeviceReopenFeature {
    @NotNull
    private final MemorySegment handle;
    @NotNull
    private final ImplementationSource source;

    public WindowsIODeviceReopenFeature(@NotNull MemorySegment handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        this.handle = handle;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeReOpenFile() != null;
    }

    @Override
    @NotNull
    public Pair<IODevice, List<OpenIODeviceFeatureIdentifier>> reopen(ReOpenIODeviceFeatureIdentifier ... features2) {
        Intrinsics.checkNotNullParameter(features2, "features");
        List supportedFeatures = new ArrayList();
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReOpenFile();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment handle = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.handle, WindowsSystemDeviceIODeviceFeature.Companion.getDesiredAccessO$bread_server_lib(features2, supportedFeatures), WindowsSystemDeviceIODeviceFeature.Companion.getShareModeO$bread_server_lib(features2, supportedFeatures), WindowsSystemDeviceIODeviceFeature.Companion.getFlags$bread_server_lib(features2, supportedFeatures));
        if (Intrinsics.areEqual(handle, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        WindowsIODevice newDevice = new WindowsIODevice(handle);
        List<IODeviceFeatureImplementation<?>> list = newDevice.getFeatures();
        Cleaner.Cleanable cleanable = newDevice.registerCleaningAction$bread_server_lib(() -> WindowsIODeviceReopenFeature.reopen$lambda$0(handle));
        Intrinsics.checkNotNullExpressionValue(cleanable, "registerCleaningAction(...)");
        list.add(new WindowsIODeviceReleaseFeature(cleanable));
        return TuplesKt.to(newDevice, supportedFeatures);
    }

    private static final Unit reopen$lambda$0(MemorySegment $handle) {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCloseHandle();
        Intrinsics.checkNotNull(methodHandle);
        if (methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), $handle) == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return Unit.INSTANCE;
    }
}

