/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.io.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.io.feature.IODeviceSeekFeature;
import org.bread_experts_group.api.system.device.io.seek.SeekIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.seek.StandardSeekIODeviceFeatures;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J;\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r2\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0013\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/api/system/device/io/windows/WindowsIODeviceSeekFeature;", "Lorg/bread_experts_group/api/system/device/io/feature/IODeviceSeekFeature;", "handle", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "seek", "Lkotlin/Pair;", "", "", "Lorg/bread_experts_group/api/system/device/io/seek/SeekIODeviceFeatureIdentifier;", "n", "features", "", "(J[Lorg/bread_experts_group/api/system/device/io/seek/SeekIODeviceFeatureIdentifier;)Lkotlin/Pair;", "bread_server_lib"})
public final class WindowsIODeviceSeekFeature
extends IODeviceSeekFeature {
    @NotNull
    private final MemorySegment handle;
    @NotNull
    private final ImplementationSource source;

    public WindowsIODeviceSeekFeature(@NotNull MemorySegment handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        this.handle = handle;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeSetFilePointerEx() != null;
    }

    @Override
    @NotNull
    public Pair<Long, List<SeekIODeviceFeatureIdentifier>> seek(long n, SeekIODeviceFeatureIdentifier ... features2) {
        int n2;
        Intrinsics.checkNotNullParameter(features2, "features");
        List supportedFeatures = new ArrayList();
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeSetFilePointerEx();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
        MemorySegment memorySegment2 = WindowsUtilitiesKt.getThreadLocalLARGE_INTEGER0();
        if (ArraysKt.contains(features2, StandardSeekIODeviceFeatures.BEGIN)) {
            supportedFeatures.add(StandardSeekIODeviceFeatures.BEGIN);
            n2 = 0;
        } else if (ArraysKt.contains(features2, StandardSeekIODeviceFeatures.END)) {
            supportedFeatures.add(StandardSeekIODeviceFeatures.END);
            n2 = 2;
        } else {
            supportedFeatures.add(StandardSeekIODeviceFeatures.CURRENT);
            n2 = 1;
        }
        int status = methodHandle.invokeExact(memorySegment, this.handle, n, memorySegment2, n2);
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return TuplesKt.to(WindowsUtilitiesKt.getThreadLocalLARGE_INTEGER0().get(WindowsLayoutsKt.getLARGE_INTEGER(), 0L), CollectionsKt.emptyList());
    }
}

