/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.Flaggable;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.SystemDeviceFeatureImplementation;
import org.bread_experts_group.api.system.device.SystemDeviceFeatures;
import org.bread_experts_group.api.system.device.SystemDeviceType;
import org.bread_experts_group.api.system.device.feature.SystemDeviceBasicIdentifierFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceFriendlyNameFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceSerialPortNameFeature;
import org.bread_experts_group.api.system.device.io.open.OpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceChildrenFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceChildrenStreamsFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceCopyFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceDeleteFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceGetCreationTime;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceGetLastAccessTime;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceGetLastMetadataWriteTime;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceGetLastWriteTime;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceHardLinkFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceIODeviceFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceMoveFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceParentFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDevicePathAppendFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceQueryTransparentEncryptionFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceReplaceFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceSoftLinkFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceTransparentEncryptionDisableFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceTransparentEncryptionEnableFeature;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceTransparentEncryptionRawIODeviceFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.GUID;
import org.bread_experts_group.ffi.windows.WindowsCreationDisposition;
import org.bread_experts_group.ffi.windows.WindowsFileAPILayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsFileInfoByHandleClasses;
import org.bread_experts_group.ffi.windows.WindowsFileSharingTypes;
import org.bread_experts_group.ffi.windows.WindowsKernelBaseHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLastError;
import org.bread_experts_group.ffi.windows.WindowsLastErrorException;
import org.bread_experts_group.ffi.windows.WindowsShlwAPIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMHandlesKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMLayoutsKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMNotifyEventData;
import org.bread_experts_group.ffi.windows.setup.WindowsSetupHandlesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n\u001aK\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0010\u001a\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00120\u0019\u00a2\u0006\u0002\u0010\u001a\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001b"}, d2={"deviceCache", "", "", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "getDeviceCache", "()Ljava/util/Map;", "decodeDevice", "guid", "Lorg/bread_experts_group/ffi/GUID;", "link", "Ljava/lang/foreign/MemorySegment;", "arena", "Ljava/lang/foreign/Arena;", "eventData", "Lorg/bread_experts_group/ffi/windows/cfgmgr/WindowsCMNotifyEventData;", "createPathDevice", "pathSegment", "readFileInfo", "T", "features", "", "Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;", "supportedFeatures", "", "transformer", "Lkotlin/Function1;", "(Ljava/lang/foreign/MemorySegment;[Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "bread_server_lib"})
public final class WindowsDeviceUtilityKt {
    @NotNull
    private static final Map<String, SystemDevice> deviceCache = new LinkedHashMap();

    @NotNull
    public static final Map<String, SystemDevice> getDeviceCache() {
        return deviceCache;
    }

    @NotNull
    public static final SystemDevice decodeDevice(@NotNull GUID guid, @NotNull MemorySegment link, @NotNull Arena arena) {
        Object object;
        block48: {
            Object object2;
            block47: {
                Object friendlyNameArea;
                Object it;
                int status;
                block46: {
                    Intrinsics.checkNotNullParameter(guid, "guid");
                    Intrinsics.checkNotNullParameter(link, "link");
                    Intrinsics.checkNotNullParameter(arena, "arena");
                    WindowsUtilitiesKt.getThreadLocalDWORD1().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
                    status = 0;
                    MethodHandle methodHandle = WindowsCMHandlesKt.getNativeCM_Get_Device_Interface_PropertyW();
                    Intrinsics.checkNotNull(methodHandle);
                    status = methodHandle.invokeExact(link, WindowsCMLayoutsKt.getDEVPKEY_Device_InstanceId(), WindowsUtilitiesKt.getThreadLocalDWORD0(), MemorySegment.NULL, WindowsUtilitiesKt.getThreadLocalDWORD1(), 0);
                    if (status != 26) {
                        String string = "CM Errors a: " + status;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    MemorySegment instanceID = arena.allocate(WindowsUtilitiesKt.getThreadLocalDWORD1().get(WindowsUtilitiesKt.getDWORD(), 0L));
                    status = WindowsCMHandlesKt.getNativeCM_Get_Device_Interface_PropertyW().invokeExact(link, WindowsCMLayoutsKt.getDEVPKEY_Device_InstanceId(), WindowsUtilitiesKt.getThreadLocalDWORD0(), instanceID, WindowsUtilitiesKt.getThreadLocalDWORD1(), 0);
                    String instanceIDString = instanceID.getString(0L, Charsets.UTF_16LE);
                    if (status != 0) {
                        String string = "CM Errors b: " + status;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    object = deviceCache.get(instanceIDString);
                    if (object != null) break block48;
                    it = object2 = new SystemDevice(switch (guid.toString()) {
                        case "{4D1E55B2-F16F-11CF-88CB-001111000030}" -> SystemDeviceType.HUMAN_INTERFACE;
                        case "{86E0D1E0-8089-11D0-9CE4-08003E301F73}" -> SystemDeviceType.SERIAL;
                        case "{53F56307-B6BF-11D0-94F2-00A0C91EFB8B}" -> SystemDeviceType.STORAGE;
                        case "{53F5630D-B6BF-11D0-94F2-00A0C91EFB8B}" -> SystemDeviceType.VOLUME_STORAGE;
                        case "{4AFA3D53-74A7-11D0-BE5E-00A0C9062857}" -> SystemDeviceType.ACPI_POWER_BUTTON;
                        case "{884B96C3-56EF-11D1-BC8C-00A0C91405DD}" -> SystemDeviceType.KEYBOARD;
                        case "{378DE44C-56EF-11D1-BC8C-00A0C91405DD}" -> SystemDeviceType.MOUSE;
                        case "{A5DCBF10-6530-11D2-901F-00C04FB951ED}" -> SystemDeviceType.USB;
                        case "{CAC88484-7515-4C03-82E6-71A87ABAC361}" -> SystemDeviceType.NETWORKED;
                        case "{0850302A-B344-4FDA-9BE9-90576B8D46F0}" -> SystemDeviceType.BLUETOOTH_RADIO;
                        default -> SystemDeviceType.OTHER;
                    });
                    boolean bl = false;
                    deviceCache.put(instanceIDString, (SystemDevice)it);
                    ((SystemDevice)it).getFeatures().add(new WindowsSystemDeviceIODeviceFeature(link));
                    ((SystemDevice)it).getFeatures().add(new SystemDeviceBasicIdentifierFeature(ImplementationSource.SYSTEM_NATIVE, SystemDeviceFeatures.INSTANCE.getSYSTEM_TYPE_IDENTIFIER(), guid));
                    byte[] identityBytes = new byte[(int)link.byteSize()];
                    MemorySegment.copy(link, ValueLayout.JAVA_BYTE, 0L, identityBytes, 0, identityBytes.length);
                    String symLinkString = new String(identityBytes, Charsets.UTF_16LE);
                    ((SystemDevice)it).getFeatures().add(new SystemDeviceBasicIdentifierFeature(ImplementationSource.SYSTEM_NATIVE, SystemDeviceFeatures.INSTANCE.getSYSTEM_IDENTIFIER(), symLinkString));
                    MemorySegment classGuid = guid.allocate(arena);
                    MethodHandle methodHandle2 = WindowsSetupHandlesKt.getNativeSetupDiGetClassDevsW();
                    Intrinsics.checkNotNull(methodHandle2);
                    MemorySegment deviceInfoList = methodHandle2.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), classGuid, instanceID, MemorySegment.NULL, 16);
                    if (Intrinsics.areEqual(deviceInfoList, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
                        WindowsUtilitiesKt.throwLastError();
                        throw new KotlinNothingValueException();
                    }
                    MemorySegment devInfoData = arena.allocate(WindowsCMLayoutsKt.getSP_DEVINFO_DATA());
                    WindowsCMLayoutsKt.getSP_DEVINFO_DATA_cbSize().set(devInfoData, 0, (int)devInfoData.byteSize());
                    MethodHandle methodHandle3 = WindowsSetupHandlesKt.getNativeSetupDiOpenDeviceInfoW();
                    Intrinsics.checkNotNull(methodHandle3);
                    status = methodHandle3.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), deviceInfoList, instanceID, MemorySegment.NULL, 0, devInfoData);
                    if (status == 0) {
                        WindowsUtilitiesKt.throwLastError();
                        throw new KotlinNothingValueException();
                    }
                    try {
                        MethodHandle methodHandle4 = WindowsSetupHandlesKt.getNativeSetupDiGetDevicePropertyW();
                        Intrinsics.checkNotNull(methodHandle4);
                        methodHandle4.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), deviceInfoList, devInfoData, WindowsCMLayoutsKt.getDEVPKEY_Device_FriendlyName(), WindowsUtilitiesKt.getThreadLocalDWORD0(), MemorySegment.NULL, 0, WindowsUtilitiesKt.getThreadLocalDWORD1(), 0);
                        friendlyNameArea = arena.allocate(WindowsUtilitiesKt.getThreadLocalDWORD1().get(WindowsUtilitiesKt.getDWORD(), 0L));
                        status = WindowsSetupHandlesKt.getNativeSetupDiGetDevicePropertyW().invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), deviceInfoList, devInfoData, WindowsCMLayoutsKt.getDEVPKEY_Device_FriendlyName(), WindowsUtilitiesKt.getThreadLocalDWORD0(), (MemorySegment)friendlyNameArea, (int)friendlyNameArea.byteSize(), MemorySegment.NULL, 0);
                        if (status == 0) {
                            WindowsUtilitiesKt.throwLastError();
                            throw new KotlinNothingValueException();
                        }
                        byte[] friendlyNameBytes = new byte[(int)friendlyNameArea.byteSize()];
                        MemorySegment.copy((MemorySegment)friendlyNameArea, ValueLayout.JAVA_BYTE, 0L, friendlyNameBytes, 0, friendlyNameBytes.length);
                        ((SystemDevice)it).getFeatures().add(new SystemDeviceFriendlyNameFeature(new String(friendlyNameBytes, Charsets.UTF_16LE), ImplementationSource.SYSTEM_NATIVE));
                    }
                    catch (WindowsLastErrorException e) {
                        if (e.getError().getEnum() == WindowsLastError.ERROR_NOT_FOUND) break block46;
                        throw e;
                    }
                }
                WindowsUtilitiesKt.getThreadLocalDWORD1().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
                status = WindowsCMHandlesKt.getNativeCM_Get_Device_Interface_PropertyW().invokeExact(link, WindowsCMLayoutsKt.getDEVPKEY_DeviceInterface_Serial_PortName(), WindowsUtilitiesKt.getThreadLocalDWORD0(), MemorySegment.NULL, WindowsUtilitiesKt.getThreadLocalDWORD1(), 0);
                if (status != 37) {
                    try {
                        if (status != 26) {
                            friendlyNameArea = "CM Errors c: " + status;
                            throw new NotImplementedError("An operation is not implemented: " + (String)friendlyNameArea);
                        }
                        MemorySegment serialNameArea = arena.allocate(WindowsUtilitiesKt.getThreadLocalDWORD1().get(WindowsUtilitiesKt.getDWORD(), 0L));
                        status = WindowsCMHandlesKt.getNativeCM_Get_Device_Interface_PropertyW().invokeExact(link, WindowsCMLayoutsKt.getDEVPKEY_DeviceInterface_Serial_PortName(), WindowsUtilitiesKt.getThreadLocalDWORD0(), serialNameArea, WindowsUtilitiesKt.getThreadLocalDWORD1(), 0);
                        if (status != 0) {
                            String e = "CM Errors d: " + status;
                            throw new NotImplementedError("An operation is not implemented: " + e);
                        }
                        List<SystemDeviceFeatureImplementation<?>> list = ((SystemDevice)it).getFeatures();
                        String string = serialNameArea.getString(0L, Charsets.UTF_16LE);
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        list.add(new SystemDeviceSerialPortNameFeature(string, ImplementationSource.SYSTEM_NATIVE));
                    }
                    catch (WindowsLastErrorException e) {
                        if (e.getError().getEnum() == WindowsLastError.ERROR_NOT_FOUND) break block47;
                        throw e;
                    }
                }
            }
            object = object2;
        }
        return object;
    }

    @NotNull
    public static final SystemDevice decodeDevice(@NotNull WindowsCMNotifyEventData eventData, @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter(eventData, "eventData");
        Intrinsics.checkNotNullParameter(arena, "arena");
        if (!(eventData instanceof WindowsCMNotifyEventData.DeviceInterface)) {
            String string = "Filter ... " + eventData.getFilterType();
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return WindowsDeviceUtilityKt.decodeDevice(((WindowsCMNotifyEventData.DeviceInterface)eventData).getGuid(), ((WindowsCMNotifyEventData.DeviceInterface)eventData).getSymbolicLink(), arena);
    }

    @NotNull
    public static final SystemDevice createPathDevice(@NotNull Arena arena, @NotNull MemorySegment pathSegment) {
        SystemDevice systemDevice;
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        SystemDevice it = systemDevice = new SystemDevice(SystemDeviceType.FILE_SYSTEM_ENTRY);
        boolean bl = false;
        MemorySegment safeSegment = pathSegment.asReadOnly();
        MethodHandle methodHandle = WindowsKernelBaseHandlesKt.getNativePathCchRemoveBackslash();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(safeSegment, safeSegment.byteSize() / (long)2);
        if (!(0 <= status ? status < 2 : false)) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        it.registerCleaningAction$bread_server_lib(() -> WindowsDeviceUtilityKt.createPathDevice$lambda$0$0(arena));
        String path = safeSegment.getString(0L, Charsets.UTF_16LE);
        List<SystemDeviceFeatureImplementation<?>> list = it.getFeatures();
        FeatureExpression<SystemDeviceBasicIdentifierFeature> featureExpression = SystemDeviceFeatures.INSTANCE.getSYSTEM_IDENTIFIER();
        Intrinsics.checkNotNull(path);
        list.add(new SystemDeviceBasicIdentifierFeature(ImplementationSource.SYSTEM_NATIVE, featureExpression, path));
        MethodHandle methodHandle2 = WindowsShlwAPIHandlesKt.getNativePathFindFileNameW();
        Intrinsics.checkNotNull(methodHandle2);
        MemorySegment fileNameSegment = methodHandle2.invokeExact(safeSegment);
        String fileName = fileNameSegment.reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE);
        if (!Intrinsics.areEqual(fileNameSegment, safeSegment)) {
            List<SystemDeviceFeatureImplementation<?>> list2 = it.getFeatures();
            Intrinsics.checkNotNull(fileName);
            list2.add(new SystemDeviceFriendlyNameFeature(fileName, ImplementationSource.SYSTEM_NATIVE));
        }
        List<SystemDeviceFeatureImplementation<?>> list3 = it.getFeatures();
        Intrinsics.checkNotNull(safeSegment);
        list3.add(new WindowsSystemDeviceIODeviceFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDevicePathAppendFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceParentFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceChildrenFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceChildrenStreamsFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceCopyFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceDeleteFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceMoveFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceReplaceFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceSoftLinkFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceHardLinkFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceQueryTransparentEncryptionFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceTransparentEncryptionEnableFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceTransparentEncryptionDisableFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceTransparentEncryptionRawIODeviceFeature(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceGetCreationTime(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceGetLastAccessTime(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceGetLastWriteTime(safeSegment));
        it.getFeatures().add(new WindowsSystemDeviceGetLastMetadataWriteTime(safeSegment));
        return systemDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T readFileInfo(@NotNull MemorySegment pathSegment, @NotNull OpenIODeviceFeatureIdentifier[] features2, @NotNull List<OpenIODeviceFeatureIdentifier> supportedFeatures, @NotNull Function1<? super MemorySegment, ? extends T> transformer) {
        T t;
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        Intrinsics.checkNotNullParameter(features2, "features");
        Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
        Intrinsics.checkNotNullParameter(transformer, "transformer");
        Arena arena = Arena.ofConfined();
        MemorySegment ext3 = arena.allocate(WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS());
        WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwSize().set(ext3, 0L, (int)ext3.byteSize());
        WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwFileFlags().set(ext3, 0L, WindowsSystemDeviceIODeviceFeature.Companion.getFlags$bread_server_lib(features2, supportedFeatures));
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCreateFile3();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsFileSharingTypes.FILE_SHARE_READ, (Enum)WindowsFileSharingTypes.FILE_SHARE_WRITE);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        MemorySegment handle = methodHandle.invokeExact(memorySegment, pathSegment, 0, (int)Flaggable.Companion.raw((Collection<? extends Flaggable>)enumSet), WindowsCreationDisposition.OPEN_EXISTING.getId-pVg5ArA(), ext3);
        arena.close();
        if (Intrinsics.areEqual(handle, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        arena = Arena.ofConfined();
        try {
            MemorySegment basicInfo = arena.allocate(WindowsFileAPILayoutsKt.getFILE_BASIC_INFO());
            MethodHandle methodHandle2 = WindowsKernelHandlesKt.getNativeGetFileInformationByHandleEx();
            Intrinsics.checkNotNull(methodHandle2);
            if (methodHandle2.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), handle, WindowsFileInfoByHandleClasses.FileBasicInfo.getId-pVg5ArA(), basicInfo, (int)basicInfo.byteSize()) == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
            Intrinsics.checkNotNull(basicInfo);
            t = transformer.invoke(basicInfo);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            arena.close();
        }
        T transformed = t;
        MethodHandle methodHandle3 = WindowsKernelHandlesKt.getNativeCloseHandle();
        Intrinsics.checkNotNull(methodHandle3);
        if (methodHandle3.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), handle) == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return transformed;
    }

    private static final Unit createPathDevice$lambda$0$0(Arena $arena) {
        $arena.close();
        return Unit.INSTANCE;
    }
}

