/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.ref.Cleaner;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.feature.SystemDeviceChildrenFeature;
import org.bread_experts_group.api.system.device.windows.WindowsDeviceUtilityKt;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceChildrenFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelBaseHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLastError;
import org.bread_experts_group.ffi.windows.WindowsLastErrorException;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceChildrenFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceChildrenFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "cleaner", "Ljava/lang/ref/Cleaner;", "iterator", "", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "bread_server_lib"})
public final class WindowsSystemDeviceChildrenFeature
extends SystemDeviceChildrenFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;
    @NotNull
    private final Cleaner cleaner;

    public WindowsSystemDeviceChildrenFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        Cleaner cleaner = Cleaner.create();
        Intrinsics.checkNotNullExpressionValue(cleaner, "create(...)");
        this.cleaner = cleaner;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeFindFirstFileExW() != null && WindowsKernelBaseHandlesKt.getNativePathCchRemoveBackslash() != null && WindowsKernelBaseHandlesKt.getNativePathCchAppendEx() != null && WindowsKernelHandlesKt.getNativeFindNextFileW() != null && WindowsKernelHandlesKt.getNativeFindClose() != null;
    }

    @Override
    @NotNull
    public Iterator<SystemDevice> iterator() {
        return new Iterator<SystemDevice>(this){
            private final MemorySegment searchHandle;
            private final MemorySegment searchData;
            private final Arena searchArena;
            private boolean nextPrepared;
            final /* synthetic */ WindowsSystemDeviceChildrenFeature this$0;
            {
                MemorySegment sD;
                MemorySegment sH;
                block9: {
                    this.this$0 = $receiver;
                    this.searchArena = Arena.ofConfined();
                    sH = null;
                    sD = null;
                    try {
                        MemorySegment memorySegment = this.searchArena.allocate(WindowsLayoutsKt.getWIN32_FIND_DATAW());
                        Intrinsics.checkNotNullExpressionValue(memorySegment, "allocate(...)");
                        sD = memorySegment;
                        AutoCloseable autoCloseable = Arena.ofConfined();
                        Throwable throwable = null;
                        try {
                            Arena tempArena = (Arena)autoCloseable;
                            boolean bl = false;
                            MemorySegment wildcard = tempArena.allocate(WindowsSystemDeviceChildrenFeature.access$getPathSegment$p($receiver).byteSize() + (long)4).copyFrom(WindowsSystemDeviceChildrenFeature.access$getPathSegment$p($receiver));
                            MemorySegment append = tempArena.allocateFrom("\\*", Charsets.UTF_16LE);
                            MethodHandle methodHandle = WindowsKernelBaseHandlesKt.getNativePathCchAppendEx();
                            Intrinsics.checkNotNull(methodHandle);
                            WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(wildcard, wildcard.byteSize() / (long)2, append, 3));
                            MethodHandle methodHandle2 = WindowsKernelHandlesKt.getNativeFindFirstFileExW();
                            Intrinsics.checkNotNull(methodHandle2);
                            sH = methodHandle2.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), wildcard, 0, sD, 0, MemorySegment.NULL, 0);
                            if (Intrinsics.areEqual(sH, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
                                WindowsUtilitiesKt.throwLastError();
                                throw new KotlinNothingValueException();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        WindowsSystemDeviceChildrenFeature.access$getCleaner$p($receiver).register(this, () -> iterator.1._init_$lambda$1(this));
                        this.nextPrepared = true;
                    }
                    catch (WindowsLastErrorException e) {
                        this.nextPrepared = false;
                        this.searchArena.close();
                        MemorySegment memorySegment = MemorySegment.NULL;
                        Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
                        sH = memorySegment;
                        MemorySegment memorySegment2 = MemorySegment.NULL;
                        Intrinsics.checkNotNullExpressionValue(memorySegment2, "NULL");
                        sD = memorySegment2;
                        if (e.getError().getEnum() == WindowsLastError.ERROR_DIRECTORY) break block9;
                        throw e;
                    }
                }
                this.searchHandle = sH;
                this.searchData = sD;
            }

            private final void cleanup() {
                this.nextPrepared = false;
                this.searchArena.close();
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeFindClose();
                Intrinsics.checkNotNull(methodHandle);
                int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.searchHandle);
                if (status == 0) {
                    WindowsUtilitiesKt.throwLastError();
                    throw new KotlinNothingValueException();
                }
            }

            private final void advance() {
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeFindNextFileW();
                Intrinsics.checkNotNull(methodHandle);
                int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.searchHandle, this.searchData);
                if (status == 0) {
                    if (WindowsUtilitiesKt.getWin32LastError() == WindowsLastError.ERROR_NO_MORE_FILES.getId-pVg5ArA()) {
                        this.cleanup();
                    } else {
                        WindowsUtilitiesKt.throwLastError();
                        throw new KotlinNothingValueException();
                    }
                }
            }

            public boolean hasNext() {
                return this.nextPrepared;
            }

            public SystemDevice next() {
                if (!this.nextPrepared) {
                    throw new IllegalStateException();
                }
                MemorySegment fileName = WindowsLayoutsKt.getWIN32_FIND_DATAW_cFileName().invokeExact(this.searchData, 0L);
                if (fileName.getAtIndex(ValueLayout.JAVA_SHORT, 0L) == 46) {
                    short s = fileName.getAtIndex(ValueLayout.JAVA_SHORT, 1L);
                    if (s == 46) {
                        if (fileName.getAtIndex(ValueLayout.JAVA_SHORT, 2L) == 0) {
                            this.advance();
                            return this.next();
                        }
                    } else if (s == 0) {
                        this.advance();
                        return this.next();
                    }
                }
                Arena pathArena = Arena.ofShared();
                MemorySegment fullPath = pathArena.allocate(WindowsSystemDeviceChildrenFeature.access$getPathSegment$p(this.this$0).byteSize() + fileName.byteSize() + (long)4);
                fullPath.copyFrom(WindowsSystemDeviceChildrenFeature.access$getPathSegment$p(this.this$0));
                MethodHandle methodHandle = WindowsKernelBaseHandlesKt.getNativePathCchAppendEx();
                Intrinsics.checkNotNull(methodHandle);
                WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(fullPath, fullPath.byteSize() / (long)2, fileName, 3));
                this.advance();
                Intrinsics.checkNotNull(pathArena);
                Intrinsics.checkNotNull(fullPath);
                return WindowsDeviceUtilityKt.createPathDevice(pathArena, fullPath);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            private static final void _init_$lambda$1(iterator.1 this$0) {
                this$0.cleanup();
            }
        };
    }

    public static final /* synthetic */ Cleaner access$getCleaner$p(WindowsSystemDeviceChildrenFeature $this) {
        return $this.cleaner;
    }

    public static final /* synthetic */ MemorySegment access$getPathSegment$p(WindowsSystemDeviceChildrenFeature $this) {
        return $this.pathSegment;
    }
}

