/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.FeatureProvider;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.SystemDeviceFeatures;
import org.bread_experts_group.api.system.device.copy.CopySystemDeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.copy.WindowsCopySystemDeviceFeatures;
import org.bread_experts_group.api.system.device.feature.SystemDeviceBasicIdentifierFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceCopyFeature;
import org.bread_experts_group.api.system.device.feature.copy.SystemDeviceCopyFeatureImplementation;
import org.bread_experts_group.api.system.device.feature.copy.SystemDeviceCopyHandle;
import org.bread_experts_group.api.system.device.feature.copy.feature.routine.CopyProgressRoutineFeature;
import org.bread_experts_group.api.system.device.feature.copy.feature.routine.CopyProgressRoutineFeatureImplementation;
import org.bread_experts_group.api.system.device.feature.copy.feature.routine.CopyProgressRoutineFeatures;
import org.bread_experts_group.api.system.device.feature.copy.feature.routine.WindowsCopyProgressRoutineReturns;
import org.bread_experts_group.api.system.device.feature.copy.feature.routine.feature.CopyProgressRoutineNumericBytesFeature;
import org.bread_experts_group.api.system.device.feature.copy.feature.routine.feature.CopyProgressRoutineSystemIdentifierFeature;
import org.bread_experts_group.api.system.device.feature.copy.feature.windows.WindowsSystemDeviceCopyProgressRoutineFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceCopyFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceCopyFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "copy", "Lorg/bread_experts_group/api/system/device/feature/copy/SystemDeviceCopyHandle;", "destination", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "bread_server_lib"})
public final class WindowsSystemDeviceCopyFeature
extends SystemDeviceCopyFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDeviceCopyFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeCopyFile2() != null;
    }

    @Override
    @NotNull
    public SystemDeviceCopyHandle copy(@NotNull SystemDevice destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        return new SystemDeviceCopyHandle(destination, this){
            private final WindowsSystemDeviceCopyProgressRoutineFeature rtFeature;
            private final List<SystemDeviceCopyFeatureImplementation<?>> features;
            final /* synthetic */ SystemDevice $destination;
            final /* synthetic */ WindowsSystemDeviceCopyFeature this$0;
            {
                this.$destination = $destination;
                this.this$0 = $receiver;
                this.rtFeature = new WindowsSystemDeviceCopyProgressRoutineFeature();
                SystemDeviceCopyFeatureImplementation[] systemDeviceCopyFeatureImplementationArray = new SystemDeviceCopyFeatureImplementation[]{this.rtFeature};
                this.features = CollectionsKt.mutableListOf(systemDeviceCopyFeatureImplementationArray);
            }

            public List<SystemDeviceCopyFeatureImplementation<?>> getFeatures() {
                return this.features;
            }

            public final int progressRoutine(MemorySegment copyMessage, MemorySegment context) {
                Intrinsics.checkNotNullParameter(copyMessage, "copyMessage");
                Intrinsics.checkNotNullParameter(context, "context");
                Function1<FeatureProvider<CopyProgressRoutineFeatureImplementation<?>>, List<CopyProgressRoutineFeature>> routine = this.rtFeature.getRoutine();
                if (routine != null) {
                    List features2 = new ArrayList<E>();
                    MemorySegment copyMessageSegment = copyMessage.reinterpret(WindowsLayoutsKt.getCOPYFILE2_MESSAGE().byteSize());
                    Object object = WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Type().get(copyMessageSegment, 0L);
                    if (Intrinsics.areEqual(object, (Object)1)) {
                        MemorySegment info = WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Info().invokeExact(copyMessageSegment, 0L);
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkStarted_dwStreamNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getCHUNK_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkStarted_uliChunkNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getCHUNK_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkStarted_uliChunkSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkStarted_uliStreamSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkStarted_uliTotalFileSize().get(info, 0L)));
                    } else if (Intrinsics.areEqual(object, (Object)2)) {
                        MemorySegment info = WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Info().invokeExact(copyMessageSegment, 0L);
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_dwStreamNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getCHUNK_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_uliChunkNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getCHUNK_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_uliChunkSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_uliStreamSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_uliStreamBytesTransferred().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_uliTotalFileSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_ChunkFinished_uliTotalBytesTransferred().get(info, 0L)));
                    } else if (Intrinsics.areEqual(object, (Object)3)) {
                        MemorySegment info = WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Info().invokeExact(copyMessageSegment, 0L);
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamStarted_dwStreamNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamStarted_uliTotalFileSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamStarted_uliStreamSize().get(info, 0L)));
                    } else if (Intrinsics.areEqual(object, (Object)4)) {
                        MemorySegment info = WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Info().invokeExact(copyMessageSegment, 0L);
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamFinished_dwStreamNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamFinished_uliStreamSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamFinished_uliStreamBytesTransferred().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamFinished_uliTotalFileSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_StreamFinished_uliTotalBytesTransferred().get(info, 0L)));
                    } else if (Intrinsics.areEqual(object, (Object)6)) {
                        MemorySegment info = WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Info().invokeExact(copyMessageSegment, 0L);
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getCOPY_PHASE_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_CopyPhase().get(info, 0L)));
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_dwStreamNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getERROR_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_hrFailure().get(info, 0L)));
                        features2.add(new CopyProgressRoutineSystemIdentifierFeature(CopyProgressRoutineFeatures.INSTANCE.getCHUNK_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_uliChunkNumber().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_uliStreamSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_uliStreamBytesTransferred().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_uliTotalFileSize().get(info, 0L)));
                        features2.add(new CopyProgressRoutineNumericBytesFeature(CopyProgressRoutineFeatures.INSTANCE.getTOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, WindowsLayoutsKt.getCOPYFILE2_MESSAGE_Error_uliTotalBytesTransferred().get(info, 0L)));
                    }
                    List<CopyProgressRoutineFeature> actions2 = routine.invoke(new FeatureProvider<CopyProgressRoutineFeatureImplementation<?>>(features2){
                        private final Map<FeatureExpression<? extends CopyProgressRoutineFeatureImplementation<?>>, List<CopyProgressRoutineFeatureImplementation<?>>> supportedFeatures;
                        private final List<CopyProgressRoutineFeatureImplementation<?>> features;
                        {
                            this.supportedFeatures = new LinkedHashMap<K, V>();
                            this.features = $features;
                        }

                        public Logger getLogger() {
                            String string = "Not yet implemented";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }

                        public Map<FeatureExpression<? extends CopyProgressRoutineFeatureImplementation<?>>, List<CopyProgressRoutineFeatureImplementation<?>>> getSupportedFeatures() {
                            return this.supportedFeatures;
                        }

                        public List<CopyProgressRoutineFeatureImplementation<?>> getFeatures() {
                            return this.features;
                        }
                    });
                    return actions2.contains(WindowsCopyProgressRoutineReturns.STOP_COPY_AND_DELETE_DESTINATION) ? 1 : (actions2.contains(WindowsCopyProgressRoutineReturns.STOP_COPY_AND_RETAIN_DESTINATION) ? 2 : (actions2.contains(WindowsCopyProgressRoutineReturns.STOP_CALLING_ROUTINE) ? 3 : 0));
                }
                return 0;
            }

            public List<CopySystemDeviceFeatureIdentifier> start(CopySystemDeviceFeatureIdentifier ... features2) {
                MemorySegment memorySegment;
                Intrinsics.checkNotNullParameter(features2, "features");
                List supportedFeatures = new ArrayList<E>();
                Arena arena = Arena.ofConfined();
                Object object = ((SystemDeviceBasicIdentifierFeature)FeatureProvider.get$default(this.$destination, SystemDeviceFeatures.INSTANCE.getSYSTEM_IDENTIFIER(), false, 2, null)).getIdentity();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                MemorySegment destinationSegment = arena.allocateFrom((String)object, Charsets.UTF_16LE);
                if (!(features2.length == 0)) {
                    MemorySegment p = arena.allocate(WindowsLayoutsKt.getCOPYFILE2_EXTENDED_PARAMETERS_V2());
                    WindowsLayoutsKt.getCOPYFILE2_EXTENDED_PARAMETERS_V2_dwSize().set(p, 0L, (int)p.byteSize());
                    int flags = 0;
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.FAIL_IF_DESTINATION_EXISTS)) {
                        flags |= 1;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.FAIL_IF_DESTINATION_EXISTS);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.RESTARTABLE)) {
                        flags |= 2;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.RESTARTABLE);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.OPEN_SOURCE_FOR_WRITE)) {
                        flags |= 4;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.OPEN_SOURCE_FOR_WRITE);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.ALLOW_UNENCRYPTED_DESTINATION)) {
                        flags |= 8;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.ALLOW_UNENCRYPTED_DESTINATION);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.DIRECTORY)) {
                        flags |= 0x80;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.DIRECTORY);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.COPY_SYMBOLIC_LINK)) {
                        flags |= 0x800;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.COPY_SYMBOLIC_LINK);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.DISABLE_SYSTEM_CACHE)) {
                        flags |= 0x1000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.DISABLE_SYSTEM_CACHE);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.RESUME_FROM_RESTART)) {
                        flags |= 0x4000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.RESUME_FROM_RESTART);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.IGNORE_ALT_STREAMS)) {
                        flags |= 0x8000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.IGNORE_ALT_STREAMS);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.DISABLE_WINDOWS_COPY_OFFLOAD)) {
                        flags |= 0x40000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.DISABLE_WINDOWS_COPY_OFFLOAD);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.ALWAYS_COPY_REPARSE_POINT)) {
                        flags |= 0x200000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.ALWAYS_COPY_REPARSE_POINT);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.NO_BLOCK_DESTINATION_ENCRYPT)) {
                        flags |= 0x400000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.NO_BLOCK_DESTINATION_ENCRYPT);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.IGNORE_SOURCE_ENCRYPTION)) {
                        flags |= 0x800000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.IGNORE_SOURCE_ENCRYPTION);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.NO_DESTINATION_WRITE_DAC)) {
                        flags |= 0x2000000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.NO_DESTINATION_WRITE_DAC);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.DISABLE_PRE_ALLOCATION)) {
                        flags |= 0x4000000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.DISABLE_PRE_ALLOCATION);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.LOW_SPACE_FREE_MODE)) {
                        flags |= 0x8000000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.LOW_SPACE_FREE_MODE);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.COMPRESS_OVER_LINK)) {
                        flags |= 0x10000000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.COMPRESS_OVER_LINK);
                    }
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.SPARSENESS)) {
                        flags |= 0x20000000;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.SPARSENESS);
                    }
                    WindowsLayoutsKt.getCOPYFILE2_EXTENDED_PARAMETERS_V2_dwCopyFlags().set(p, 0L, flags);
                    flags = 0;
                    if (ArraysKt.contains(features2, WindowsCopySystemDeviceFeatures.DISABLE_COPY_JUNCTIONS)) {
                        flags |= 1;
                        supportedFeatures.add(WindowsCopySystemDeviceFeatures.DISABLE_COPY_JUNCTIONS);
                    }
                    WindowsLayoutsKt.getCOPYFILE2_EXTENDED_PARAMETERS_V2_dwCopyFlagsV2().set(p, 0L, flags);
                    Object[] objectArray = new Class[]{MemorySegment.class};
                    MethodHandle methodHandle = MethodHandles.lookup().findSpecial(this.getClass(), "progressRoutine", MethodType.methodType(Integer.TYPE, MemorySegment.class, objectArray), this.getClass()).bindTo(this);
                    objectArray = new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS};
                    WindowsLayoutsKt.getCOPYFILE2_EXTENDED_PARAMETERS_V2_pProgressRoutine().set(p, 0L, ForeignFunctionInterfaceKt.getNativeLinker().upcallStub(methodHandle, FunctionDescriptor.of(ValueLayout.JAVA_INT, (MemoryLayout[])objectArray), arena, new Linker.Option[0]));
                    memorySegment = p;
                } else {
                    memorySegment = MemorySegment.NULL;
                }
                MemorySegment extraParameters = memorySegment;
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCopyFile2();
                Intrinsics.checkNotNull(methodHandle);
                WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(WindowsSystemDeviceCopyFeature.access$getPathSegment$p(this.this$0), destinationSegment, extraParameters));
                arena.close();
                return supportedFeatures;
            }
        };
    }

    public static final /* synthetic */ MemorySegment access$getPathSegment$p(WindowsSystemDeviceCopyFeature $this) {
        return $this.pathSegment;
    }
}

