/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.delete.DeleteSystemDeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.delete.StandardDeleteSystemDeviceFeatures;
import org.bread_experts_group.api.system.device.feature.SystemDeviceDeleteFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0010\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceDeleteFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceDeleteFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "delete", "", "Lorg/bread_experts_group/api/system/device/delete/DeleteSystemDeviceFeatureIdentifier;", "features", "", "([Lorg/bread_experts_group/api/system/device/delete/DeleteSystemDeviceFeatureIdentifier;)Ljava/util/List;", "bread_server_lib"})
public final class WindowsSystemDeviceDeleteFeature
extends SystemDeviceDeleteFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDeviceDeleteFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeDeleteFile2W() != null && WindowsKernelHandlesKt.getNativeRemoveDirectoryW() != null;
    }

    @Override
    @NotNull
    public List<DeleteSystemDeviceFeatureIdentifier> delete(DeleteSystemDeviceFeatureIdentifier ... features2) {
        Intrinsics.checkNotNullParameter(features2, "features");
        List supportedFeatures = new ArrayList();
        if (ArraysKt.contains(features2, StandardDeleteSystemDeviceFeatures.DIRECTORY)) {
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeRemoveDirectoryW();
            Intrinsics.checkNotNull(methodHandle);
            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment);
            if (status == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
            supportedFeatures.add(StandardDeleteSystemDeviceFeatures.DIRECTORY);
        } else {
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeDeleteFile2W();
            Intrinsics.checkNotNull(methodHandle);
            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment, 0);
            if (status == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
        }
        return supportedFeatures;
    }
}

