/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.SystemDeviceType;
import org.bread_experts_group.api.system.device.feature.SystemDeviceEnumerationFeature;
import org.bread_experts_group.api.system.device.windows.WindowsDeviceUtilityKt;
import org.bread_experts_group.ffi.GUID;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMHandlesKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMLayoutsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceEnumerationFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceEnumerationFeature;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "enumerate", "", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "type", "Lorg/bread_experts_group/api/system/device/SystemDeviceType;", "bread_server_lib"})
public final class WindowsSystemDeviceEnumerationFeature
extends SystemDeviceEnumerationFeature {
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<SystemDevice> enumerate(@Nullable SystemDeviceType type) {
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            long size;
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MethodHandle methodHandle = WindowsCMHandlesKt.getNativeCM_Get_Device_Interface_List_SizeW();
            Intrinsics.checkNotNull(methodHandle);
            int status = methodHandle.invokeExact(WindowsUtilitiesKt.getThreadLocalDWORD0(), WindowsCMLayoutsKt.getGUID_DEVINTERFACE_COMPORT_Segment(), MemorySegment.NULL, 0);
            if (status != 0) {
                String string = "CM Errors " + status;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            MemorySegment buffer = tempArena.allocate((long)WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L) * WindowsUtilitiesKt.getWCHAR().byteSize());
            MethodHandle methodHandle2 = WindowsCMHandlesKt.getNativeCM_Get_Device_Interface_ListW();
            Intrinsics.checkNotNull(methodHandle2);
            status = methodHandle2.invokeExact(WindowsCMLayoutsKt.getGUID_DEVINTERFACE_COMPORT_Segment(), MemorySegment.NULL, buffer, (int)buffer.byteSize(), 0);
            if (status != 0) {
                String string = "CM Errors " + status;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            List list = new ArrayList();
            for (long offset = 0L; offset < buffer.byteSize(); offset += size) {
                size = 0L;
                while (offset + size < buffer.byteSize()) {
                    short s = buffer.get(WindowsUtilitiesKt.getWCHAR(), offset + size);
                    size += (long)2;
                    if (s != 0) continue;
                }
                if (size == 2L) break;
                GUID gUID = WindowsCMLayoutsKt.getGUID_DEVINTERFACE_COMPORT();
                MemorySegment memorySegment = buffer.asSlice(offset, size);
                Intrinsics.checkNotNullExpressionValue(memorySegment, "asSlice(...)");
                Intrinsics.checkNotNull(tempArena);
                list.add(WindowsDeviceUtilityKt.decodeDevice(gUID, memorySegment, tempArena));
            }
            Iterable iterable2 = list;
            return iterable2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

