/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.MemorySegment;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDeviceFeatures;
import org.bread_experts_group.api.system.device.feature.SystemDeviceGetTimeFeature;
import org.bread_experts_group.api.system.device.io.open.OpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.windows.WindowsDeviceUtilityKt;
import org.bread_experts_group.ffi.windows.WindowsFileAPILayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J3\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceGetLastWriteTime;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceGetTimeFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "supported", "", "getTime", "Lkotlin/Pair;", "Ljava/time/Instant;", "", "Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;", "features", "", "([Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;)Lkotlin/Pair;", "bread_server_lib"})
public final class WindowsSystemDeviceGetLastWriteTime
extends SystemDeviceGetTimeFeature {
    @NotNull
    private final MemorySegment pathSegment;

    public WindowsSystemDeviceGetLastWriteTime(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        super(ImplementationSource.SYSTEM_NATIVE, SystemDeviceFeatures.INSTANCE.getPATH_GET_LAST_WRITE_TIME());
        this.pathSegment = pathSegment;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeCreateFile3() != null && WindowsKernelHandlesKt.getNativeCloseHandle() != null && WindowsKernelHandlesKt.getNativeGetFileInformationByHandleEx() != null;
    }

    @Override
    @NotNull
    public Pair<Instant, List<OpenIODeviceFeatureIdentifier>> getTime(OpenIODeviceFeatureIdentifier ... features2) {
        Intrinsics.checkNotNullParameter(features2, "features");
        List supportedFeatures = new ArrayList();
        return TuplesKt.to(WindowsDeviceUtilityKt.readFileInfo(this.pathSegment, features2, supportedFeatures, WindowsSystemDeviceGetLastWriteTime::getTime$lambda$0), supportedFeatures);
    }

    private static final Instant getTime$lambda$0(MemorySegment it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Instant.ofEpochMilli(WindowsUtilitiesKt.FILETIMEToUnixMs(WindowsFileAPILayoutsKt.getFILE_BASIC_INFO_LastWriteTime().get(it, 0L)));
    }
}

