/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.feature.SystemDeviceIODeviceFeature;
import org.bread_experts_group.api.system.device.io.IODevice;
import org.bread_experts_group.api.system.device.io.IODeviceFeatureImplementation;
import org.bread_experts_group.api.system.device.io.open.FileIOOpenFeatures;
import org.bread_experts_group.api.system.device.io.open.FileIOReOpenFeatures;
import org.bread_experts_group.api.system.device.io.open.OpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.open.ReOpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.open.StandardIOOpenFeatures;
import org.bread_experts_group.api.system.device.io.open.WindowsIOOpenAttributeFeatures;
import org.bread_experts_group.api.system.device.io.open.WindowsIOOpenFeatures;
import org.bread_experts_group.api.system.device.io.open.WindowsIOReOpenFeatures;
import org.bread_experts_group.api.system.device.io.windows.WindowsIODevice;
import org.bread_experts_group.api.system.device.io.windows.WindowsIODeviceReleaseFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsCreationDisposition;
import org.bread_experts_group.ffi.windows.WindowsFileAPILayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsFileSharingTypes;
import org.bread_experts_group.ffi.windows.WindowsGenericAccessRights;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLastError;
import org.bread_experts_group.ffi.windows.WindowsLastErrorException;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J5\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\r2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceIODeviceFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceIODeviceFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "open", "Lkotlin/Pair;", "Lorg/bread_experts_group/api/system/device/io/IODevice;", "", "Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;", "features", "", "([Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;)Lkotlin/Pair;", "Companion", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsSystemDeviceIODeviceFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSystemDeviceIODeviceFeature.kt\norg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceIODeviceFeature\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,285:1\n12970#2,2:286\n*S KotlinDebug\n*F\n+ 1 WindowsSystemDeviceIODeviceFeature.kt\norg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceIODeviceFeature\n*L\n196#1:286,2\n*E\n"})
public final class WindowsSystemDeviceIODeviceFeature
extends SystemDeviceIODeviceFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDeviceIODeviceFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeCreateFile3() != null && WindowsKernelHandlesKt.getNativeCloseHandle() != null && WindowsKernelHandlesKt.getNativeCreateDirectory2W() != null;
    }

    @Override
    @Nullable
    public Pair<IODevice, List<OpenIODeviceFeatureIdentifier>> open(OpenIODeviceFeatureIdentifier ... features2) {
        MemorySegment memorySegment;
        Arena ePA;
        boolean bl;
        WindowsCreationDisposition creationDisposition;
        int shareMode;
        int desiredAccess;
        List supportedFeatures;
        block36: {
            Intrinsics.checkNotNullParameter(features2, "features");
            supportedFeatures = new ArrayList();
            desiredAccess = Companion.getDesiredAccessO$bread_server_lib(features2, supportedFeatures);
            shareMode = Companion.getShareModeO$bread_server_lib(features2, supportedFeatures);
            if (ArraysKt.contains(features2, StandardIOOpenFeatures.DIRECTORY)) {
                Ref.ObjectRef handle;
                block35: {
                    Arena ePA2 = Arena.ofConfined();
                    MemorySegment parameters = ePA2.allocate(WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS());
                    WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwSize().set(parameters, 0L, (int)parameters.byteSize());
                    WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwFileFlags().set(parameters, 0L, Companion.getFlags$bread_server_lib(features2, supportedFeatures));
                    handle = new Ref.ObjectRef();
                    MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCreateFile3();
                    Intrinsics.checkNotNull(methodHandle);
                    handle.element = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment, desiredAccess, shareMode, WindowsCreationDisposition.OPEN_EXISTING.getId-pVg5ArA(), parameters);
                    try {
                        if (Intrinsics.areEqual(handle.element, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
                            WindowsUtilitiesKt.throwLastError();
                            throw new KotlinNothingValueException();
                        }
                        ePA2.close();
                    }
                    catch (WindowsLastErrorException e) {
                        WindowsLastError windowsLastError = e.getError().getEnum();
                        if ((windowsLastError == null ? -1 : WhenMappings.$EnumSwitchMapping$0[windowsLastError.ordinal()]) == 1) {
                            if (ArraysKt.contains(features2, StandardIOOpenFeatures.CREATE)) {
                                int directoryFlags = 0;
                                if (ArraysKt.contains(features2, WindowsIOOpenFeatures.DISABLE_REDIRECTION)) {
                                    directoryFlags |= 1;
                                    supportedFeatures.add(WindowsIOOpenFeatures.DISABLE_REDIRECTION);
                                }
                                MethodHandle methodHandle2 = WindowsKernelHandlesKt.getNativeCreateDirectory2W();
                                Intrinsics.checkNotNull(methodHandle2);
                                handle.element = methodHandle2.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment, 0x100021, shareMode, directoryFlags, MemorySegment.NULL);
                                if (Intrinsics.areEqual(handle.element, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
                                    WindowsUtilitiesKt.throwLastError();
                                    throw new KotlinNothingValueException();
                                }
                                supportedFeatures.add(StandardIOOpenFeatures.CREATE);
                            }
                            ePA2.close();
                            return null;
                        }
                        if (!Intrinsics.areEqual(handle.element, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) break block35;
                        ePA2.close();
                        throw e;
                    }
                }
                supportedFeatures.add(StandardIOOpenFeatures.DIRECTORY);
                WindowsIODevice newDevice = new WindowsIODevice((MemorySegment)handle.element);
                List<IODeviceFeatureImplementation<?>> list = newDevice.getFeatures();
                Cleaner.Cleanable cleanable = newDevice.registerCleaningAction$bread_server_lib(() -> WindowsSystemDeviceIODeviceFeature.open$lambda$0(handle));
                Intrinsics.checkNotNullExpressionValue(cleanable, "registerCleaningAction(...)");
                list.add(new WindowsIODeviceReleaseFeature(cleanable));
                return TuplesKt.to(newDevice, supportedFeatures);
            }
            creationDisposition = ArraysKt.contains(features2, StandardIOOpenFeatures.CREATE) ? (ArraysKt.contains(features2, FileIOOpenFeatures.TRUNCATE) ? WindowsCreationDisposition.CREATE_ALWAYS : WindowsCreationDisposition.OPEN_ALWAYS) : (ArraysKt.contains(features2, FileIOOpenFeatures.TRUNCATE) ? WindowsCreationDisposition.TRUNCATE_EXISTING : WindowsCreationDisposition.OPEN_EXISTING);
            OpenIODeviceFeatureIdentifier[] $this$any$iv = features2;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int e = 0; e < n; ++e) {
                OpenIODeviceFeatureIdentifier element$iv;
                OpenIODeviceFeatureIdentifier it = element$iv = $this$any$iv[e];
                boolean bl2 = false;
                if (!(it instanceof WindowsIOReOpenFeatures)) continue;
                bl = true;
                break block36;
            }
            bl = false;
        }
        Arena arena = ePA = bl ? Arena.ofConfined() : null;
        if (ePA != null) {
            MemorySegment parameters = ePA.allocate(WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS());
            WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwSize().set(parameters, 0L, (int)parameters.byteSize());
            int attributes = WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwFileAttributes().get(parameters, 0L);
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.READ_ONLY)) {
                attributes |= 1;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.READ_ONLY);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.HIDDEN)) {
                attributes |= 2;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.HIDDEN);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.SYSTEM)) {
                attributes |= 4;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.SYSTEM);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.ARCHIVE)) {
                attributes |= 0x20;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.ARCHIVE);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.TEMPORARY)) {
                attributes |= 0x100;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.TEMPORARY);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.ENCRYPT)) {
                attributes |= 0x4000;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.ENCRYPT);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenAttributeFeatures.REFS_INTEGRITY)) {
                attributes |= 0x8000;
                supportedFeatures.add(WindowsIOOpenAttributeFeatures.REFS_INTEGRITY);
            }
            WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwFileAttributes().set(parameters, 0L, attributes);
            WindowsFileAPILayoutsKt.getCREATEFILE3_EXTENDED_PARAMETERS_dwFileFlags().set(parameters, 0L, Companion.getFlags$bread_server_lib(features2, supportedFeatures));
            memorySegment = parameters;
        } else {
            memorySegment = MemorySegment.NULL;
        }
        MemorySegment extendedParameters = memorySegment;
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCreateFile3();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment handle = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment, desiredAccess, shareMode, creationDisposition.getId-pVg5ArA(), extendedParameters);
        Arena arena2 = ePA;
        if (arena2 != null) {
            arena2.close();
        }
        try {
            WindowsUtilitiesKt.decodeWin32Error(WindowsUtilitiesKt.getWin32LastError());
            switch (WhenMappings.$EnumSwitchMapping$1[creationDisposition.ordinal()]) {
                case 1: 
                case 2: {
                    supportedFeatures.add(StandardIOOpenFeatures.CREATE);
                    break;
                }
                case 3: {
                    supportedFeatures.add(FileIOOpenFeatures.TRUNCATE);
                }
            }
        }
        catch (WindowsLastErrorException e) {
            WindowsLastError windowsLastError = e.getError().getEnum();
            block6 : switch (windowsLastError == null ? -1 : WhenMappings.$EnumSwitchMapping$0[windowsLastError.ordinal()]) {
                case 1: {
                    return null;
                }
                case 2: {
                    switch (WhenMappings.$EnumSwitchMapping$1[creationDisposition.ordinal()]) {
                        case 1: {
                            supportedFeatures.add(FileIOOpenFeatures.TRUNCATE);
                            break block6;
                        }
                        case 2: {
                            break block6;
                        }
                    }
                    throw e;
                }
                default: {
                    if (!Intrinsics.areEqual(handle, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) break;
                    throw e;
                }
            }
        }
        if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.DELETE_ON_RESTART) && WindowsKernelHandlesKt.getNativeMoveFileWithProgressW() != null) {
            int status = WindowsKernelHandlesKt.getNativeMoveFileWithProgressW().invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL, 4);
            if (status == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
            supportedFeatures.add(WindowsIOReOpenFeatures.DELETE_ON_RESTART);
        }
        WindowsIODevice newDevice = new WindowsIODevice(handle);
        List<IODeviceFeatureImplementation<?>> list = newDevice.getFeatures();
        Cleaner.Cleanable cleanable = newDevice.registerCleaningAction$bread_server_lib(() -> WindowsSystemDeviceIODeviceFeature.open$lambda$2(handle));
        Intrinsics.checkNotNullExpressionValue(cleanable, "registerCleaningAction(...)");
        list.add(new WindowsIODeviceReleaseFeature(cleanable));
        return TuplesKt.to(newDevice, supportedFeatures);
    }

    private static final Unit open$lambda$0(Ref.ObjectRef $handle) {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCloseHandle();
        Intrinsics.checkNotNull(methodHandle);
        if (methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), (MemorySegment)$handle.element) == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit open$lambda$2(MemorySegment $handle) {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeCloseHandle();
        Intrinsics.checkNotNull(methodHandle);
        if (methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), $handle) == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\r\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0000\u00a2\u0006\u0004\b\u000f\u0010\fJ-\u0010\u0010\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0004\b\u0011\u0010\fJ-\u0010\u0012\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0000\u00a2\u0006\u0004\b\u0013\u0010\fJ-\u0010\u0014\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0004\b\u0015\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceIODeviceFeature$Companion;", "", "<init>", "()V", "getDesiredAccessO", "", "features", "", "Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;", "supportedFeatures", "", "getDesiredAccessO$bread_server_lib", "([Lorg/bread_experts_group/api/system/device/io/open/OpenIODeviceFeatureIdentifier;Ljava/util/List;)I", "getDesiredAccess", "Lorg/bread_experts_group/api/system/device/io/open/ReOpenIODeviceFeatureIdentifier;", "getDesiredAccess$bread_server_lib", "getShareModeO", "getShareModeO$bread_server_lib", "getShareMode", "getShareMode$bread_server_lib", "getFlags", "getFlags$bread_server_lib", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDesiredAccessO$bread_server_lib(@NotNull OpenIODeviceFeatureIdentifier[] features2, @NotNull List<OpenIODeviceFeatureIdentifier> supportedFeatures) {
            Intrinsics.checkNotNullParameter(features2, "features");
            Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
            return this.getDesiredAccess$bread_server_lib(features2, TypeIntrinsics.asMutableList(supportedFeatures));
        }

        public final int getDesiredAccess$bread_server_lib(@NotNull OpenIODeviceFeatureIdentifier[] features2, @NotNull List<ReOpenIODeviceFeatureIdentifier> supportedFeatures) {
            int n;
            Intrinsics.checkNotNullParameter(features2, "features");
            Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
            boolean rC = ArraysKt.contains(features2, FileIOReOpenFeatures.READ);
            boolean wC = ArraysKt.contains(features2, FileIOReOpenFeatures.WRITE);
            boolean eC = ArraysKt.contains(features2, FileIOReOpenFeatures.EXECUTE);
            if (rC && wC && eC) {
                supportedFeatures.add(FileIOReOpenFeatures.READ);
                supportedFeatures.add(FileIOReOpenFeatures.WRITE);
                supportedFeatures.add(FileIOReOpenFeatures.EXECUTE);
                n = (int)WindowsGenericAccessRights.GENERIC_ALL.getPosition();
            } else {
                int localAR = 0;
                if (rC) {
                    localAR = (int)WindowsGenericAccessRights.GENERIC_READ.getPosition();
                    supportedFeatures.add(FileIOReOpenFeatures.READ);
                }
                if (wC) {
                    localAR |= (int)WindowsGenericAccessRights.GENERIC_WRITE.getPosition();
                    supportedFeatures.add(FileIOReOpenFeatures.WRITE);
                }
                if (eC) {
                    localAR |= (int)WindowsGenericAccessRights.GENERIC_EXECUTE.getPosition();
                    supportedFeatures.add(FileIOReOpenFeatures.EXECUTE);
                }
                n = localAR;
            }
            return n;
        }

        public final int getShareModeO$bread_server_lib(@NotNull OpenIODeviceFeatureIdentifier[] features2, @NotNull List<OpenIODeviceFeatureIdentifier> supportedFeatures) {
            Intrinsics.checkNotNullParameter(features2, "features");
            Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
            return this.getShareMode$bread_server_lib(features2, TypeIntrinsics.asMutableList(supportedFeatures));
        }

        public final int getShareMode$bread_server_lib(@NotNull OpenIODeviceFeatureIdentifier[] features2, @NotNull List<ReOpenIODeviceFeatureIdentifier> supportedFeatures) {
            int shareMode;
            Intrinsics.checkNotNullParameter(features2, "features");
            Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
            if (ArraysKt.contains(features2, FileIOReOpenFeatures.SHARE_READ)) {
                supportedFeatures.add(FileIOReOpenFeatures.SHARE_READ);
                v0 = (int)WindowsFileSharingTypes.FILE_SHARE_READ.getPosition();
            } else {
                v0 = shareMode = 0;
            }
            if (ArraysKt.contains(features2, FileIOReOpenFeatures.SHARE_WRITE)) {
                shareMode |= (int)WindowsFileSharingTypes.FILE_SHARE_WRITE.getPosition();
                supportedFeatures.add(FileIOReOpenFeatures.SHARE_WRITE);
            }
            return shareMode;
        }

        public final int getFlags$bread_server_lib(@NotNull OpenIODeviceFeatureIdentifier[] features2, @NotNull List<OpenIODeviceFeatureIdentifier> supportedFeatures) {
            Intrinsics.checkNotNullParameter(features2, "features");
            Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
            int flags = 0;
            if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.DISABLE_REMOTE_RECALL)) {
                flags = 0x100000;
                supportedFeatures.add(WindowsIOReOpenFeatures.DISABLE_REMOTE_RECALL);
            }
            if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.OPEN_REPARSE_POINT)) {
                flags |= 0x200000;
                supportedFeatures.add(WindowsIOReOpenFeatures.OPEN_REPARSE_POINT);
            }
            if (ArraysKt.contains(features2, WindowsIOOpenFeatures.DISABLE_REDIRECTION)) {
                flags |= 0x10000;
                supportedFeatures.add(WindowsIOOpenFeatures.DISABLE_REDIRECTION);
            }
            if (ArraysKt.contains(features2, StandardIOOpenFeatures.DIRECTORY)) {
                flags = 0x2000000;
                supportedFeatures.add(StandardIOOpenFeatures.DIRECTORY);
            } else {
                if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.DELETE_ON_RELEASE)) {
                    flags |= 0x4000000;
                    supportedFeatures.add(WindowsIOReOpenFeatures.DELETE_ON_RELEASE);
                }
                if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.OPTIMIZE_SEQUENTIAL_ACCESS)) {
                    flags |= 0x8000000;
                    supportedFeatures.add(WindowsIOReOpenFeatures.OPTIMIZE_SEQUENTIAL_ACCESS);
                }
                if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.OPTIMIZE_RANDOM_ACCESS)) {
                    flags |= 0x10000000;
                    supportedFeatures.add(WindowsIOReOpenFeatures.OPTIMIZE_RANDOM_ACCESS);
                }
                if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.DISABLE_SYSTEM_BUFFERING)) {
                    flags |= 0x20000000;
                    supportedFeatures.add(WindowsIOReOpenFeatures.DISABLE_SYSTEM_BUFFERING);
                }
                if (ArraysKt.contains(features2, WindowsIOReOpenFeatures.WRITE_THROUGH)) {
                    flags |= Integer.MIN_VALUE;
                    supportedFeatures.add(WindowsIOReOpenFeatures.WRITE_THROUGH);
                }
            }
            return flags | 0x1000000;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WindowsLastError.values().length];
            try {
                nArray[WindowsLastError.ERROR_FILE_NOT_FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsLastError.ERROR_ALREADY_EXISTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WindowsCreationDisposition.values().length];
            try {
                nArray[WindowsCreationDisposition.CREATE_ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsCreationDisposition.OPEN_ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsCreationDisposition.TRUNCATE_EXISTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

