/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.Mappable;
import org.bread_experts_group.MappedEnumeration;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.GUID;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMHandlesKt;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMNotifyAction;
import org.bread_experts_group.ffi.windows.cfgmgr.WindowsCMNotifyEventData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J0\u0010\u001e\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0016H\u0002R}\u0010\u0004\u001an\u0012j\u0012h\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceManager;", "", "<init>", "()V", "actions", "", "Lkotlin/Function4;", "Ljava/lang/foreign/MemorySegment;", "Lkotlin/ParameterName;", "name", "hNotify", "context", "Lorg/bread_experts_group/MappedEnumeration;", "Lkotlin/UInt;", "Lorg/bread_experts_group/ffi/windows/cfgmgr/WindowsCMNotifyAction;", "action", "Lorg/bread_experts_group/ffi/windows/cfgmgr/WindowsCMNotifyEventData;", "eventData", "", "getActions", "()Ljava/util/List;", "events", "", "eventArena", "Ljava/lang/foreign/Arena;", "eventsNotifier", "startUpEvents", "shutDownEvents", "listen", "unlisten", "execInternal", "eventDataSize", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsSystemDeviceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSystemDeviceManager.kt\norg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Mappable.kt\norg/bread_experts_group/Mappable$Companion\n*L\n1#1,110:1\n1869#2:111\n295#2:114\n296#2:116\n1870#2:119\n14#3,2:112\n16#3:115\n18#3,2:117\n*S KotlinDebug\n*F\n+ 1 WindowsSystemDeviceManager.kt\norg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceManager\n*L\n101#1:111\n104#1:114\n104#1:116\n101#1:119\n104#1:112,2\n104#1:115\n104#1:117,2\n*E\n"})
public final class WindowsSystemDeviceManager {
    @NotNull
    public static final WindowsSystemDeviceManager INSTANCE = new WindowsSystemDeviceManager();
    @NotNull
    private static final List<Function4<MemorySegment, MemorySegment, MappedEnumeration<UInt, WindowsCMNotifyAction>, WindowsCMNotifyEventData, Unit>> actions = new ArrayList();
    private static int events;
    @Nullable
    private static Arena eventArena;
    @NotNull
    private static MemorySegment eventsNotifier;

    private WindowsSystemDeviceManager() {
    }

    @NotNull
    public final List<Function4<MemorySegment, MemorySegment, MappedEnumeration<UInt, WindowsCMNotifyAction>, WindowsCMNotifyEventData, Unit>> getActions() {
        return actions;
    }

    private final void startUpEvents() {
        Arena newArena = Arena.ofConfined();
        Object[] objectArray = new Class[]{MemorySegment.class, Integer.TYPE, MemorySegment.class, Integer.TYPE};
        MethodHandle methodHandle = MethodHandles.lookup().findSpecial(this.getClass(), "execInternal", MethodType.methodType(Integer.TYPE, MemorySegment.class, objectArray), this.getClass()).bindTo(this);
        objectArray = new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT};
        MemorySegment callbackPtr = ForeignFunctionInterfaceKt.getNativeLinker().upcallStub(methodHandle, FunctionDescriptor.of(ValueLayout.JAVA_INT, (MemoryLayout[])objectArray), newArena, new Linker.Option[0]);
        MemorySegment filter = newArena.allocate(WindowsLayoutsKt.getCM_NOTIFY_FILTER());
        WindowsLayoutsKt.getCM_NOTIFY_FILTER_cbSize().set(filter, 0, (int)filter.byteSize());
        WindowsLayoutsKt.getCM_NOTIFY_FILTER_Flags().set(filter, 0, 1);
        WindowsLayoutsKt.getCM_NOTIFY_FILTER_FilterType().set(filter, 0, 0);
        MethodHandle methodHandle2 = WindowsCMHandlesKt.getNativeCM_Register_Notification();
        Intrinsics.checkNotNull(methodHandle2);
        int status = methodHandle2.invokeExact(filter, MemorySegment.NULL, callbackPtr, WindowsUtilitiesKt.getThreadLocalPTR());
        if (status != 0) {
            String string = "Ret: " + status;
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        MemorySegment memorySegment = WindowsUtilitiesKt.getThreadLocalPTR().get(ValueLayout.ADDRESS, 0L);
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        eventsNotifier = memorySegment;
        eventArena = newArena;
    }

    private final void shutDownEvents() {
        if (Intrinsics.areEqual(eventsNotifier, MemorySegment.NULL)) {
            return;
        }
        MethodHandle methodHandle = WindowsCMHandlesKt.getNativeCM_Unregister_Notification();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(eventsNotifier);
        if (status != 0) {
            String string = "Ret: " + status;
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        MemorySegment memorySegment = MemorySegment.NULL;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
        eventsNotifier = memorySegment;
        Arena arena = eventArena;
        if (arena != null) {
            arena.close();
        }
        eventArena = null;
    }

    public final void listen() {
        int n = events;
        events = n + 1;
        if (n == 0) {
            this.startUpEvents();
        }
    }

    public final void unlisten() {
        if ((events += -1) == 0) {
            this.shutDownEvents();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int execInternal(MemorySegment hNotify, MemorySegment context, int action, MemorySegment eventData, int eventDataSize) {
        MemorySegment eventDataSegment = eventData.reinterpret(eventDataSize);
        int filter = WindowsLayoutsKt.getCM_NOTIFY_EVENT_DATA_FilterType().get(eventDataSegment, 0);
        if (filter != 0) {
            String string = "Filter #" + filter;
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        GUID gUID = new GUID(WindowsLayoutsKt.getCM_NOTIFY_EVENT_DATA_u_DeviceInterface_ClassGuid().invokeExact(eventDataSegment, 0L));
        MemorySegment memorySegment = WindowsLayoutsKt.getCM_NOTIFY_EVENT_DATA_u_DeviceInterface_SymbolicLink().invokeExact(eventDataSegment, 0L).reinterpret((long)eventDataSize - (WindowsUtilitiesKt.getDWORD().byteSize() * (long)2 + WindowsLayoutsKt.getGUID().byteSize()));
        Intrinsics.checkNotNullExpressionValue(memorySegment, "reinterpret(...)");
        WindowsCMNotifyEventData.DeviceInterface eventDataDecoded = new WindowsCMNotifyEventData.DeviceInterface(gUID, memorySegment);
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v2;
            void n$iv;
            Function4 function4;
            MemorySegment memorySegment2;
            MemorySegment memorySegment3;
            block3: {
                void $this$id$iv;
                Function4 it = (Function4)element$iv;
                boolean bl = false;
                Mappable.Companion companion = Mappable.Companion;
                EnumEntries<WindowsCMNotifyAction> enumEntries = WindowsCMNotifyAction.getEntries();
                UInt uInt = UInt.box-impl(UInt.constructor-impl(action));
                memorySegment3 = context;
                memorySegment2 = hNotify;
                function4 = it;
                boolean $i$f$id = false;
                Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Enum it$iv = (Enum)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v2 = element$iv$iv;
                    break block3;
                }
                v2 = null;
            }
            void var28_30 = n$iv;
            Enum enum_ = v2;
            MappedEnumeration<void, Enum> mappedEnumeration = new MappedEnumeration<void, Enum>(enum_, var28_30);
            function4.invoke(memorySegment2, memorySegment3, mappedEnumeration, eventDataDecoded);
        }
        return 0;
    }

    static {
        MemorySegment memorySegment = MemorySegment.NULL;
        Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
        eventsNotifier = memorySegment;
    }
}

